/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.base.exception.RunningException;
import com.huawei.elog.base.exception.ServiceException;
import com.huawei.elog.base.exception.StartException;
import com.huawei.elog.base.model.Program;
import com.huawei.elog.common.StreamProcUtil;
import com.huawei.elog.util.ProgramUtil;
import com.huawei.elog.util.ServiceUtil;
import com.huawei.elog.util.StartsvcUtil;
import com.huawei.elog.util.WindowUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CollectorUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectorUtil.class);

    public static boolean isCentralizedDeploying() {
        String installedFile = WindowUtil.getInstallPath() + "/ddosCollectorInstalled.xml";
        File file = new File(installedFile);
        SAXReader sax = new SAXReader();
        boolean iscd = false;
        try {
            if (!file.exists()) {
                LOGGER.info("==no ddos collector.==", (Object)"isCentralizedDeploying");
                return false;
            }
            Document document = sax.read(file);
            List list = document.selectNodes("/install/iscentralizeddeploying");
            if (null != list && !list.isEmpty()) {
                Element ele = (Element)list.get(0);
                iscd = Boolean.parseBoolean(ele.getTextTrim());
            }
        }
        catch (DocumentException e) {
            LOGGER.debug("find isCentralizedDeploying in + IOException", (Throwable)e);
            return false;
        }
        LOGGER.info("is isCentralizedDeploying the ddos collector ? : " + iscd, (Object)"isCentralizedDeploying");
        return iscd;
    }

    public static void checkElogCollector() {
        if (ServiceUtil.isServiceRunning("DDOSCOLLECTORSVC")) {
            throw new StartException(20007L);
        }
        if (ServiceUtil.isServiceRunning("ATICCOLLECTORGUARDSERVICE")) {
            throw new StartException(20007L);
        }
    }

    public static void startElogCollector() {
        StartsvcUtil.startService("DDOSCOLLECTORSVC");
        StartsvcUtil.startService("ATICCOLLECTORGUARDSERVICE");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findType() {
        Runtime runtime = Runtime.getRuntime();
        BufferedReader bufReader = null;
        InputStreamReader inStreamReader = null;
        InputStream inStream = null;
        Process process = null;
        String type = null;
        try {
            String str = "cmd /c systeminfo | findstr \"based\"";
            process = runtime.exec(str);
            inStream = process.getInputStream();
            inStreamReader = new InputStreamReader(inStream, "utf-8");
            bufReader = new BufferedReader(inStreamReader);
            String listeningCmdLine = bufReader.readLine();
            while (null != listeningCmdLine) {
                if (listeningCmdLine.contains("based")) {
                    type = listeningCmdLine.split(":")[1].trim().substring(0, 3);
                    break;
                }
                listeningCmdLine = bufReader.readLine();
            }
            LOGGER.debug(type + "find System's type is:::", (Object)"findType");
        }
        catch (IOException e) {
            try {
                LOGGER.error(e + "find System's type Exception", (Object)"findType");
            }
            catch (Throwable throwable) {
                StreamProcUtil.close(bufReader);
                StreamProcUtil.close(inStreamReader);
                StreamProcUtil.close(inStream);
                StreamProcUtil.destroy(process);
                throw throwable;
            }
            StreamProcUtil.close(bufReader);
            StreamProcUtil.close(inStreamReader);
            StreamProcUtil.close(inStream);
            StreamProcUtil.destroy(process);
        }
        StreamProcUtil.close(bufReader);
        StreamProcUtil.close(inStreamReader);
        StreamProcUtil.close(inStream);
        StreamProcUtil.destroy(process);
        return type;
    }

    public static void shutdownElogCollector() {
        StartsvcUtil.stopService("ATICCOLLECTORGUARDSERVICE");
        StartsvcUtil.stopService("DDOSCOLLECTORSVC");
    }

    public static void collectorStartCheckPort() {
        try {
            CollectorUtil.checkPortIsUsed();
        }
        catch (RunningException e) {
            LOGGER.error("In CollectorUtil:RunningException", (Throwable)e);
        }
        catch (ServiceException e) {
            LOGGER.error("In CollectorUtil:ServiceException", (Throwable)e);
        }
        catch (StartException e) {
            LOGGER.error("In CollectorUtil:StartException", (Throwable)e);
        }
    }

    private static void checkPortIsUsed() {
        List<Program> lPro = null;
        lPro = ProgramUtil.getProgramListTakePortIllegally("collector", true);
        if (!lPro.isEmpty()) {
            Iterator<Program> it = lPro.iterator();
            StringBuffer portList = new StringBuffer();
            while (it.hasNext()) {
                Program pIt = it.next();
                List<Integer> iPort = pIt.getPorts();
                for (Integer p : iPort) {
                    portList.append(p).append(',');
                }
            }
            LOGGER.error("Port is used=" + portList.substring(0, portList.length() - 1), (Object)"checkPortIsUsed");
            throw new StartException(portList.substring(0, portList.length() - 1), 10002L);
        }
    }
}

