/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.base.constant.DefaultValueManager;
import com.huawei.elog.common.StreamProcUtil;
import com.huawei.elog.ui.util.RunningLock;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.OSUtil;
import com.huawei.elog.util.SystemExitUtil;
import com.huawei.elog.util.WindowUtil;
import com.huawei.elog.util.sdp.EncryptData;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLDecoder;
import java.text.Normalizer;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonUtil {
    public static final Double REQUIRE_FREE_DISK = 4.0;
    public static final Integer INTEGER_KB = 1024;
    public static final Integer MAXPORTLEN = 5;
    public static final Integer MAXPATHLEN = 60;
    public static final Integer MAXPWDLEN = 30;
    public static final String WRAP_CHAR = System.getProperty("line.separator");
    public static final String PARAM_NAME_VALUE_SEPRT = "  ";
    public static final String SECOND_SPACE_PRELINE = "          ";
    public static final NumberFormat CHINA_NUMBER_FORMATTER = NumberFormat.getInstance(Locale.CHINA);
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonUtil.class);

    public static String getInstallScene() {
        return ContextUtil.getStrValueFromCtx("esight.install.scene");
    }

    public static boolean isIntegratedScene() {
        return "Integrated Scene".equals(CommonUtil.getInstallScene());
    }

    public static String getInstallPath() {
        String installPath = null;
        if (OSUtil.isWindows()) {
            installPath = WindowUtil.getInstallPath();
        }
        return installPath;
    }

    public static String decrypt(String text) {
        String result = null;
        if (null != text) {
            EncryptData encryptData = EncryptData.getInstanse();
            result = encryptData.decrypt(text);
        }
        return result;
    }

    public static ENUM_DBTYPE getDefaultDbType() {
        String strdbtype = DefaultValueManager.getInstance().getDefaultValue("DBType");
        int ndbType = 0;
        ENUM_DBTYPE retValue = ENUM_DBTYPE.ORACLE;
        if (!"".equals(strdbtype)) {
            ndbType = Integer.parseInt(strdbtype);
        }
        switch (ndbType) {
            case 1: {
                retValue = ENUM_DBTYPE.MYSQL;
                break;
            }
            case 0: {
                retValue = ENUM_DBTYPE.ORACLE;
                break;
            }
            case 2: {
                retValue = ENUM_DBTYPE.SQLSERVER;
                break;
            }
        }
        return retValue;
    }

    public static boolean passwordContainSpecialCharacter(String dbPsd) {
        Pattern pattern = Pattern.compile("^[a-zA-Z|0-9|=|\\-|_|\\!|@|#|\\$|%|/|;|\\*|\\^|\\||:|,|\\.|\\+|}|{]+$");
        Matcher matcher = pattern.matcher(dbPsd = Normalizer.normalize(dbPsd, Normalizer.Form.NFKC));
        return !matcher.find();
    }

    public static boolean passwordContainSpecialCharacterForSqlServer(String dbPassword) {
        dbPassword = Normalizer.normalize(dbPassword, Normalizer.Form.NFKC);
        Pattern pattern = Pattern.compile("!|\\$|%|&|=|\\\\|\"|'|,|;|<|>");
        Matcher matcher = pattern.matcher(dbPassword);
        boolean found = matcher.find();
        return found;
    }

    public static String getClassPath(Class<?> clazz) {
        try {
            return URLDecoder.decode(CommonUtil.getClassPathFile(clazz).getCanonicalPath(), "UTF-8");
        }
        catch (IOException e) {
            LOGGER.error("exception:", (Throwable)e);
            return "";
        }
    }

    public static File getClassPathFile(Class<?> clazz) {
        File file = CommonUtil.getClassFile(clazz);
        int count = clazz.getName().split("[.]").length;
        for (int i = 0; i < count; ++i) {
            file = file.getParentFile();
        }
        if (file.getName().toUpperCase(Locale.ENGLISH).endsWith(".JAR!")) {
            file = file.getParentFile();
        }
        return file;
    }

    public static File getClassFile(Class<?> clazz) {
        URL path = clazz.getResource(clazz.getName().substring(clazz.getName().lastIndexOf(".") + 1) + ".classs");
        if (path == null) {
            String name = clazz.getName().replaceAll("[.]", "/");
            path = clazz.getResource("/" + name + ".class");
        }
        return new File(path.getFile());
    }

    private static boolean validateCmd(String[] lstPara) {
        String[] badInput = new String[]{"&&", "&", "||", "|", ";", "$", ">", ">>", "<"};
        for (String cmdLine : lstPara) {
            for (String bad : badInput) {
                if (!cmdLine.contains(bad)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getScriptResult(String[] lstPara) {
        StringBuilder retValue;
        block9: {
            retValue = new StringBuilder();
            BufferedReader stdout = null;
            Process p = null;
            InputStreamReader inReaderTemp = null;
            try {
                String line;
                if (!CommonUtil.validateCmd(lstPara)) {
                    LOGGER.error("executeCommand error, command is valid.");
                    throw new IOException();
                }
                ProcessBuilder pb = new ProcessBuilder(lstPara);
                pb.redirectErrorStream(true);
                p = pb.start();
                inReaderTemp = new InputStreamReader(p.getInputStream(), "utf-8");
                stdout = new BufferedReader(inReaderTemp);
                while ((line = stdout.readLine()) != null) {
                    retValue.append(line);
                }
                try {
                    p.waitFor();
                }
                catch (InterruptedException e) {
                    LOGGER.error("In CommonUtil : getScriptResult Exception: ", (Throwable)e);
                }
                StreamProcUtil.close(stdout);
            }
            catch (IOException e) {
                LOGGER.error("In CommonUtil : getScriptResult Exception: ", (Throwable)e);
                break block9;
            }
            finally {
                StreamProcUtil.close(stdout);
                StreamProcUtil.close(inReaderTemp);
                StreamProcUtil.destroy(p);
            }
            StreamProcUtil.close(inReaderTemp);
            StreamProcUtil.destroy(p);
        }
        LOGGER.debug("retValue=" + retValue);
        return retValue.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isNotUsePort(String portFile, String http) {
        FileInputStream inStremTemp;
        InputStreamReader fileReader;
        BufferedReader br;
        block10: {
            boolean bl;
            block9: {
                boolean bl2;
                block8: {
                    String reader = "";
                    String port = "";
                    br = null;
                    fileReader = null;
                    inStremTemp = null;
                    try {
                        inStremTemp = new FileInputStream(new File(portFile));
                        fileReader = new InputStreamReader((InputStream)inStremTemp, "utf-8");
                        br = new BufferedReader(fileReader);
                        while ((reader = br.readLine()) != null) {
                            port = reader.substring(reader.indexOf("=") + 1);
                            if (port.equals(http) && !"".equals(http)) {
                                bl2 = false;
                                StreamProcUtil.close(br);
                                break block8;
                            }
                            if (!port.equals(http) || "".equals(http)) continue;
                            bl = false;
                            StreamProcUtil.close(br);
                            break block9;
                        }
                        StreamProcUtil.close(br);
                        break block10;
                    }
                    catch (IOException e) {
                        LOGGER.error("close io occurs error.", (Throwable)e);
                        return true;
                    }
                }
                StreamProcUtil.close(fileReader);
                StreamProcUtil.close((InputStream)inStremTemp);
                return bl2;
            }
            StreamProcUtil.close(fileReader);
            StreamProcUtil.close((InputStream)inStremTemp);
            return bl;
        }
        StreamProcUtil.close(fileReader);
        StreamProcUtil.close((InputStream)inStremTemp);
        return true;
        finally {
            StreamProcUtil.close(br);
            StreamProcUtil.close(fileReader);
            StreamProcUtil.close((InputStream)inStremTemp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void createTemplateFile(String templateFilePath, String createdFileName, String servIp) {
        Configuration cfg = null;
        HashMap<String, String> configSource = null;
        cfg = new Configuration();
        cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.IGNORE_HANDLER);
        FileOutputStream fOutStrm = null;
        OutputStreamWriter out = null;
        try {
            File templateFile = new File(templateFilePath);
            cfg.setDirectoryForTemplateLoading(templateFile);
            Template template = cfg.getTemplate("collector.conf");
            fOutStrm = new FileOutputStream(createdFileName);
            out = new OutputStreamWriter((OutputStream)fOutStrm, "GBK");
            configSource = new HashMap<String, String>();
            configSource.put("ddos_server_ip", servIp);
            template.process(configSource, (Writer)out);
            LOGGER.debug(servIp + "createTemplateFile", (Object)"createTemplateFile");
        }
        catch (IOException e) {
            LOGGER.error("create module file faild:" + e + "createDDoSServerIPFile", (Object)"createTemplateFile");
            StreamProcUtil.close(out);
            StreamProcUtil.close(fOutStrm);
        }
        catch (TemplateException e2) {
            LOGGER.error("create module file faild:" + (Object)((Object)e2) + "createDDoSServerIPFile", (Object)"createTemplateFile");
            {
                catch (Throwable throwable) {
                    StreamProcUtil.close(out);
                    StreamProcUtil.close(fOutStrm);
                    throw throwable;
                }
            }
            StreamProcUtil.close(out);
            StreamProcUtil.close(fOutStrm);
        }
        StreamProcUtil.close((Writer)out);
        StreamProcUtil.close(fOutStrm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void createTemplateFile(String templateFilePath, String temFileName, String createdFileName, Map<String, Object> configSource) {
        FileOutputStream outStreamTemp;
        OutputStreamWriter out;
        block7: {
            out = null;
            Configuration cfg = null;
            cfg = new Configuration();
            cfg.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
            cfg.setTemplateExceptionHandler(TemplateExceptionHandler.IGNORE_HANDLER);
            outStreamTemp = null;
            try {
                File templateFile = new File(templateFilePath);
                if (templateFile.exists()) {
                    cfg.setDirectoryForTemplateLoading(templateFile);
                    Template template = cfg.getTemplate(temFileName);
                    outStreamTemp = new FileOutputStream(createdFileName);
                    out = new OutputStreamWriter((OutputStream)outStreamTemp, "GBK");
                    template.process(configSource, (Writer)out);
                    ((Writer)out).flush();
                    break block7;
                }
                LOGGER.debug("the file is not exists.createTemplateFile", (Object)"createTemplateFile");
            }
            catch (IOException e) {
                LOGGER.error("create module file faild:" + e + "createDDoSServerIPFile", (Object)"createTemplateFile");
                StreamProcUtil.close(out);
                StreamProcUtil.close((OutputStream)outStreamTemp);
            }
            catch (TemplateException e2) {
                LOGGER.error("create module file faild:" + (Object)((Object)e2) + "createDDoSServerIPFile", (Object)"createTemplateFile");
                {
                    catch (Throwable throwable) {
                        StreamProcUtil.close(out);
                        StreamProcUtil.close(outStreamTemp);
                        throw throwable;
                    }
                }
                StreamProcUtil.close(out);
                StreamProcUtil.close((OutputStream)outStreamTemp);
            }
        }
        StreamProcUtil.close(out);
        StreamProcUtil.close(outStreamTemp);
    }

    public static boolean createDir(String path) {
        boolean ret = false;
        File filePath = new File(path);
        if (!filePath.exists()) {
            ret = filePath.mkdir();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFolder(String oldPath, String newPath) {
        FileInputStream sIn = null;
        FileOutputStream sOut = null;
        try {
            boolean createResult = new File(newPath).mkdirs();
            LOGGER.debug("Create  File :" + createResult, (Object)"copyFolder");
            File a = new File(oldPath);
            String[] file = a.list();
            File temp = null;
            if (file != null && file.length != 0) {
                for (int i = 0; i < file.length; ++i) {
                    temp = oldPath.endsWith(File.separator) ? new File(oldPath + file[i]) : new File(oldPath + File.separator + file[i]);
                    if (temp.isFile()) {
                        int len;
                        sIn = new FileInputStream(temp);
                        sOut = new FileOutputStream(newPath + "/" + temp.getName());
                        byte[] b = new byte[2048];
                        while ((len = ((InputStream)sIn).read(b)) != -1) {
                            ((OutputStream)sOut).write(b, 0, len);
                        }
                        sOut.flush();
                        ((InputStream)sIn).close();
                        ((OutputStream)sOut).close();
                    }
                    if (!temp.isDirectory()) continue;
                    CommonUtil.copyFolder(oldPath + "/" + file[i], newPath + "/" + file[i]);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("copy folder occurs error: ", (Throwable)e);
        }
        finally {
            StreamProcUtil.close(sIn);
            StreamProcUtil.close(sOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileBuffered(File srcFile, String newDirectoryPath) {
        FileInputStream is = null;
        FileOutputStream os = null;
        try {
            is = new FileInputStream(srcFile);
            os = new FileOutputStream(newDirectoryPath + File.separator + srcFile.getName());
            int count = 0;
            byte[] b = new byte[8192];
            while ((count = ((InputStream)is).read(b)) != -1) {
                ((OutputStream)os).write(b, 0, count);
            }
        }
        catch (IOException e) {
            try {
                LOGGER.error("copyFileBuffered", (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamProcUtil.close(is);
                StreamProcUtil.close(os);
                throw throwable;
            }
            StreamProcUtil.close((InputStream)is);
            StreamProcUtil.close(os);
        }
        StreamProcUtil.close((InputStream)is);
        StreamProcUtil.close((OutputStream)os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readParamsFromTmp(String tmpFileName) {
        String ret = null;
        StringBuffer sb = new StringBuffer();
        FileInputStream fis = null;
        BufferedReader reader = null;
        InputStreamReader inReaderTemp = null;
        try {
            File tmpFile = new File(tmpFileName);
            if (tmpFile.exists()) {
                String line;
                fis = new FileInputStream(tmpFileName);
                inReaderTemp = new InputStreamReader((InputStream)fis, "UTF-8");
                reader = new BufferedReader(inReaderTemp);
                while ((line = reader.readLine()) != null) {
                    sb.append(line).append('\n');
                }
            }
            ret = sb.toString();
        }
        catch (IOException e) {
            try {
                LOGGER.error("File read failed: " + e + "replacedDDoSFile", (Object)"readParamsFromTmp");
            }
            catch (Throwable throwable) {
                StreamProcUtil.close(reader);
                StreamProcUtil.close(inReaderTemp);
                StreamProcUtil.close(fis);
                throw throwable;
            }
            StreamProcUtil.close(reader);
            StreamProcUtil.close(inReaderTemp);
            StreamProcUtil.close((InputStream)fis);
        }
        StreamProcUtil.close(reader);
        StreamProcUtil.close(inReaderTemp);
        StreamProcUtil.close((InputStream)fis);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String replacedKeyWithParamers(String templatePath, String fileContent, String findKey, String replaceKey) {
        FileInputStream fis = null;
        StringBuffer newsb = new StringBuffer();
        BufferedReader reader = null;
        InputStreamReader inReaderTemp = null;
        try {
            String line;
            fis = new FileInputStream(templatePath);
            inReaderTemp = new InputStreamReader((InputStream)fis, "UTF-8");
            reader = new BufferedReader(inReaderTemp);
            while ((line = reader.readLine()) != null) {
                if (line.trim().indexOf(findKey) >= 0) {
                    newsb.append(replaceKey + '\n');
                    line = line.replace(replaceKey, fileContent + replaceKey);
                }
                newsb.append(line).append('\n');
            }
        }
        catch (IOException e) {
            try {
                LOGGER.error("File read failed: " + e + "replacedDDoSFile", (Object)"replacedKeyWithParamers");
            }
            catch (Throwable throwable) {
                StreamProcUtil.close(reader);
                StreamProcUtil.close(inReaderTemp);
                StreamProcUtil.close((InputStream)fis);
                throw throwable;
            }
            StreamProcUtil.close(reader);
            StreamProcUtil.close(inReaderTemp);
            StreamProcUtil.close((InputStream)fis);
        }
        StreamProcUtil.close(reader);
        StreamProcUtil.close(inReaderTemp);
        StreamProcUtil.close((InputStream)fis);
        return newsb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String replacedKeyWithParamersOnDel(String templatePath, String findKey, String replaceKey) {
        FileInputStream fis = null;
        StringBuffer newsb = new StringBuffer();
        BufferedReader reader = null;
        InputStreamReader inReaderTemp = null;
        try {
            String line;
            fis = new FileInputStream(templatePath);
            inReaderTemp = new InputStreamReader((InputStream)fis, "UTF-8");
            reader = new BufferedReader(inReaderTemp);
            while ((line = reader.readLine()) != null) {
                if (line.trim().indexOf(findKey) >= 0) {
                    while ((line = reader.readLine()) != null && !line.trim().equals(replaceKey)) {
                    }
                }
                newsb.append(line).append('\n');
            }
        }
        catch (IOException e) {
            try {
                LOGGER.error("File read failed: ", (Object)e, (Object)"replacedDDoSFile");
            }
            catch (Throwable throwable) {
                StreamProcUtil.close(reader);
                StreamProcUtil.close(inReaderTemp);
                StreamProcUtil.close((InputStream)fis);
                throw throwable;
            }
            StreamProcUtil.close(reader);
            StreamProcUtil.close(inReaderTemp);
            StreamProcUtil.close((InputStream)fis);
        }
        StreamProcUtil.close(reader);
        StreamProcUtil.close(inReaderTemp);
        StreamProcUtil.close((InputStream)fis);
        return newsb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToWebFile(String templatePath, String fileContent) {
        OutputStreamWriter write = null;
        FileOutputStream fOutStrm = null;
        try {
            fOutStrm = new FileOutputStream(templatePath);
            write = new OutputStreamWriter((OutputStream)fOutStrm, "UTF-8");
            write.write(fileContent);
            ((Writer)write).flush();
            ((Writer)write).close();
        }
        catch (IOException e) {
            try {
                LOGGER.error("write to file error" + e + "replacedDDoSFile", (Object)"replacedKeyWithParamers");
            }
            catch (Throwable throwable) {
                StreamProcUtil.close(write);
                StreamProcUtil.close(fOutStrm);
                throw throwable;
            }
            StreamProcUtil.close((Writer)write);
            StreamProcUtil.close(fOutStrm);
        }
        StreamProcUtil.close((Writer)write);
        StreamProcUtil.close(fOutStrm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readParamsAndReplKeyFromTmp(String tmpFileName, String regkey, String replStr) {
        String ret = null;
        StringBuffer sb = new StringBuffer();
        FileInputStream fis = null;
        BufferedReader reader = null;
        InputStreamReader inReaderTemp = null;
        try {
            File tmpFile = new File(tmpFileName);
            if (tmpFile.exists()) {
                String line;
                fis = new FileInputStream(tmpFileName);
                inReaderTemp = new InputStreamReader((InputStream)fis, "UTF-8");
                reader = new BufferedReader(inReaderTemp);
                while ((line = reader.readLine()) != null) {
                    line = line.replaceAll(regkey, replStr);
                    sb.append(line).append('\n');
                }
            }
            ret = sb.toString();
        }
        catch (IOException e) {
            try {
                LOGGER.error("File read failed: " + e + "replacedDDoSFile", (Object)"readParamsAndReplKeyFromTmp");
            }
            catch (Throwable throwable) {
                StreamProcUtil.close(reader);
                StreamProcUtil.close(inReaderTemp);
                StreamProcUtil.close(fis);
                throw throwable;
            }
            StreamProcUtil.close(reader);
            StreamProcUtil.close(inReaderTemp);
            StreamProcUtil.close((InputStream)fis);
        }
        StreamProcUtil.close(reader);
        StreamProcUtil.close(inReaderTemp);
        StreamProcUtil.close((InputStream)fis);
        return ret;
    }

    public static String getFileSeparator() {
        return System.getProperties().getProperty("file.separator");
    }

    public static void shutDownJvm(int statusCode) {
        boolean b;
        LOGGER.warn("jvm will be shudown, statusCode: " + statusCode, (Object)"shutDownJvm");
        String silentProps = System.getProperty("user.home") + File.separator + "logcenter" + File.separator + "conf" + File.separator + "silent_install.ini";
        File file = new File(silentProps);
        if (file.exists() && !(b = file.delete())) {
            LOGGER.error("del file error.");
        }
        RunningLock.getInstance().deleteLockTempFile();
        SystemExitUtil.systemExit(statusCode);
    }

    public static enum ENUM_DBTYPE {
        ORACLE,
        MYSQL,
        SQLSERVER;

    }
}

