/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.model.ContextPropVal;
import com.huawei.elog.base.sdk.IPropertyMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.tools.ant.Project;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ContextUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContextUtil.class);

    public static void removePorp4Context(String key) {
        IPropertyMap map = InstallContext.getInstance().getPropertyMap();
        if (null != map && map.isContained(key)) {
            map.removeProp(key);
        }
        if (null != (map = InstallContext.getInstance().getEnvirments().getPropertyMap()) && map.isContained(key)) {
            map.removeProp(key);
        }
    }

    public static ContextPropVal getCpvValueFromCtx(String key) {
        if (null == key || key.trim().isEmpty()) {
            LOGGER.warn("argument key is null...");
            return null;
        }
        ContextPropVal cpv = InstallContext.getInstance().getPropertyMap().getProp(key);
        if (null == cpv) {
            cpv = InstallContext.getInstance().getEnvirments().getPropertyMap().getProp(key);
        }
        return cpv;
    }

    public static String getStrValueFromCtx(String key) {
        if (null == key || key.trim().isEmpty()) {
            LOGGER.warn("argument key is null... ", (Object)"CommonUtil");
            return null;
        }
        ContextPropVal cpv = InstallContext.getInstance().getPropertyMap().getProp(key);
        if (null == cpv && null == (cpv = InstallContext.getInstance().getEnvirments().getPropertyMap().getProp(key))) {
            return null;
        }
        Object obj = cpv.getValue();
        if (null == obj) {
            return null;
        }
        return String.valueOf(obj);
    }

    public static void saveSimpleValue2Ctx(String key, Object value) {
        ContextUtil.saveValue2Ctx(key, value, false, false, false);
    }

    public static void saveSearalizeValue2Ctx(String key, Object value) {
        ContextUtil.saveValue2Ctx(key, value, true, false, true);
    }

    public static void saveAntValue2Ctx(String key, Object value) {
        ContextUtil.saveValue2Ctx(key, value, true, false, false);
    }

    private static void saveValue2Ctx(String key, Object value, boolean antProperty, boolean modifiable, boolean searalize) {
        if (key == null || null == value) {
            return;
        }
        ContextPropVal propVal = new ContextPropVal();
        propVal.setIsAntProperty(antProperty);
        propVal.setModifiable(modifiable);
        propVal.setSearalize(searalize);
        propVal.setValue(value);
        InstallContext.getInstance().getPropertyMap().addProp(key, propVal);
    }

    public static void setAntPropertyByContext(Project antProject) {
        if (null == antProject) {
            return;
        }
        Map propMap = InstallContext.getInstance().getPropertyMap().getAllAntProps();
        for (Map.Entry entry : propMap.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            antProject.setUserProperty(key, val);
        }
        Map envMap = InstallContext.getInstance().getEnvirments().getPropertyMap().getAllAntProps();
        for (Map.Entry entry : envMap.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            if (propMap.containsKey(key)) continue;
            antProject.setUserProperty(key, val);
        }
    }

    public static void printUserSerialProperty() {
        Map propMap = InstallContext.getInstance().getPropertyMap().getAllSerialProps();
        Iterator iter = propMap.entrySet().iterator();
        LOGGER.debug(" ---------Serial Property Begin----------------");
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = (String)entry.getKey();
            Object val = entry.getValue();
            if (val instanceof ContextPropVal) {
                ContextPropVal cpv = (ContextPropVal)val;
                LOGGER.debug(key + "  --  " + cpv.getValue());
                continue;
            }
            LOGGER.debug(key + "  --  " + val);
        }
        LOGGER.debug(" ---------Serial Property End----------------");
    }
}

