/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.base.model.DataBaseInfo;
import com.huawei.elog.common.StreamProcUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DBConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBConnection.class);
    private static final String MYSQL_DATABASE_SQL = "SHOW DATABASES;";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getConnectedStatus(String user, String url, String password, String driver) {
        boolean isConnected = false;
        Connection conn = null;
        try {
            Class.forName(driver);
            LOGGER.info("DBConnection : url : " + url);
            conn = DriverManager.getConnection(url, user, password);
            isConnected = true;
        }
        catch (SQLException e) {
            LOGGER.error("DB Connection Test Error: " + e, (Object)"isConnected");
            isConnected = false;
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("DB Connection Test Error: " + e, (Object)"isConnected");
            isConnected = false;
        }
        finally {
            if (null != conn) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOGGER.error("isConnected", (Throwable)e);
                }
            }
        }
        LOGGER.info("DB Connection result: " + isConnected, (Object)"isConnected");
        return isConnected;
    }

    private String getDataBaseType(Connection conn) {
        String dataBaseType = null;
        try {
            DatabaseMetaData dbmd = conn.getMetaData();
            dataBaseType = dbmd.getDatabaseProductName();
        }
        catch (SQLException e) {
            LOGGER.error("isExistBizDatabase", (Throwable)e);
        }
        return dataBaseType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isExistBizDatabase(Connection conn) {
        ResultSet rs;
        Statement stmt;
        block11: {
            boolean bl;
            block10: {
                boolean bl2;
                block9: {
                    String dataBaseType = null;
                    if (null == conn) {
                        LOGGER.info("conn is null, and return value of the method of isExistBizDatabase is false..", (Object)"isExistBizDatabase");
                        return false;
                    }
                    dataBaseType = this.getDataBaseType(conn);
                    ArrayList<String> dbList = new ArrayList<String>();
                    stmt = null;
                    rs = null;
                    try {
                        block13: {
                            block14: {
                                block12: {
                                    stmt = conn.createStatement();
                                    boolean hasResultSet = false;
                                    if (!"MySQL".equalsIgnoreCase(dataBaseType)) break block12;
                                    hasResultSet = stmt.execute(MYSQL_DATABASE_SQL);
                                    if (!hasResultSet) break block13;
                                    break block14;
                                }
                                LOGGER.warn("Unkwon of the dbtype from the connection, dataBaseType: " + dataBaseType, (Object)"isExistBizDatabase");
                                bl2 = false;
                                StreamProcUtil.close(rs);
                                break block9;
                            }
                            rs = stmt.getResultSet();
                            while (rs.next()) {
                                if (!"MySQL".equalsIgnoreCase(dataBaseType)) continue;
                                dbList.add(rs.getString("Database"));
                            }
                        }
                        LOGGER.info("DB: " + dbList, (Object)"isExistBizDatabase");
                        if (dbList.contains("lego") || dbList.contains("elog")) {
                            LOGGER.debug("exist bizDataBase...", (Object)"isExistBizDatabase");
                            bl = true;
                            StreamProcUtil.close(rs);
                            break block10;
                        }
                        StreamProcUtil.close(rs);
                        break block11;
                    }
                    catch (SQLException e) {
                        LOGGER.error("isExistBizDatabase", (Throwable)e);
                        return false;
                    }
                }
                StreamProcUtil.close(stmt);
                return bl2;
            }
            StreamProcUtil.close(stmt);
            return bl;
        }
        StreamProcUtil.close(stmt);
        return false;
        finally {
            StreamProcUtil.close(rs);
            StreamProcUtil.close(stmt);
        }
    }

    public Connection connectionDB(DataBaseInfo dbInfor, String dbName) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dbExist(DataBaseInfo dbInfor, String dbName) {
        boolean succ = false;
        Connection conn = null;
        try {
            conn = this.connectionDB(dbInfor, dbName);
            if (conn != null) {
                succ = true;
                LOGGER.debug("true", (Object)"##----DBExist State----##");
            }
        }
        finally {
            if (null != conn) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOGGER.error("##----DBExist----##", (Throwable)e);
                }
            }
        }
        return succ;
    }
}

