/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.base.model.DataBaseInfo;
import com.huawei.elog.util.IDBConnection;
import com.huawei.elog.util.MysqlConnection;
import java.text.Normalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBConnectionFactory {
    private static final String MYSQL = "MySQL";
    private static MysqlConnection mysqlInstance = new MysqlConnection();
    private static final Logger LOGGER = LoggerFactory.getLogger(DBConnectionFactory.class);

    public static IDBConnection getInstance(DataBaseInfo dbInfo) {
        if (null == dbInfo) {
            LOGGER.error("Get database connection error, database information is null.", (Object)"getInstance");
            return null;
        }
        String dbType = dbInfo.getDbType();
        if (MYSQL.equalsIgnoreCase(dbType = Normalizer.normalize(dbType, Normalizer.Form.NFKC))) {
            return mysqlInstance;
        }
        return null;
    }
}

