/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public final class DefineHelper
extends DefaultHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefineHelper.class);
    private static DefineHelper defineHelp;
    private static List<String> listmap;
    private final Properties runLogProp = new Properties();
    private String key = null;

    private DefineHelper() {
    }

    public Properties getRunLogProp() {
        return this.runLogProp;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if ("value".equals(qName)) {
            try {
                this.key = attributes.getValue("name");
                listmap.add(this.key);
            }
            catch (Exception e) {
                LOGGER.error("close io occurs error.", (Throwable)e);
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.key = null;
    }

    public static synchronized DefineHelper getInstance(String path) {
        defineHelp = new DefineHelper();
        DefineHelper.reload(path);
        return defineHelp;
    }

    @Override
    public void characters(char[] chars, int start, int length) throws SAXException {
        if (this.key != null) {
            String message = new String(chars, start, length);
            this.runLogProp.put(this.key, message);
        }
    }

    public static void reload(String path) {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser parser = null;
        spf.setValidating(false);
        try {
            spf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            spf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            spf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            spf.setXIncludeAware(false);
            parser = spf.newSAXParser();
            File file = new File(path);
            listmap = new ArrayList<String>();
            parser.parse(file, (DefaultHandler)defineHelp);
        }
        catch (ParserConfigurationException e) {
            LOGGER.error("reload xml file occurs error: ", (Throwable)e);
        }
        catch (SAXException e) {
            LOGGER.error("reload xml file occurs error: ", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("reload xml file occurs error: ", (Throwable)e);
        }
    }

    static {
        listmap = new ArrayList<String>();
    }
}

