/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.common.StreamProcUtil;
import com.huawei.elog.util.CmdUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiskInfoFetcher {
    private static final Logger LOG = LoggerFactory.getLogger(DiskInfoFetcher.class);

    public static long getMaxFreeSize(String toolPath, String path) {
        long maxFreeSize = 0L;
        try {
            String[] childPath = DiskInfoFetcher.getChildrenPath(path);
            if (childPath == null || 0 == childPath.length) {
                return DiskInfoFetcher.getRootFreeSize(toolPath, path);
            }
            for (int i = 0; i < childPath.length; ++i) {
                long freeSize;
                File childDir = new File(childPath[i]);
                if (!childDir.isDirectory() || (freeSize = DiskInfoFetcher.getPathFreeSize(toolPath, childPath[i])) <= maxFreeSize) continue;
                maxFreeSize = freeSize;
            }
        }
        catch (Exception e) {
            LOG.error("getMaxFreeSize", (Throwable)e);
        }
        return maxFreeSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getPathFreeSize(String toolPath, String path) {
        long freeSize;
        block14: {
            if (null == toolPath || null == path) {
                return 0L;
            }
            File cmdFile = new File(toolPath);
            if (!cmdFile.exists()) {
                return 0L;
            }
            Process proc = null;
            freeSize = 0L;
            long totalSize = 0L;
            long usedSize = 0L;
            LineNumberReader input = null;
            InputStreamReader isReader = null;
            InputStream is = null;
            try {
                String data;
                if (!CmdUtil.validateCmd(toolPath)) {
                    LOG.error("executeCommand error, command is valid.");
                    long l = 0L;
                    return l;
                }
                if (!CmdUtil.validateCmd(path)) {
                    LOG.error("executeCommand error, command is valid.");
                    long l = 0L;
                    return l;
                }
                String command = toolPath + " " + path;
                proc = Runtime.getRuntime().exec(command);
                is = proc.getInputStream();
                if (null != is && null != (data = (input = new LineNumberReader(isReader = new InputStreamReader(is, "utf-8"))).readLine())) {
                    data = data.substring(data.indexOf("=") + 1);
                    totalSize = Integer.parseInt(data);
                }
                freeSize = totalSize - usedSize;
                StreamProcUtil.close(input);
            }
            catch (IOException e) {
                LOG.error("getPathFreeSize", (Throwable)e);
                break block14;
            }
            finally {
                StreamProcUtil.close(input);
                StreamProcUtil.close(isReader);
                StreamProcUtil.close(is);
                if (null != proc) {
                    proc.destroy();
                }
            }
            StreamProcUtil.close(isReader);
            StreamProcUtil.close(is);
            if (null != proc) {
                proc.destroy();
            }
        }
        return freeSize;
    }

    private static String[] getChildrenPath(String path) {
        File dir = new File(path);
        if (!dir.exists()) {
            return new String[0];
        }
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("data_");
            }
        };
        String[] childrenArray = dir.list(filter);
        if (null != childrenArray) {
            for (int i = 0; i < childrenArray.length; ++i) {
                childrenArray[i] = path + "/" + childrenArray[i];
            }
        }
        return childrenArray;
    }

    private static long getRootFreeSize(String toolPath, String path) {
        long freeSize = 0L;
        try {
            File file = new File(path);
            while (!file.exists() && null != path && path.length() >= 2 && null != file.getParentFile()) {
                file = file.getParentFile();
                path = file.getPath();
            }
            if (path != null) {
                freeSize = DiskInfoFetcher.getPathFreeSize(toolPath, path);
            }
        }
        catch (Exception e) {
            LOG.error("getMaxFreeSize", (Throwable)e);
        }
        return freeSize;
    }
}

