/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.util.Disk4FileSystem;
import com.huawei.elog.util.OSUtil;
import java.io.File;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiskUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DiskUtil.class);

    private DiskUtil() {
    }

    public static Disk4FileSystem gatherDiskInfo4OS(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            LOGGER.error("file path is empty, Please enter a non-blank path for your special folder.");
            return null;
        }
        File file = new File(path);
        if (!file.exists()) {
            LOGGER.info("file does not exist.");
        }
        Disk4FileSystem disk = null;
        if (OSUtil.isWindows()) {
            disk = DiskUtil.gatherDiskInfo4Windows(file.getPath());
        }
        return disk;
    }

    public static Disk4FileSystem gatherDiskInfo4Windows(String path) {
        Disk4FileSystem disk = new Disk4FileSystem();
        File[] fslist = File.listRoots();
        if (null == fslist) {
            LOGGER.error("fslist is null.");
            return disk;
        }
        for (File fs : fslist) {
            if (!path.toUpperCase(Locale.getDefault()).contains(fs.getPath())) continue;
            File file = new File(fs.getPath());
            disk.setTotal(file.getTotalSpace());
            disk.setFree(file.getFreeSpace());
            disk.setAvail(file.getUsableSpace());
            disk.setUsed(file.getTotalSpace() - file.getFreeSpace());
        }
        return disk;
    }
}

