/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.common.StreamProcUtil;
import com.huawei.elog.util.XmlWriterFactory;
import java.io.File;
import java.io.IOException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public abstract class DomUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(DomUtil.class);

    public static Document loadDocument(File filePath) {
        SAXReader reader = new SAXReader();
        try {
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (SAXException ex) {
            LOGGER.error("Set feature failed.", (Throwable)ex);
            return null;
        }
        Document document = null;
        if (filePath.exists()) {
            try {
                document = reader.read(filePath);
            }
            catch (DocumentException e) {
                LOGGER.error("parse document occurs error: ", (Throwable)e);
            }
        } else {
            LOGGER.error("parse document occurs error.");
        }
        return document;
    }

    public static void writeDocument(Document document, File file) {
        DomUtil.writeDocument(document, file, true, null, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeDocument(Document document, File file, boolean enableDtd, String dtdStr, String encoding, boolean expandEmptyElements) {
        if (null == document) {
            LOGGER.warn("document is null. writeDocument return null.");
            return;
        }
        if (enableDtd) {
            document.addDocType("config", null, null == dtdStr ? "configInfo.dtd" : dtdStr);
        }
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(null == encoding ? "UTF-8" : encoding);
        format.setExpandEmptyElements(expandEmptyElements);
        format.setLineSeparator(System.getProperty("line.separator"));
        format.setNewLineAfterDeclaration(false);
        XMLWriter writer = null;
        try {
            writer = XmlWriterFactory.getXmlWriter(file, format);
            writer.write(document);
        }
        catch (IOException e) {
            LOGGER.error("write document occurs error. {}", (Throwable)e);
        }
        finally {
            StreamProcUtil.close(writer);
        }
        LOGGER.info("write document successfully.");
    }
}

