/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.base.constant.DefaultValueManager;
import com.huawei.elog.util.CmdUtil;
import com.huawei.elog.util.FileUtil;
import com.huawei.elog.util.OSUtil;
import com.huawei.elog.util.WindowsGetMem;
import java.io.File;
import java.net.ServerSocket;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class EnvCheckUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(EnvCheckUtil.class);
    private static String systemCfgWindowsPath = "C:" + File.separator + "openssh" + File.separator + "system.cfg";
    private static String systemCfgLinuxPath = File.separator + "opt" + File.separator + "openssh" + File.separator + "system.cfg";
    private static String c00installPropFiles = File.separator + "uninstall" + File.separator + "data" + File.separator + "InstallStorage.properties";
    private static String c01installPropFiles = File.separator + "AppBase" + c00installPropFiles;
    private static String v3r1installPropFiles = File.separator + "uninstall" + File.separator + "etc" + File.separator + "config" + File.separator + "productType.dat";
    private static String appBasev3r1installPropFiles = File.separator + "AppBase" + v3r1installPropFiles;
    private static String ssoCfgAppDir = File.separator + "AppBase" + File.separator + "app" + File.separator + "sso.app";
    private static String ssoCfgEtcDir = File.separator + "AppBase" + File.separator + "etc" + File.separator + "oms.sso";

    public static String getOSType() {
        String osName = EnvCheckUtil.getOSName();
        if (osName.indexOf("Windows") != -1) {
            return "Windows";
        }
        if (osName.indexOf("SunOS") != -1) {
            return "SunOS";
        }
        if (osName.indexOf("Linux") != -1) {
            return "Linux";
        }
        return "Operating System " + osName + " is not supported.";
    }

    public static String getOSName() {
        String strOS = System.getProperty("os.name");
        return strOS;
    }

    public static String getOSVersion() {
        String verison = System.getProperty("os.name");
        if (!OSUtil.isWindows()) {
            String linuxVersion = CmdUtil.runShell("cat /etc/SuSE-release");
            LOGGER.debug("os version: {}", (Object)linuxVersion);
            if (StringUtils.isNotEmpty((CharSequence)linuxVersion)) {
                verison = linuxVersion.substring(0, 31);
            }
        }
        return verison;
    }

    public static boolean checkFTPService() {
        return !EnvCheckUtil.checkPortNotInUse(21);
    }

    public static boolean checkPortNotInUse(int port) {
        try {
            ServerSocket ss = new ServerSocket(port);
            ss.close();
            return true;
        }
        catch (Exception e) {
            LOGGER.error("port {} is used, can't bind listening socket.", (Object)port, (Object)e);
            return false;
        }
    }

    public static boolean checkOS(String wantOS) {
        String realName = System.getProperty("os.name");
        return wantOS.contains(realName);
    }

    public static boolean checkRAM(long wantSize) {
        return EnvCheckUtil.getMemory() > wantSize * 1024L;
    }

    public static long getMemory() {
        long totalMemorySize = 0L;
        if (OSUtil.isWindows()) {
            totalMemorySize = WindowsGetMem.getTotalMemInfo();
        }
        return totalMemorySize;
    }

    public static String getEsightBasePath() {
        String strInstallDir;
        String basePath = null;
        String cfgPath = EnvCheckUtil.getCfgPath();
        Properties prop = FileUtil.pass2PropertiesByPath(cfgPath);
        String productShortNameV2R3 = DefaultValueManager.getInstance().getDefaultValue("V2R3ProductShortName");
        String productShortNameV3R1 = DefaultValueManager.getInstance().getDefaultValue("V3R1ProductShortName");
        String unzipPath = DefaultValueManager.getInstance().getDefaultValue("UnzipPath");
        if (null == unzipPath || unzipPath.trim().isEmpty()) {
            unzipPath = "AppBase";
        }
        if (null == (strInstallDir = prop.getProperty(productShortNameV2R3))) {
            strInstallDir = prop.getProperty(productShortNameV3R1);
        }
        if (!"".equals(unzipPath)) {
            if (strInstallDir.endsWith(unzipPath)) {
                basePath = strInstallDir.substring(0, strInstallDir.length() - unzipPath.length() - 1);
            }
        } else {
            basePath = strInstallDir;
        }
        return basePath;
    }

    public static String getInstallDirByEnv() {
        File instFile;
        String oldPath = System.getProperty("ENT_ROOT");
        String fileName = null;
        if (!(oldPath.isEmpty() || (instFile = new File(fileName = oldPath + File.separator + c00installPropFiles)).exists() || (instFile = new File(fileName = oldPath + File.separator + c01installPropFiles)).exists())) {
            return null;
        }
        return fileName;
    }

    public static String getInstallDirByEnv(String oldPath) {
        String fileName = null;
        if (oldPath != null && !oldPath.isEmpty()) {
            fileName = oldPath + File.separator + c00installPropFiles;
            File instFile = new File(fileName);
            if (!instFile.exists()) {
                LOGGER.info("C00 InstallStorage.properties not exist..", (Object)"getInstallDirByEnv");
                fileName = oldPath + File.separator + c01installPropFiles;
                instFile = new File(fileName);
                if (!instFile.exists()) {
                    LOGGER.error("C01 InstallStorage.properties not exist.", (Object)"getInstallDirByEnv");
                    return null;
                }
                LOGGER.debug("C01 InstallStorage.properties exist.", (Object)"getInstallDirByEnv");
            } else {
                LOGGER.debug("C00 InstallStorage.properties exist.", (Object)"getInstallDirByEnv");
            }
        }
        return fileName;
    }

    public static String getV3R1InstallDirByEnv(String oldPath) {
        File instFile;
        String fileName = null;
        if (!(oldPath == null || oldPath.isEmpty() || (instFile = new File(fileName = oldPath + File.separator + v3r1installPropFiles)).exists() || (instFile = new File(fileName = oldPath + File.separator + appBasev3r1installPropFiles)).exists())) {
            return null;
        }
        return fileName;
    }

    public static boolean checkIfFirstInstall(String strDir) {
        File fileObj = new File(strDir + c00installPropFiles);
        return !fileObj.exists();
    }

    public static String getCfgPath() {
        String cfgPath = null;
        String osName = EnvCheckUtil.getOSName();
        if (osName.indexOf("Windows") != -1) {
            cfgPath = systemCfgWindowsPath;
        } else if (osName.indexOf("Linux") != -1) {
            cfgPath = systemCfgLinuxPath;
        } else {
            String errMsg = "Operating System " + osName + " is not supported.";
            LOGGER.error(errMsg, (Object)"getCfgPath");
        }
        return cfgPath;
    }

    public static boolean ssoAppisExist(String basePath) {
        File ssoAppDir = new File(basePath + ssoCfgAppDir);
        File ssoEtcDir = new File(basePath + ssoCfgEtcDir);
        return ssoAppDir.exists() && ssoEtcDir.exists();
    }
}

