/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.util.WindowUtil;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public final class EnvUtil {
    static final String ENV_KEY = "SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment";

    private EnvUtil() {
    }

    public static boolean setEnv(String key, String value, String envType) {
        boolean result = false;
        String regPath = "\"HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment\" /v \"" + key + "\" /t " + envType + " /d \"" + value + "\" /f";
        result = WindowUtil.writeRegPath(regPath);
        return result;
    }

    public static boolean hasEnv(String key) {
        boolean result = true;
        Map<String, String> regmap = WindowUtil.readRegPath("HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment");
        if (regmap.containsKey(key)) {
            return true;
        }
        return result;
    }

    public static String getEnv(String key) {
        String envValue = null;
        Map<String, String> regmap = WindowUtil.readRegPath("HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment");
        if (regmap.containsKey(key)) {
            return regmap.get(key);
        }
        return envValue;
    }

    public static String getReg(String key) {
        String envValue = null;
        Map<String, String> regmap = WindowUtil.readRegPath("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run");
        if (regmap.containsKey(key)) {
            return regmap.get(key);
        }
        return envValue;
    }

    public static boolean removeEnv(String key) {
        boolean result = true;
        Map<String, String> regmap = WindowUtil.readRegPath("HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment");
        if (regmap.containsKey(key)) {
            result = WindowUtil.removeRegPath("\"HKEY_LOCAL_MACHINE\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment\" /v \"" + key + "\" /f");
        }
        return result;
    }

    public static boolean removeReg(String key) {
        boolean result = true;
        Map<String, String> regmap = WindowUtil.readRegPath("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run");
        if (regmap.containsKey(key)) {
            result = WindowUtil.removeRegPath("\"HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Run\" /reg:64 /v \"" + key + "\" /f ");
        }
        return result;
    }

    public static File[] getInstalledSearalizeFileArray(String path) {
        File[] files;
        File f;
        if (StringUtils.isNotEmpty((CharSequence)path) && (f = new File(path)).exists() && f.isDirectory() && null != (files = f.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("Installed.xml");
            }
        })) && files.length > 0) {
            return files;
        }
        return new File[0];
    }
}

