/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.OSUtil;
import com.huawei.elog.util.PropertyManager;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendReplaceUtil {
    public static final double INDEX_HIGH_MB = 16000.0;
    public static final double INDEX_MED_MB = 8000.0;
    public static final double INDEX_LOW_MB = 4096.0;
    public static final double INDEX_MM_MB = 7000.0;
    public static final double HEIGHTMB = 4096.0;
    public static final double LOWMB = 2048.0;
    private static final double THREE = 3.2;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendReplaceUtil.class);
    private String basePath = ContextUtil.getStrValueFromCtx("lego.base.path");
    private String installScene = ContextUtil.getStrValueFromCtx("esight.install.scene");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double findMemory() {
        Runtime runtime = Runtime.getRuntime();
        BufferedReader bufReader = null;
        InputStreamReader inStreamReader = null;
        InputStream inStream = null;
        Process process = null;
        double mb = 0.0;
        try {
            String str = "cmd /c chcp 437 && cmd /c systeminfo | findstr \"Total\"";
            process = runtime.exec(str);
            inStream = process.getInputStream();
            inStreamReader = new InputStreamReader(inStream, "utf-8");
            bufReader = new BufferedReader(inStreamReader);
            String listeningCmdLine = bufReader.readLine();
            if (null != listeningCmdLine && !listeningCmdLine.startsWith("Total") && null != (listeningCmdLine = bufReader.readLine()) && listeningCmdLine.startsWith("Total")) {
                mb = Double.parseDouble(listeningCmdLine.split(":")[1].trim().split(" ")[0].replaceAll(",", ""));
            }
            LOGGER.info("find System's memory is:::" + mb + "MB", (Object)"findMemory");
        }
        catch (IOException e) {
            LOGGER.error(e + "find System's memory Exception", (Object)"findMemory");
        }
        finally {
            if (null != bufReader) {
                try {
                    bufReader.close();
                }
                catch (IOException e) {
                    LOGGER.error(e + "find System's memory IOException", (Object)"findMemory");
                }
            }
            if (null != inStreamReader) {
                try {
                    inStreamReader.close();
                }
                catch (IOException e) {
                    LOGGER.error(e + "find System's memory IOException", (Object)"findMemory");
                }
            }
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    LOGGER.error(e + "find System's memory IOException", (Object)"findMemory");
                }
            }
            if (null != process) {
                process.destroy();
            }
        }
        return mb;
    }

    public void replaceRunbat(String groupName, double mb, String fileName, boolean isLinux) {
        String cmd = ContextUtil.getStrValueFromCtx("lego.base.installpath") + File.separator + "Runtime/" + groupName + "/" + fileName;
        String xms = null;
        String xmx = null;
        String mmn = null;
        String other = null;
        double low = 2048.0;
        boolean isDemoScene = false;
        if ("Integrated Scene".equals(this.installScene) && mb <= 4096.0) {
            isDemoScene = true;
        }
        LOGGER.debug("isDemoScene: " + isDemoScene, (Object)"replaceRunbat");
        if (isDemoScene) {
            xms = PropertyManager.getProValue("VSM.LEGO.RUN.MEMORY.4GDEMO.XMS");
            xmx = PropertyManager.getProValue("VSM.LEGO.RUN.MEMORY.4GDEMO.XMX");
            mmn = PropertyManager.getProValue("VSM.LEGO.RUN.MEMORY.4GDEMO.MMN");
            other = PropertyManager.getProValue("VSM.LEGO.RUN.MEMORY.4GDEMO.OTHER");
        } else {
            if (0.0 <= mb && mb <= low) {
                xms = PropertyManager.getProValue("VSM.LEGO.RUN.MEMORY.LOW.XMS");
                xmx = PropertyManager.getProValue("VSM.LEGO.RUN.MEMORY.LOW.XMX");
                mmn = PropertyManager.getProValue("VSM.LEGO.RUN.MEMORY.LOW.MMN");
                other = PropertyManager.getProValue("VSM.LEGO.RUN.MEMORY.LOW.OTHER");
            }
            if (4096.0 <= mb) {
                if (!OSUtil.isX64()) {
                    xms = PropertyManager.getProValue("VSM.LEGO.RUN.MEMORY.HEIGH.XMS");
                    xmx = PropertyManager.getProValue("VSM.LEGO.RUN.MEMORY.HEIGH.XMX");
                    mmn = PropertyManager.getProValue("VSM.LEGO.RUN.MEMORY.HEIGH.MMN");
                    other = PropertyManager.getProValue("VSM.LEGO.RUN.MEMORY.HEIGH.OTHER");
                } else {
                    xms = PropertyManager.getProValue("VSM.LEGO.RUN.MEMORY.HEIGH.64XMS");
                    xmx = PropertyManager.getProValue("VSM.LEGO.RUN.MEMORY.HEIGH.64XMX");
                    mmn = PropertyManager.getProValue("VSM.LEGO.RUN.MEMORY.HEIGH.64MMN");
                    other = PropertyManager.getProValue("VSM.LEGO.RUN.MEMORY.HEIGH.64OTHER");
                }
            }
            if (low < mb && mb <= 4096.0 && groupName.equals("LegoRuntime")) {
                xms = PropertyManager.getProValue("VSM.LEGO.RUN.MEMORY.MEDIUM.XMS");
                xmx = PropertyManager.getProValue("VSM.LEGO.RUN.MEMORY.MEDIUM.XMX");
                mmn = PropertyManager.getProValue("VSM.LEGO.RUN.MEMORY.MEDIUM.MMN");
                other = PropertyManager.getProValue("VSM.LEGO.RUN.MEMORY.MEDIUM.OTHER");
            }
        }
        if (null == xms || null == xmx || null == mmn || null == other) {
            LOGGER.error("replaceRunbat error, null == xms || null == xmx || null == mmn || null == other.");
            return;
        }
        String tmpParamers = CommonUtil.readParamsAndReplKeyFromTmp(cmd, "Xms1024M", xms);
        CommonUtil.writeToWebFile(cmd, tmpParamers);
        tmpParamers = CommonUtil.readParamsAndReplKeyFromTmp(cmd, "Xmx1024M", xmx);
        CommonUtil.writeToWebFile(cmd, tmpParamers);
        tmpParamers = CommonUtil.readParamsAndReplKeyFromTmp(cmd, "Xmn256M", mmn);
        CommonUtil.writeToWebFile(cmd, tmpParamers);
        tmpParamers = CommonUtil.readParamsAndReplKeyFromTmp(cmd, "=256M", other);
        CommonUtil.writeToWebFile(cmd, tmpParamers);
        tmpParamers = CommonUtil.readParamsAndReplKeyFromTmp(cmd, "-Dencoding=UTF-8", "-XX:+HeapDumpOnOutOfMemoryError;-XX:HeapDumpPath=%LEGO_RUNTIME_DIR%logs;-XX:+UseConcMarkSweepGC;-XX:+UseCMSCompactAtFullCollection;-XX:CMSInitiatingOccupancyFraction=50;-XX:+CMSParallelRemarkEnabled;-Dencoding=UTF-8");
        CommonUtil.writeToWebFile(cmd, tmpParamers);
    }

    public void replaceIndexServerRunbat(double memory, boolean isWindows) {
        String cmd = null;
        String cmd2 = ContextUtil.getStrValueFromCtx("lego.base.installpath") + File.separator + "indexserver/etc/indexServer.xml";
        String cmd3 = null;
        if (isWindows) {
            cmd = ContextUtil.getStrValueFromCtx("lego.base.installpath") + File.separator + "indexserver/indexserver.bat";
            cmd3 = ContextUtil.getStrValueFromCtx("lego.base.installpath") + File.separator + "indexDataServer/bin/service.bat";
        } else {
            cmd = ContextUtil.getStrValueFromCtx("lego.base.installpath") + File.separator + "indexserver/indexserver.sh";
            cmd3 = ContextUtil.getStrValueFromCtx("lego.base.installpath") + File.separator + "indexDataServer/bin/indexdataserver.in.sh";
        }
        try {
            if (8000.0 > memory) {
                if (7000.0 < memory && 8000.0 > memory && !"Integrated Scene".equals(this.installScene)) {
                    File src = new File(cmd);
                    String cont = this.read(src);
                    cont = cont.replaceAll("memorySmallSizeReplace", "128");
                    cont = cont.replaceAll("memoryMaxSizeReplace", "256");
                    cont = cont.replaceAll("memoryNewSizeReplace", "64");
                    cont = cont.replaceAll("memoryXssSizeReplace", "128");
                    this.write(cont, src);
                    File src2 = new File(cmd2);
                    String cont2 = this.read(src2);
                    cont2 = cont2.replaceAll("sleep_time = 100", "sleep_time = 75");
                    cont2 = cont2.replaceAll("reptile_nums = 2", "reptile_nums = 4");
                    cont2 = cont2.replaceAll("parse_thradpool_num = 3", "parse_thradpool_num = 4");
                    cont2 = cont2.replaceAll("index_thradpool_num = 3", "index_thradpool_num = 4");
                    cont2 = cont2.replaceAll("buffer_size_times = 1", "buffer_size_times = 2");
                    this.write(cont2, src2);
                    File src3 = new File(cmd3);
                    String cont3 = this.read(src3);
                    cont3 = cont3.replaceAll("memorySmallSizeReplace", "1024");
                    cont3 = cont3.replaceAll("memoryMaxSizeReplace", "1536");
                    cont3 = cont3.replaceAll("memoryNewSizeReplace", "512");
                    cont3 = cont3.replaceAll("memoryXssSizeReplace", "256");
                    this.write(cont3, src3);
                } else {
                    File src = new File(cmd);
                    String cont = this.read(src);
                    cont = cont.replaceAll("memorySmallSizeReplace", "64");
                    cont = cont.replaceAll("memoryMaxSizeReplace", "128");
                    cont = cont.replaceAll("memoryNewSizeReplace", "32");
                    cont = cont.replaceAll("memoryXssSizeReplace", "128");
                    this.write(cont, src);
                    File src2 = new File(cmd2);
                    String cont2 = this.read(src2);
                    cont2 = cont2.replaceAll("reptile_nums = 2", "reptile_nums = 3");
                    this.write(cont2, src2);
                    File src3 = new File(cmd3);
                    String cont3 = this.read(src3);
                    cont3 = cont3.replaceAll("memorySmallSizeReplace", "256");
                    cont3 = cont3.replaceAll("memoryMaxSizeReplace", "512");
                    cont3 = cont3.replaceAll("memoryNewSizeReplace", "128");
                    cont3 = cont3.replaceAll("memoryXssSizeReplace", "128");
                    this.write(cont3, src3);
                }
            } else if (8000.0 <= memory && 16000.0 > memory) {
                if ("Integrated Scene".equals(this.installScene)) {
                    File src = new File(cmd);
                    String cont = this.read(src);
                    cont = cont.replaceAll("memorySmallSizeReplace", "128");
                    cont = cont.replaceAll("memoryMaxSizeReplace", "256");
                    cont = cont.replaceAll("memoryNewSizeReplace", "64");
                    cont = cont.replaceAll("memoryXssSizeReplace", "128");
                    this.write(cont, src);
                    File src2 = new File(cmd2);
                    String cont2 = this.read(src2);
                    cont2 = cont2.replaceAll("reptile_nums = 2", "reptile_nums = 3");
                    this.write(cont2, src2);
                    File src3 = new File(cmd3);
                    String cont3 = this.read(src3);
                    cont3 = cont3.replaceAll("memorySmallSizeReplace", "256");
                    cont3 = cont3.replaceAll("memoryMaxSizeReplace", "640");
                    cont3 = cont3.replaceAll("memoryNewSizeReplace", "128");
                    cont3 = cont3.replaceAll("memoryXssSizeReplace", "128");
                    this.write(cont3, src3);
                } else {
                    File src = new File(cmd);
                    String cont = this.read(src);
                    cont = cont.replaceAll("memorySmallSizeReplace", "128");
                    cont = cont.replaceAll("memoryMaxSizeReplace", "256");
                    cont = cont.replaceAll("memoryNewSizeReplace", "64");
                    cont = cont.replaceAll("memoryXssSizeReplace", "128");
                    this.write(cont, src);
                    File src2 = new File(cmd2);
                    String cont2 = this.read(src2);
                    cont2 = cont2.replaceAll("sleep_time = 100", "sleep_time = 75");
                    cont2 = cont2.replaceAll("reptile_nums = 2", "reptile_nums = 4");
                    cont2 = cont2.replaceAll("parse_thradpool_num = 3", "parse_thradpool_num = 4");
                    cont2 = cont2.replaceAll("index_thradpool_num = 3", "index_thradpool_num = 4");
                    cont2 = cont2.replaceAll("buffer_size_times = 1", "buffer_size_times = 2");
                    this.write(cont2, src2);
                    File src3 = new File(cmd3);
                    String cont3 = this.read(src3);
                    cont3 = cont3.replaceAll("memorySmallSizeReplace", "1024");
                    cont3 = cont3.replaceAll("memoryMaxSizeReplace", "1536");
                    cont3 = cont3.replaceAll("memoryNewSizeReplace", "512");
                    cont3 = cont3.replaceAll("memoryXssSizeReplace", "256");
                    this.write(cont3, src3);
                }
            } else if (16000.0 <= memory) {
                File src = new File(cmd);
                String cont = this.read(src);
                cont = cont.replaceAll("memorySmallSizeReplace", "256");
                cont = cont.replaceAll("memoryMaxSizeReplace", "512");
                cont = cont.replaceAll("memoryNewSizeReplace", "128");
                cont = cont.replaceAll("memoryXssSizeReplace", "128");
                this.write(cont, src);
                File src2 = new File(cmd2);
                String cont2 = this.read(src2);
                cont2 = cont2.replaceAll("sleep_time = 100", "sleep_time = 15");
                cont2 = cont2.replaceAll("reptile_nums = 2", "reptile_nums = 4");
                cont2 = cont2.replaceAll("parse_thradpool_num = 3", "parse_thradpool_num = 5");
                cont2 = cont2.replaceAll("index_thradpool_num = 3", "index_thradpool_num = 5");
                cont2 = cont2.replaceAll("buffer_size_times = 1", "buffer_size_times = 5");
                this.write(cont2, src2);
                File src3 = new File(cmd3);
                String cont3 = this.read(src3);
                cont3 = cont3.replaceAll("memorySmallSizeReplace", "4096");
                cont3 = cont3.replaceAll("memoryMaxSizeReplace", "4096");
                cont3 = cont3.replaceAll("memoryNewSizeReplace", "2048");
                cont3 = cont3.replaceAll("memoryXssSizeReplace", "256");
                this.write(cont3, src3);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("replaceIndexServerRunbat occurs error.", (Throwable)e);
        }
    }

    public void replaceIndexServerStart(double memory) {
        String cmd2 = ContextUtil.getStrValueFromCtx("lego.base.installpath") + File.separator + "indexserver/etc/indexServer.xml";
        try {
            if (4096.0 > memory && "Integrated Scene".equals(this.installScene)) {
                File src2 = new File(cmd2);
                String cont2 = this.read(src2);
                cont2 = cont2.replaceAll("true", "false");
                this.write(cont2, src2);
            }
        }
        catch (Exception e) {
            LOGGER.error("replace index server start occurs error.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String read(File src) {
        StringBuffer strBuff = new StringBuffer();
        String line = null;
        BufferedReader bReader = null;
        try {
            bReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(src), "utf-8"));
            while (null != (line = bReader.readLine())) {
                strBuff.append(line + System.getProperty("line.separator"));
            }
            bReader.close();
        }
        catch (FileNotFoundException e) {
            LOGGER.error("read content source file occurs error: ", (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("read content source file occurs error: ", (Throwable)e);
        }
        finally {
            if (null != bReader) {
                try {
                    bReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("close io occurs error.", (Throwable)e);
                }
            }
        }
        return strBuff.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String cont, File dest) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dest), "utf-8"));
            writer.write(cont);
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            LOGGER.error("wirte io occurs error.", (Throwable)e);
        }
        finally {
            if (null != writer) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    LOGGER.error("close io occurs error.", (Throwable)e);
                }
            }
        }
    }

    public void replaceTomcat(double mb, boolean isLinux) throws IOException {
        String filePath = ContextUtil.getStrValueFromCtx("lego.base.installpath") + File.separator + "Runtime/Tomcat6/bin/";
        filePath = isLinux ? filePath + "catalina.sh" : filePath + "service.bat";
        boolean isDemoScene = false;
        if ("Integrated Scene".equals(this.installScene) && mb <= 4096.0) {
            isDemoScene = true;
        }
        LOGGER.debug("isDemoScene: " + isDemoScene, (Object)"replaceTomcat");
        if (isDemoScene) {
            String tmpParamers = CommonUtil.readParamsAndReplKeyFromTmp(filePath, "Xmx512M", "Xmx256M");
            CommonUtil.writeToWebFile(filePath, tmpParamers);
            tmpParamers = CommonUtil.readParamsAndReplKeyFromTmp(filePath, "PermSize=256M", "PermSize=64M");
            CommonUtil.writeToWebFile(filePath, tmpParamers);
            tmpParamers = CommonUtil.readParamsAndReplKeyFromTmp(filePath, "MaxPermSize=256M", "MaxPermSize=64M");
            CommonUtil.writeToWebFile(filePath, tmpParamers);
            tmpParamers = CommonUtil.readParamsAndReplKeyFromTmp(filePath, "-Dencoding=UTF-8", "-XX:+UseConcMarkSweepGC;-XX:+UseCMSCompactAtFullCollection;-XX:CMSInitiatingOccupancyFraction=90;-XX:+CMSParallelRemarkEnabled;-Dencoding=UTF-8");
            CommonUtil.writeToWebFile(filePath, tmpParamers);
        } else if (0.0 <= mb && mb <= 1280.0) {
            String tmpParamers = CommonUtil.readParamsAndReplKeyFromTmp(filePath, "Xmx512M", "Xmx256M");
            CommonUtil.writeToWebFile(filePath, tmpParamers);
            tmpParamers = CommonUtil.readParamsAndReplKeyFromTmp(filePath, "PermSize=256M", "PermSize=64M");
            CommonUtil.writeToWebFile(filePath, tmpParamers);
            tmpParamers = CommonUtil.readParamsAndReplKeyFromTmp(filePath, "MaxPermSize=256M", "MaxPermSize=128M");
            CommonUtil.writeToWebFile(filePath, tmpParamers);
        }
    }

    public void replInfOfDBMemory(double mb) {
        String templateCMD = this.basePath + "Plug-In\\vsmcore\\script\\config\\";
        String cmd = ContextUtil.getStrValueFromCtx("lego.base.installpath") + "\\Runtime\\vsm_conf\\vsmcore\\changeDBmemory.bat";
        String maxMB = null;
        if (0.0 < mb && mb <= 2048.0) {
            maxMB = PropertyManager.getProValue("VSM.SQLSERVER.MEMORY.LOW");
        }
        if (2048.0 < mb && mb <= 4096.0) {
            maxMB = PropertyManager.getProValue("VSM.SQLSERVER.MEMORY.MEDIUM");
        }
        if (mb > 4096.0) {
            maxMB = PropertyManager.getProValue("VSM.SQLSERVER.MEMORY.HEIGH");
        }
        HashMap<String, Object> configSource = new HashMap<String, Object>();
        configSource.put("maxMB", maxMB);
        LOGGER.info(maxMB, (Object)"replInfOfDBMemory.changeDBmemory.bat>>");
        CommonUtil.createTemplateFile(templateCMD, "changeDBmemory.bat", cmd, configSource);
    }
}

