/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.model.ContextPropVal;
import com.huawei.elog.base.model.WizardDialog;
import com.huawei.elog.common.StreamProcUtil;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.IgnoreDTDEntityResolver;
import com.huawei.elog.util.OSUtil;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.WindowUtil;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;

public abstract class FileUtil {
    private static final char FILE_SPARATOR_WIN = '\\';
    private static final char FILE_SPARATOR_OTHER = '/';
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFolder(String oldPath, String newPath) {
        FileInputStream sIn = null;
        FileOutputStream sOut = null;
        File temp = null;
        try {
            File a = new File(oldPath);
            if (!a.exists()) {
                LOGGER.error("Old Path is not exists: ", (Object)"copyFolder");
                return;
            }
            boolean ret = new File(newPath).mkdirs();
            LOGGER.info("Create  File: " + ret, (Object)"copyFolder");
            String[] file = a.list();
            if (file != null && file.length != 0) {
                for (int i = 0; i < file.length; ++i) {
                    temp = oldPath.endsWith(File.separator) ? new File(oldPath + file[i]) : new File(oldPath + File.separator + file[i]);
                    if (temp.isFile()) {
                        int len;
                        sIn = new FileInputStream(temp);
                        sOut = new FileOutputStream(newPath + "/" + temp.getName());
                        byte[] b = new byte[2048];
                        while ((len = ((InputStream)sIn).read(b)) != -1) {
                            ((OutputStream)sOut).write(b, 0, len);
                        }
                        sOut.flush();
                        ((InputStream)sIn).close();
                        ((OutputStream)sOut).close();
                        LOGGER.info("Copy  File", (Object)"copyFolder");
                    }
                    if (!temp.isDirectory()) continue;
                    FileUtil.copyFolder(oldPath + "/" + file[i], newPath + "/" + file[i]);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("In FileUtil: ", (Throwable)e);
        }
        finally {
            StreamProcUtil.close(sIn);
            StreamProcUtil.close(sOut);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void modifyDBPropFileUsingPro(String fileName, String[] keys, String[] values) throws IOException {
        FileInputStream sIn = null;
        FileOutputStream sOut = null;
        Properties prop = new Properties();
        try {
            File file = new File(fileName);
            if (!file.exists()) {
                boolean ret = file.createNewFile();
                LOGGER.debug("create file result: " + ret, (Object)"modifyDBPropFileUsingPro");
            }
            sIn = new FileInputStream(file);
            prop.load(sIn);
            StreamProcUtil.close((InputStream)sIn);
        }
        catch (IOException e) {
            LOGGER.error("In FileUtil:", (Throwable)e);
        }
        finally {
            StreamProcUtil.close(sIn);
        }
        try {
            sOut = new FileOutputStream(fileName);
            for (int i = 0; i < keys.length; ++i) {
                prop.setProperty(keys[i], values[i]);
            }
            prop.store(sOut, "Update DB value");
        }
        catch (IOException e) {
            try {
                LOGGER.error("In FileUtil:", (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamProcUtil.close(sOut);
                sOut = null;
                throw throwable;
            }
            StreamProcUtil.close((OutputStream)sOut);
            sOut = null;
        }
        StreamProcUtil.close((OutputStream)sOut);
        sOut = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void modifyDBPropFileUsingStr(String file, String[] keys, String[] values, String targetFile) {
        block7: {
            StringBuilder sb = new StringBuilder();
            BufferedReader bufferReader = null;
            InputStreamReader fileReader = null;
            OutputStreamWriter writer = null;
            FileInputStream fileInStrmTmp = null;
            FileOutputStream fileOutStrmTmp = null;
            try {
                fileInStrmTmp = new FileInputStream(new File(file));
                fileReader = new InputStreamReader((InputStream)fileInStrmTmp, "utf-8");
                bufferReader = new BufferedReader(fileReader);
                String text = null;
                while ((text = bufferReader.readLine()) != null) {
                    for (int i = 0; i < keys.length; ++i) {
                        if (!(text = Normalizer.normalize(text, Normalizer.Form.NFKC)).startsWith(keys[i])) continue;
                        text = keys[i] + "=" + values[i];
                    }
                    sb.append(text);
                    sb.append(System.getProperty("line.separator"));
                }
                fileOutStrmTmp = new FileOutputStream(new File(targetFile));
                writer = new OutputStreamWriter((OutputStream)fileOutStrmTmp, "utf-8");
                writer.write(sb.toString());
                writer.flush();
                StreamProcUtil.close(fileReader);
            }
            catch (IOException e) {
                LOGGER.error("In FileUtil:", (Throwable)e);
                break block7;
            }
            finally {
                StreamProcUtil.close(fileReader);
                StreamProcUtil.close(bufferReader);
                StreamProcUtil.close(fileInStrmTmp);
                StreamProcUtil.close(writer);
                StreamProcUtil.close(fileOutStrmTmp);
            }
            StreamProcUtil.close(bufferReader);
            StreamProcUtil.close(fileInStrmTmp);
            StreamProcUtil.close(writer);
            StreamProcUtil.close(fileOutStrmTmp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void combineFile(String file, String target) {
        block7: {
            BufferedReader sOld1Reader = null;
            BufferedReader sOld2Reader = null;
            OutputStreamWriter sWriter = null;
            FileInputStream fileInStreamTemp1 = null;
            InputStreamReader inStreamReadTemp1 = null;
            FileInputStream fileInStreamTemp2 = null;
            InputStreamReader inStreamReadTemp2 = null;
            StringBuilder sb = new StringBuilder();
            try {
                fileInStreamTemp1 = new FileInputStream(new File(file));
                inStreamReadTemp1 = new InputStreamReader((InputStream)fileInStreamTemp1, "utf-8");
                sOld1Reader = new BufferedReader(inStreamReadTemp1);
                fileInStreamTemp2 = new FileInputStream(new File(target));
                inStreamReadTemp2 = new InputStreamReader((InputStream)fileInStreamTemp2, "utf-8");
                sOld2Reader = new BufferedReader(inStreamReadTemp2);
                String text = null;
                while ((text = sOld2Reader.readLine()) != null) {
                    sb.append(text);
                    sb.append(System.getProperty("line.separator"));
                }
                while ((text = sOld1Reader.readLine()) != null) {
                    sb.append(text);
                    sb.append(System.getProperty("line.separator"));
                }
                sWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(target)), "utf-8");
                sWriter.write(sb.toString());
                sWriter.flush();
                StreamProcUtil.close(sWriter);
            }
            catch (IOException e) {
                LOGGER.error("In FileUtil:", (Throwable)e);
                break block7;
            }
            finally {
                StreamProcUtil.close(sWriter);
                StreamProcUtil.close(sOld1Reader);
                StreamProcUtil.close(inStreamReadTemp1);
                StreamProcUtil.close(fileInStreamTemp1);
                StreamProcUtil.close(sOld2Reader);
                StreamProcUtil.close(inStreamReadTemp2);
                StreamProcUtil.close(fileInStreamTemp2);
            }
            StreamProcUtil.close(sOld1Reader);
            StreamProcUtil.close(inStreamReadTemp1);
            StreamProcUtil.close(fileInStreamTemp1);
            StreamProcUtil.close(sOld2Reader);
            StreamProcUtil.close(inStreamReadTemp2);
            StreamProcUtil.close(fileInStreamTemp2);
        }
    }

    public static void deleteAllFolder(File file) {
        file.setWritable(true);
        if (file.exists()) {
            boolean ret;
            if (file.isFile()) {
                ret = file.delete();
                if (!ret) {
                    LOGGER.debug("del file fail...", (Object)"deleteAllFolder");
                }
            } else if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (file.exists() && files != null && files.length != 0) {
                    for (int i = 0; i < files.length; ++i) {
                        FileUtil.deleteAllFolder(files[i]);
                    }
                }
            }
            ret = file.delete();
            if (!ret) {
                LOGGER.debug("del file fail...", (Object)"deleteAllFolder");
            }
        }
    }

    public static void deleteAllFilesInFolder(File file) {
        file.setWritable(true);
        if (file.exists()) {
            if (file.isFile()) {
                return;
            }
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (file.exists() && files != null && files.length != 0) {
                    for (int i = 0; i < files.length; ++i) {
                        FileUtil.deleteAllFolder(files[i]);
                    }
                }
            }
        }
    }

    public static void deleteFile(String fileName) throws IOException {
        File file = new File(fileName);
        if (file.exists()) {
            file.setWritable(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getContentFromIni(String file) throws IOException {
        BufferedReader sOld1Reader = null;
        ArrayList<String> keys = new ArrayList<String>();
        try {
            File f = new File(file);
            if (f.exists()) {
                sOld1Reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "utf-8"));
                String text = null;
                while ((text = sOld1Reader.readLine()) != null) {
                    if (text.trim().length() <= 0) continue;
                    keys.add(text.trim());
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("In FileUtil:", (Throwable)e);
        }
        finally {
            StreamProcUtil.close(sOld1Reader);
            sOld1Reader = null;
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static Properties getProportyFromFile(String filePath) {
        Properties prop;
        block7: {
            prop = new Properties();
            File file = new File(filePath);
            BufferedInputStream bis = null;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                bis = new BufferedInputStream(fis);
                prop.load(bis);
                StreamProcUtil.close(bis);
            }
            catch (FileNotFoundException e) {
                LOGGER.error("get context source file occurs error.", (Throwable)e);
                break block7;
            }
            catch (IOException e2) {
                LOGGER.error("get context source file occurs error.", (Throwable)e2);
                break block7;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                StreamProcUtil.close(bis);
                StreamProcUtil.close(fis);
            }
            StreamProcUtil.close(fis);
        }
        return prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean saveProporty2File(String filePath, Properties props) {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filePath);
            props.store(fos, "Copyright (c) Boxcode Studio");
        }
        catch (FileNotFoundException e) {
            LOGGER.error("save property to file occurs error.", (Throwable)e);
            boolean bl = false;
            StreamProcUtil.close(fos);
            return bl;
        }
        catch (IOException e2) {
            LOGGER.error("save property to file occurs error.", (Throwable)e2);
            boolean bl = false;
            {
                catch (Throwable throwable) {
                    StreamProcUtil.close(fos);
                    throw throwable;
                }
            }
            StreamProcUtil.close(fos);
            return bl;
        }
        StreamProcUtil.close(fos);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteConfigIniLine(List<String> keys) {
        block7: {
            StringBuilder sb = new StringBuilder();
            ContextPropVal installPath = InstallContext.getInstance().getPropertyMap().getProp("lego.base.installpath");
            String fileName = installPath.getValue().toString() + "/Runtime/LegoRuntime/configuration/config.ini";
            BufferedReader old1Reader = null;
            OutputStreamWriter writer = null;
            try {
                old1Reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(fileName)), "utf-8"));
                String text = null;
                while ((text = old1Reader.readLine()) != null) {
                    text = Normalizer.normalize(text, Normalizer.Form.NFKC);
                    boolean contains = false;
                    for (String jarName : keys) {
                        if (!text.contains(jarName)) continue;
                        contains = true;
                    }
                    if (contains) continue;
                    sb.append(text);
                    sb.append(System.getProperty("line.separator"));
                }
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(new File(fileName)), "utf-8");
                writer.write(sb.toString());
                writer.flush();
                StreamProcUtil.close(old1Reader);
            }
            catch (IOException e) {
                LOGGER.error("In FileUtil:", (Throwable)e);
                break block7;
            }
            finally {
                StreamProcUtil.close(old1Reader);
                StreamProcUtil.close(writer);
            }
            StreamProcUtil.close(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changeDBConf(String[] array) throws IOException, DocumentException {
        SAXReader sreader = new SAXReader();
        sreader.setEntityResolver((EntityResolver)new IgnoreDTDEntityResolver());
        Document document = sreader.read(new File(WindowUtil.getInstallPath() + "/ddosCollectorInstalled.xml"));
        List list = document.selectNodes("/install/installpath");
        Element element = (Element)list.get(0);
        String basePath = element.attributeValue("path");
        File file = new File(basePath + "\\antiddos_collector\\conf\\db.conf");
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "utf-8"));
        BufferedWriter out = null;
        String str = "";
        String link = "";
        try {
            while ((str = reader.readLine()) != null) {
                String s = str.substring(0, str.indexOf("=") + 1);
                if ("DB_UserName=".equals(s)) {
                    link = "DB_UserName=" + array[0];
                    out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8"));
                } else {
                    link = "DB_PassWord=".equals(s) ? s + array[1] : ("DB_Schema=".equals(s) ? s + "dbo" : ("DB_URL=".equals(s) ? s + "jdbc:mysql://" + array[2] + ":" + array[3] + "/collector" : str));
                }
                if (null == out) continue;
                out.flush();
                out.write(link);
                out.newLine();
                StreamProcUtil.close(out);
            }
        }
        finally {
            StreamProcUtil.close(reader);
            StreamProcUtil.close(out);
        }
    }

    public static String formatFileSeparator(String path) {
        String ret = path.replace("\\", "/");
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContentFromFile(File f) {
        if (!f.exists()) {
            return null;
        }
        BufferedReader in = null;
        StringBuffer content = new StringBuffer();
        String line = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "utf-8"));
            while ((line = in.readLine()) != null) {
                content.append(line);
                content.append('\n');
            }
        }
        catch (IOException e) {
            LOGGER.error("get context source file occurs error.", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.error("close io occurs error.", (Throwable)e);
                }
            }
        }
        return content.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(File f) {
        if (null == f || !f.exists()) {
            LOGGER.warn("File is not exist, file: " + (null == f ? "null" : "..."), (Object)"readFile");
            return null;
        }
        StringBuffer sb = new StringBuffer();
        InputStreamReader isr = null;
        BufferedReader br = null;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(f);
            isr = new InputStreamReader((InputStream)fis, "UTF-8");
            br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append(CommonUtil.WRAP_CHAR);
            }
        }
        catch (IOException e) {
            LOGGER.error("readFile", (Throwable)e);
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LOGGER.error("close io occurs error.", (Throwable)e);
                }
            }
            if (null != isr) {
                try {
                    isr.close();
                }
                catch (IOException e) {
                    LOGGER.error("close io occurs error.", (Throwable)e);
                }
            }
            if (null != fis) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    LOGGER.error("close io occurs error.", (Throwable)e);
                }
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(File f, String content) {
        if (!f.exists()) {
            boolean b = false;
            try {
                b = f.createNewFile();
                if (!b) {
                    LOGGER.error("create file error, file: ...", (Object)"writeFile");
                }
            }
            catch (IOException e) {
                LOGGER.error("writeFile", (Throwable)e);
            }
        }
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        try {
            fos = new FileOutputStream(f);
            osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            osw.write(content);
            osw.flush();
        }
        catch (IOException e) {
            LOGGER.error("writeFile", (Throwable)e);
        }
        finally {
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException e) {
                    LOGGER.error("close io occurs error.", (Throwable)e);
                }
            }
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    LOGGER.error("close io occurs error.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeContent2File(File file, String content) {
        if (!file.exists()) {
            return;
        }
        OutputStreamWriter fw = null;
        BufferedWriter output = null;
        try {
            fw = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "utf-8");
            output = new BufferedWriter(fw);
            output.write(content);
            output.close();
        }
        catch (IOException e) {
            LOGGER.error("write context to file occurs error.", (Throwable)e);
        }
        finally {
            if (null != output) {
                try {
                    output.close();
                }
                catch (IOException e) {
                    LOGGER.error("close io occurs error.", (Throwable)e);
                }
            }
            if (null != fw) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    LOGGER.error("close io occurs error.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties pass2PropertiesFromContent(String fileContent) {
        if (null == fileContent) {
            return null;
        }
        Properties storageValues = new Properties();
        ByteArrayInputStream fis = null;
        try {
            fis = new ByteArrayInputStream(fileContent.getBytes("UTF-8"));
            storageValues.load(fis);
        }
        catch (IOException e) {
            LOGGER.error("occurs io error.", (Throwable)e);
        }
        finally {
            if (null != fis) {
                try {
                    ((InputStream)fis).close();
                }
                catch (IOException e) {
                    LOGGER.error("close io occurs error.", (Throwable)e);
                }
            }
        }
        return storageValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties pass2PropertiesByPath(String filePath) {
        Properties storageValues = new Properties();
        if (null == filePath) {
            return storageValues;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(filePath);
            storageValues.load(fis);
        }
        catch (IOException e) {
            try {
                LOGGER.error("parse properties by path occurs error: ", (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamProcUtil.close(fis);
                throw throwable;
            }
            StreamProcUtil.close(fis);
        }
        StreamProcUtil.close(fis);
        return storageValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String fromFileName, String toFileName) {
        if (fromFileName == null || fromFileName.length() <= 0 || toFileName == null || toFileName.length() <= 0) {
            return;
        }
        File fromFile = new File(fromFileName);
        File toFile = new File(toFileName);
        if (!toFile.exists()) {
            try {
                if (!toFile.getParentFile().exists()) {
                    boolean bol = toFile.getParentFile().mkdirs();
                    LOGGER.debug("file is not exist, file: {} ,create result: {}", (Object)"...", (Object)bol);
                }
                boolean b = toFile.createNewFile();
                LOGGER.debug("file is not exist, file: {} ,create result: {}", (Object)"...", (Object)b);
            }
            catch (IOException e) {
                LOGGER.error("In FileUtil : copyFile IOException", (Throwable)e);
            }
        }
        if (fromFile.isFile()) {
            FileInputStream fis = null;
            FileOutputStream fos = null;
            try {
                try {
                    fis = new FileInputStream(fromFile);
                    fos = new FileOutputStream(toFile);
                    byte[] buffer = new byte[4096];
                    int bytesRead = 0;
                    while ((bytesRead = fis.read(buffer)) != -1) {
                        fos.write(buffer, 0, bytesRead);
                    }
                }
                catch (FileNotFoundException e) {
                    String logMessage = "FileNotFoundException : The file(s) below not found while copying : " + System.getProperty("line.separator") + "..." + " or " + "xxx";
                    LOGGER.info("logMessage:" + logMessage, (Object)"copyFile");
                }
                catch (IOException e) {
                    LOGGER.error("IOException", (Throwable)e);
                }
                return;
            }
            finally {
                StreamProcUtil.close(fos);
                StreamProcUtil.close(fis);
            }
        }
    }

    public static boolean testPathValid(CharSequence inputStr, String pathName, WizardDialog container, boolean isLinux) {
        String normalizeInputStr = Normalizer.normalize(inputStr, Normalizer.Form.NFKC);
        if (isLinux) {
            try {
                boolean isCreateSuc;
                normalizeInputStr = normalizeInputStr.substring(0, normalizeInputStr.indexOf("/LogCenter"));
                File installPath = new File(normalizeInputStr);
                if (!installPath.exists() && !(isCreateSuc = installPath.mkdir())) {
                    OptionPane.showInfoDialog(ResourceManager.getString("VSM.EXTEND.ELOG.MESSAGE.NODISKPATH", pathName));
                    return false;
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                OptionPane.showInfoDialog(ResourceManager.getString("VSM.EXTEND.ELOG.MESSAGE.NODISKPATH", pathName));
                return false;
            }
            return true;
        }
        try {
            int j;
            File[] roots = File.listRoots();
            if (null == roots) {
                LOGGER.error("roots is null.");
                return false;
            }
            LOGGER.debug("roots size: " + roots.length, (Object)"testPathValid");
            char inputChar = inputStr.charAt(0);
            for (j = 0; j < roots.length; ++j) {
                if (inputChar != roots[j].toString().toCharArray()[0] && inputChar != roots[j].toString().toLowerCase(Locale.getDefault()).toCharArray()[0]) continue;
                LOGGER.debug("break for...", (Object)"testPathValid");
                break;
            }
            if (j == roots.length) {
                OptionPane.showInfoDialog(ResourceManager.getString("VSM.EXTEND.ELOG.MESSAGE.NODISKPATH", pathName));
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.error("testPathValid", (Throwable)e);
        }
        inputStr = Normalizer.normalize(inputStr, Normalizer.Form.NFKC);
        String patternStr = "([a-zA-Z])(\\:)((\\\\)(([A-Za-z0-9\\-\\_])+?)*?)+?";
        Pattern pattern = Pattern.compile(patternStr, 4);
        Matcher matcher = pattern.matcher(inputStr);
        boolean matchFound = matcher.matches();
        if (!matchFound) {
            OptionPane.showInfoDialog(ResourceManager.getString("VSM.EXTEND.ELOG.MESSAGE.ERRPATH", pathName));
            return false;
        }
        return true;
    }

    public static double getDiskFreeSize(String path) {
        if (OSUtil.isWindows()) {
            return FileUtil.getDiskFreeSize4Windows(path);
        }
        return FileUtil.getDiskFreeSize4Linux(path);
    }

    private static double getDiskFreeSize4Windows(String path) {
        double diskFreeSpace = 0.0;
        char p = path.charAt(0);
        File[] disks = File.listRoots();
        if (null == disks) {
            LOGGER.error("getDiskFreeSize4Windows error, disks is null.");
            return diskFreeSpace;
        }
        for (File disk : disks) {
            try {
                char d = disk.getCanonicalPath().charAt(0);
                if (Character.toUpperCase(d) != Character.toUpperCase(p)) continue;
                diskFreeSpace = (double)disk.getFreeSpace() / 1.073741824E9;
                break;
            }
            catch (IOException e) {
                LOGGER.error("path wrong", (Throwable)e);
            }
        }
        return diskFreeSpace;
    }

    private static double getDiskFreeSize4Linux(String path) {
        double diskFreeSpace = 0.0;
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            path = path.replace("\\", File.separator);
        }
        File checkPath = new File(path);
        while (!checkPath.exists()) {
            checkPath = new File(checkPath.getParent());
        }
        diskFreeSpace = (double)checkPath.getFreeSpace() / 1.073741824E9;
        return diskFreeSpace;
    }

    public static String parseSeparator4Linux(String path) {
        String str = path;
        if (StringUtils.isNotEmpty((CharSequence)str) && OSUtil.isWindows()) {
            str = str.replace("\\", File.separator);
        }
        return str;
    }

    public static boolean fileRename(File oldFile, File dest) {
        if (oldFile.exists()) {
            boolean b = oldFile.renameTo(dest);
            return b;
        }
        return false;
    }

    public static String parseCapitalDisk(String path) {
        String result;
        File file = new File(path);
        try {
            result = file.getCanonicalPath();
        }
        catch (IOException e) {
            result = path;
            LOGGER.error("parse capital disk occurs error.", (Throwable)e);
        }
        return result;
    }
}

