/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IOUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOUtil.class);

    private IOUtil() {
    }

    public static void closeInputStream(InputStream in) {
        try {
            if (null != in) {
                in.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("Closing input stream has error happened." + e, (Object)"closeInputStream");
        }
    }

    public static void closeOutputStream(OutputStream out) {
        try {
            if (null != out) {
                out.close();
            }
        }
        catch (Exception e) {
            LOGGER.error("Closing output stream has error happened." + e, (Object)"closeOutputStream");
        }
    }

    public static void closeReader(Reader reader) {
        try {
            if (null != reader) {
                reader.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("Closing reader has error happened." + e, (Object)"closeReader");
        }
    }
}

