/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.base.model.DataBaseInfo;
import com.huawei.elog.common.StreamProcUtil;
import com.huawei.elog.util.DBConnectionFactory;
import com.huawei.elog.util.DbScript;
import com.huawei.elog.util.IDBConnection;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InitSQL {
    private static final String MYSQL = "MySQL";
    private static final String SQLSERVER = "Microsoft SQL Server";
    private static final String MYSQL_DEFAULT_SUFFIX = ";";
    private static String suffix = ";";
    private static final String MYSQL_KEYWORD_DELIMITER = "DELIMITER";
    private static final Logger LOGGER = LoggerFactory.getLogger(InitSQL.class);
    private DbScript dbinit = null;

    public InitSQL(DbScript dbinit) {
        this.dbinit = dbinit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixDB(DataBaseInfo dbInfor) throws SQLException {
        Connection conn = null;
        Statement pst = null;
        if (null == dbInfor || null == dbInfor.getDbType()) {
            return;
        }
        IDBConnection dbConnection = DBConnectionFactory.getInstance(dbInfor);
        if (null == dbConnection) {
            return;
        }
        conn = dbConnection.connection(dbInfor, false);
        if (null == conn) {
            LOGGER.error("Create DB error, conn is null.", (Object)"fixDB");
            return;
        }
        try {
            Map<String, String> createDBMap = this.dbinit.getDb();
            for (Map.Entry<String, String> ent : createDBMap.entrySet()) {
                String key = ent.getKey();
                if (dbConnection.dbExist(dbInfor, key) || (pst = conn.createStatement()) == null) continue;
                pst.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("Create DB error" + e, (Object)"fixDB");
        }
        finally {
            try {
                if (pst != null) {
                    pst.close();
                }
            }
            finally {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropDB(DataBaseInfo dbInfor) throws SQLException {
        if (null == dbInfor || null == dbInfor.getDbType()) {
            return;
        }
        Connection conn = null;
        Statement pst = null;
        IDBConnection dbConnection = DBConnectionFactory.getInstance(dbInfor);
        if (null == dbConnection) {
            return;
        }
        conn = dbConnection.connection(dbInfor, false);
        if (null == conn) {
            LOGGER.error("dropDB error,conn is null.");
            return;
        }
        try {
            Map<String, String> createDBMap = this.dbinit.getDb();
            for (Map.Entry<String, String> ent : createDBMap.entrySet()) {
                String key = ent.getKey();
                String value = ent.getValue();
                LOGGER.debug("dbName Valid:" + key, (Object)"dropDB");
                if (!dbConnection.dbExist(dbInfor, key) || null == (pst = conn.createStatement())) continue;
                LOGGER.debug("DB " + key + "is exsist, Drop SQL :" + value, (Object)"dropDB");
                pst.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("drop DB error" + e, (Object)"dropDB");
        }
        finally {
            try {
                if (pst != null) {
                    pst.close();
                }
            }
            finally {
                conn.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixData(DataBaseInfo dbInfor) throws SQLException {
        if (null == this.dbinit) {
            return;
        }
        File[] insertDataFile = this.dbinit.getDataFiles();
        Connection conn = null;
        Statement st = null;
        if (null == insertDataFile || insertDataFile.length == 0) {
            return;
        }
        try {
            for (File file : insertDataFile) {
                int index2;
                int index1;
                String name = file.getName();
                String dbName = (name = Normalizer.normalize(name, Normalizer.Form.NFKC)).substring((index1 = name.indexOf("_")) + 1, index2 = name.indexOf(".sql"));
                conn = this.getDbConnection(dbInfor, dbName);
                if (null == conn) continue;
                int count = 0;
                List<String> sqls = this.getInsertList(file);
                if (sqls.size() < 1) {
                    conn.close();
                    continue;
                }
                st = conn.createStatement();
                for (String sql : sqls) {
                    if (null == sql || (sql = Normalizer.normalize(sql, Normalizer.Form.NFKC)).trim().length() <= 0) continue;
                    LOGGER.debug(" Count:" + count++, (Object)"fixData");
                }
                st.close();
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("drop DB error" + e, (Object)"dropDB");
        }
        finally {
            try {
                if (null != st) {
                    st.close();
                }
            }
            finally {
                if (null != conn) {
                    conn.close();
                }
            }
        }
    }

    private Connection getDbConnection(DataBaseInfo dbInfor, String dbName) {
        Connection conn = null;
        IDBConnection dbConnection = DBConnectionFactory.getInstance(dbInfor);
        if (null != dbConnection) {
            conn = dbConnection.connectionDB(dbInfor, dbName);
        }
        if (null == conn) {
            LOGGER.error("DB :" + dbName + "is not exsist, need not to excute sql ", (Object)"fixSql");
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixSql(DataBaseInfo dbInfor, List<File> sqlFile) throws SQLException {
        Connection conn = null;
        Statement st = null;
        if (null == sqlFile || null == dbInfor || null == dbInfor.getDbType()) {
            return;
        }
        try {
            for (File file : sqlFile) {
                String dbName = dbInfor.getDbName();
                conn = this.getDbConnection(dbInfor, dbName);
                if (null == conn) continue;
                int count = 0;
                List<String> sqls = this.getInsertList(file);
                if (sqls.size() < 1) {
                    conn.close();
                    continue;
                }
                st = conn.createStatement();
                for (String sql : sqls) {
                    if ((sql = Normalizer.normalize(sql, Normalizer.Form.NFKC)).trim().length() <= 0) continue;
                    LOGGER.debug(" Count:" + count++, (Object)"fixSql");
                }
                st.close();
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("SQL error", (Object)"fixSql");
        }
        finally {
            try {
                if (st != null) {
                    st.close();
                }
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixOtherSQLs(DataBaseInfo dbInfor) throws SQLException {
        Connection conn = null;
        Statement st = null;
        int count = 0;
        File[] otherSQLFiles = this.dbinit.getOtherFiles();
        if (null == otherSQLFiles) {
            return;
        }
        for (File file : otherSQLFiles) {
            try {
                String dbType = dbInfor.getDbType();
                dbType = Normalizer.normalize(dbType, Normalizer.Form.NFKC);
                IDBConnection dbConnection = DBConnectionFactory.getInstance(dbInfor);
                if (null == dbConnection) {
                    return;
                }
                conn = dbConnection.connection(dbInfor, false);
                if (null == conn) {
                    LOGGER.error("fixOtherSQLs error, conn is null.");
                    return;
                }
                st = conn.createStatement();
                List<String> sqls = this.getOtherSQLFilesList(file, dbType);
                if (SQLSERVER.equalsIgnoreCase(dbType)) {
                    for (String sql : sqls) {
                        sql = sql.replace(dbInfor.getDbNmsUserName(), "***");
                        sql = sql.replace(dbInfor.getDbUserName(), "***");
                        sql = sql.replace(dbInfor.getDbNmsPassword(), "***");
                        sql = sql.replace(dbInfor.getDbPassword(), "***");
                        LOGGER.debug("SQL:" + sql + " Count:" + count++, (Object)"fixOtherSQLs");
                    }
                    continue;
                }
                if (!MYSQL.equalsIgnoreCase(dbType)) continue;
                for (String sql : sqls) {
                    sql = sql.replace(dbInfor.getDbNmsUserName(), "***");
                    sql = sql.replace(dbInfor.getDbUserName(), "***");
                    sql = sql.replace(dbInfor.getDbNmsPassword(), "***");
                    sql = sql.replace(dbInfor.getDbPassword(), "***");
                    LOGGER.debug("SQL:" + sql + " Count:" + count++, (Object)"fixOtherSQLs");
                }
            }
            catch (IOException e) {
                LOGGER.error("Create triggers and storeprocedure error" + e, (Object)"fixOtherSQLs");
            }
            finally {
                try {
                    if (st != null) {
                        st.close();
                    }
                }
                finally {
                    if (conn != null) {
                        conn.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getOtherSQLFilesList(File fileName, String oSdbType) throws IOException {
        ArrayList<String> sqls = new ArrayList<String>();
        StringBuilder sql = new StringBuilder();
        BufferedReader reader = null;
        FileInputStream fileStream = null;
        try {
            fileStream = new FileInputStream(fileName);
            reader = new BufferedReader(new InputStreamReader((InputStream)fileStream, "utf-8"));
            String line = null;
            String dbType = Normalizer.normalize(oSdbType, Normalizer.Form.NFKC);
            if (SQLSERVER.equalsIgnoreCase(dbType)) {
                while ((line = reader.readLine()) != null) {
                    line = Normalizer.normalize(line, Normalizer.Form.NFKC);
                    sql.append(line + "\n");
                    if (!line.trim().endsWith(suffix)) continue;
                    String temp = sql.toString();
                    temp = Normalizer.normalize(temp, Normalizer.Form.NFKC);
                    temp = temp.replace(suffix, "");
                    sqls.add(temp);
                }
            } else if (MYSQL.equalsIgnoreCase(dbType)) {
                while ((line = reader.readLine()) != null) {
                    if ((line = Normalizer.normalize(line, Normalizer.Form.NFKC)).trim().startsWith(MYSQL_KEYWORD_DELIMITER)) {
                        suffix = line.replaceAll(MYSQL_KEYWORD_DELIMITER, "").trim();
                        continue;
                    }
                    sql.append(line + "\n");
                    if (!line.trim().endsWith(suffix)) continue;
                    String tmp = sql.toString();
                    tmp = tmp.replace(suffix, MYSQL_DEFAULT_SUFFIX);
                    sqls.add(tmp);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("drop DB error" + e, (Object)"dropDB");
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.error("drop DB error {}", (Throwable)e);
                }
            }
            if (null != fileStream) {
                try {
                    fileStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("drop DB error {}", (Throwable)e);
                }
            }
        }
        return sqls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getInsertList(File fileName) {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader bufferReader = null;
        InputStreamReader fileReader = null;
        FileInputStream fileInStreamTmp = null;
        String text = null;
        try {
            fileInStreamTmp = new FileInputStream(fileName);
            fileReader = new InputStreamReader((InputStream)fileInStreamTmp, "utf-8");
            bufferReader = new BufferedReader(fileReader);
            while ((text = bufferReader.readLine()) != null) {
                list.add(text);
            }
        }
        catch (IOException e) {
            try {
                LOGGER.error("getInsertList", (Throwable)e);
            }
            catch (Throwable throwable) {
                StreamProcUtil.close(bufferReader);
                StreamProcUtil.close(fileReader);
                StreamProcUtil.close(fileInStreamTmp);
                throw throwable;
            }
            StreamProcUtil.close(bufferReader);
            StreamProcUtil.close(fileReader);
            StreamProcUtil.close(fileInStreamTmp);
        }
        StreamProcUtil.close(bufferReader);
        StreamProcUtil.close(fileReader);
        StreamProcUtil.close(fileInStreamTmp);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fixTable(DataBaseInfo dbInfor) throws SQLException {
        Connection conn = null;
        ResultSet rs = null;
        Map<String, String> createTableMap = this.dbinit.getTable();
        Iterator<Map.Entry<String, String>> entry = createTableMap.entrySet().iterator();
        try {
            while (entry.hasNext()) {
                IDBConnection dbConnection;
                Map.Entry<String, String> ent = entry.next();
                String key = ent.getKey();
                String value = ent.getValue();
                key = Normalizer.normalize(key, Normalizer.Form.NFKC);
                int index = key.indexOf(".");
                String dbName = null;
                String tableName = null;
                if (index >= 0) {
                    dbName = key.substring(0, index);
                    tableName = key.substring(index + 1);
                }
                if (null == (dbConnection = DBConnectionFactory.getInstance(dbInfor))) {
                    return;
                }
                conn = dbConnection.connectionDB(dbInfor, dbName);
                if (null == conn) {
                    LOGGER.debug("DB :" + dbName + "is not exsist, need not to excute create table sql ", (Object)"fixTable");
                    continue;
                }
                DatabaseMetaData meta = conn.getMetaData();
                rs = meta.getTables(null, null, tableName, null);
                if (!rs.next()) {
                    String sql = value;
                    LOGGER.debug(key + " is not exsist, So create:" + sql, (Object)"fixTable");
                }
                rs.close();
                conn.close();
            }
        }
        catch (SQLException e) {
            LOGGER.error("fixTable", (Throwable)e);
        }
        finally {
            StreamProcUtil.close(rs);
            StreamProcUtil.close(conn);
        }
    }
}

