/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.base.model.CpuMemoryInfo;
import com.huawei.elog.util.BytesUtil;
import com.sun.management.OperatingSystemMXBean;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.lang.management.ManagementFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorCpuInfo {
    private static final int CPUTIME = 30;
    private static final int PERCENT = 100;
    private static final int FAULTLENGTH = 10;
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorCpuInfo.class);

    public CpuMemoryInfo getMonitorInfoBean() {
        int kb = 1024;
        OperatingSystemMXBean osmxb = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
        String osName = System.getProperty("os.name");
        long totalMemorySize = osmxb.getTotalPhysicalMemorySize() / (long)kb;
        long freePhysicalMemorySize = osmxb.getFreePhysicalMemorySize() / (long)kb;
        long usedMemory = (osmxb.getTotalPhysicalMemorySize() - osmxb.getFreePhysicalMemorySize()) / (long)kb;
        double cpuRatio = 0.0;
        if (osName.toLowerCase().startsWith("windows")) {
            cpuRatio = this.getCpuRatioForWindows();
        }
        CpuMemoryInfo infoBean = new CpuMemoryInfo();
        infoBean.setFreePhysicalMemorySize(freePhysicalMemorySize);
        infoBean.setOsName(osName);
        infoBean.setTotalMemorySize(totalMemorySize);
        infoBean.setUsedMemory(usedMemory);
        infoBean.setCpuRatio(cpuRatio);
        LOGGER.info("totalMemorySize :  " + totalMemorySize);
        LOGGER.info("freePhysicalMemorySize :  " + freePhysicalMemorySize);
        return infoBean;
    }

    private double getCpuRatioForWindows() {
        try {
            String procCmd = System.getenv("windir") + "\\system32\\wbem\\wmic.exe process get Caption,CommandLine,KernelModeTime,ReadOperationCount,ThreadCount,UserModeTime,WriteOperationCount";
            long[] c0 = this.readCpu(Runtime.getRuntime().exec(procCmd));
            Thread.sleep(30L);
            long[] c1 = this.readCpu(Runtime.getRuntime().exec(procCmd));
            if (c0 != null && c1 != null) {
                long idletime = c1[0] - c0[0];
                long busytime = c1[1] - c0[1];
                return 100L * busytime / (busytime + idletime);
            }
            return 0.0;
        }
        catch (Exception ex) {
            LOGGER.error("getCpuRatioForWindows : ", (Throwable)ex);
            return 0.0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized long[] readCpu(Process proc) {
        long[] retn = new long[2];
        try {
            proc.getOutputStream().close();
            InputStreamReader ir = new InputStreamReader(proc.getInputStream());
            LineNumberReader input = new LineNumberReader(ir);
            String line = input.readLine();
            if (line == null || line.length() < 10) {
                long[] lArray = null;
                return lArray;
            }
            int capidx = line.indexOf("Caption");
            int cmdidx = line.indexOf("CommandLine");
            int rocidx = line.indexOf("ReadOperationCount");
            int umtidx = line.indexOf("UserModeTime");
            int kmtidx = line.indexOf("KernelModeTime");
            int wocidx = line.indexOf("WriteOperationCount");
            long idletime = 0L;
            long kneltime = 0L;
            long usertime = 0L;
            while ((line = input.readLine()) != null) {
                if (line.length() < wocidx) continue;
                String caption = BytesUtil.substring(line, capidx, cmdidx - 1).trim();
                String cmd = BytesUtil.substring(line, cmdidx, kmtidx - 1).trim();
                if (cmd.indexOf("wmic.exe") >= 0) continue;
                if (caption.equals("System Idle Process") || caption.equals("System")) {
                    idletime += Long.valueOf(BytesUtil.substring(line, kmtidx, rocidx - 1).trim()).longValue();
                    idletime += Long.valueOf(BytesUtil.substring(line, umtidx, wocidx - 1).trim()).longValue();
                    continue;
                }
                kneltime += Long.valueOf(BytesUtil.substring(line, kmtidx, rocidx - 1).trim()).longValue();
                usertime += Long.valueOf(BytesUtil.substring(line, umtidx, wocidx - 1).trim()).longValue();
            }
            retn[0] = idletime;
            retn[1] = kneltime + usertime;
            long[] lArray = retn;
            return lArray;
        }
        catch (Exception ex) {
            LOGGER.error("readCpu :   ", (Throwable)ex);
        }
        finally {
            try {
                if (proc.getInputStream() != null) {
                    proc.getInputStream().close();
                }
            }
            catch (Exception e) {
                LOGGER.error("readCpu :   ", (Throwable)e);
            }
        }
        return null;
    }
}

