/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.base.model.DataBaseInfo;
import com.huawei.elog.util.DBConnection;
import com.huawei.elog.util.IDBConnection;
import com.huawei.elog.util.db.DBUtil;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlConnection
extends DBConnection
implements IDBConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MysqlConnection.class);

    @Override
    public Connection connection(DataBaseInfo dbInfor, boolean isNms) {
        Connection conn = null;
        try {
            String host = dbInfor.getDbHost();
            int port = Integer.parseInt(dbInfor.getDbPort());
            String user = dbInfor.getDbUserName();
            String password = dbInfor.getDbPassword();
            String url = "jdbc:mysql://" + host + ":" + port + "?useSSL=false&serverTimezone=" + DBUtil.curTimeZone();
            Class.forName("com.mysql.jdbc.Driver");
            conn = DriverManager.getConnection(url, user, password);
        }
        catch (SQLException e) {
            LOGGER.error("DB Connection Test Error " + e.getMessage(), (Object)"connectionMySql");
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("DB Connection Test Error " + e.getMessage(), (Object)"connectionMySql");
        }
        return conn;
    }

    @Override
    public Connection connectionDB(DataBaseInfo dbInfor, String dbName) {
        Connection conn = null;
        try {
            String host = dbInfor.getDbHost();
            int port = Integer.parseInt(dbInfor.getDbPort());
            String user = dbInfor.getDbUserName();
            String password = dbInfor.getDbPassword();
            String url = "jdbc:mysql://" + host + ":" + port + "/" + dbName + "?useSSL=false&serverTimezone=" + DBUtil.curTimeZone();
            Class.forName("com.mysql.jdbc.Driver");
            conn = DriverManager.getConnection(url, user, password);
        }
        catch (SQLException e) {
            LOGGER.error("DB Connection Test Error " + e.getMessage(), (Object)"connectMYSQLDB");
            return null;
        }
        catch (ClassNotFoundException e) {
            LOGGER.error("DB Connection Test Error " + e.getMessage(), (Object)"connectMYSQLDB");
            return null;
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExistDB(DataBaseInfo dbInfo) {
        Connection conn = null;
        try {
            conn = this.connection(dbInfo, false);
            boolean bl = this.isExistBizDatabase(conn);
            return bl;
        }
        catch (Exception e) {
            LOGGER.error("DB Connection Test Error", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (null != conn) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOGGER.error("isExistMysqlDB", (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean isConnected(DataBaseInfo dbInfo, boolean isNmsUser) {
        if (null == dbInfo) {
            LOGGER.error("dbInfo object args is null. ", (Object)"isConnMysql");
            return false;
        }
        String user = null;
        String password = null;
        String url = null;
        String driver = null;
        if (isNmsUser) {
            user = dbInfo.getDbNmsUserName();
            password = dbInfo.getDbNmsPassword();
        } else {
            user = dbInfo.getDbUserName();
            password = dbInfo.getDbPassword();
        }
        if (null == user || null == password) {
            LOGGER.error("get user and password from dbInfo bean is null. ", (Object)"isConnMysql");
            return false;
        }
        String host = dbInfo.getDbHost();
        String port = dbInfo.getDbPort();
        if (null == host || null == port) {
            LOGGER.error("get host and port from dbInfo bean is null, host: " + host + " , port: " + port, (Object)"isConnMysql");
            return false;
        }
        host = "127.0.0.1";
        url = "jdbc:mysql://" + host + ":" + port + "?useSSL=false&serverTimezone=" + DBUtil.curTimeZone();
        driver = "com.mysql.jdbc.Driver";
        LOGGER.info("MysqlConnection : url : " + url);
        return this.getConnectedStatus(user, url, password, driver);
    }

    @Override
    public boolean isExistCommonuser(DataBaseInfo dbInfo) {
        return false;
    }
}

