/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.util.ResourceManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OSUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(OSUtil.class);
    private static final String X64 = "x64";
    private static final String X86 = "x86";
    private static final String QUERY_SERVICE_CMD = "sc query Had";
    private static final String SERVICE = "SERVICE_NAME:";
    private static final String HAD = "Had";

    private OSUtil() {
    }

    public static boolean isX64() {
        String osType = OSUtil.findOSType();
        return X64.equalsIgnoreCase(osType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findOSType() {
        Properties props = System.getProperties();
        if (props.getProperty("os.name").equalsIgnoreCase("linux")) {
            return X64;
        }
        Runtime runtime = Runtime.getRuntime();
        BufferedReader bufReader = null;
        InputStreamReader inStreamReader = null;
        InputStream inStream = null;
        Process process = null;
        String type = X86;
        try {
            String str = "cmd /c systeminfo | findstr \"based\"";
            process = runtime.exec(str);
            inStream = process.getInputStream();
            inStreamReader = new InputStreamReader(inStream, "utf-8");
            bufReader = new BufferedReader(inStreamReader);
            String listeningCmdLine = bufReader.readLine();
            while (null != listeningCmdLine) {
                if (listeningCmdLine.contains("based")) {
                    type = listeningCmdLine.split(":")[1].trim().substring(0, 3);
                    type = StringUtils.isNotEmpty((CharSequence)type) ? type.toLowerCase(Locale.US) : X86;
                    break;
                }
                listeningCmdLine = bufReader.readLine();
            }
            LOGGER.debug("find System's type is::: {}", (Object)type);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("find System's type Exception", (Throwable)e);
        }
        finally {
            if (null != bufReader) {
                try {
                    bufReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("close io occurs error.", (Throwable)e);
                }
            }
            if (null != inStreamReader) {
                try {
                    inStreamReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("close io occurs error.", (Throwable)e);
                }
            }
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("close io occurs error.", (Throwable)e);
                }
            }
            if (null != process) {
                process.destroy();
            }
        }
        return type;
    }

    public static List<String> getLocalAllIps() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface nif = e.nextElement();
                Enumeration<InetAddress> l = nif.getInetAddresses();
                while (l.hasMoreElements()) {
                    InetAddress address = l.nextElement();
                    if (!(address instanceof Inet4Address)) continue;
                    String ipAddress = address.getHostAddress();
                    LOGGER.debug("ip:{}", (Object)ipAddress);
                    if (ipAddress.startsWith("127.0.0.")) continue;
                    list.add(ipAddress);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("get Local IP Error " + e.getMessage(), (Object)"getLocalAllIps");
        }
        return list;
    }

    public static String getLocalFirstIp() {
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface nif = e.nextElement();
                Enumeration<InetAddress> l = nif.getInetAddresses();
                while (l.hasMoreElements()) {
                    String ipAddress;
                    InetAddress address = l.nextElement();
                    if (!(address instanceof Inet4Address) || (ipAddress = address.getHostAddress()).startsWith("127.0.0")) continue;
                    return ipAddress;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("get local first ip occurs error.", (Throwable)e);
        }
        return null;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").contains("Windows");
    }

    public static boolean isChineseLocale() {
        return "zh".equalsIgnoreCase(ResourceManager.getLocale().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isVcsInstalled() {
        if (System.getProperty("os.name").contains("Windows")) {
            StringBuffer parameters = new StringBuffer();
            parameters.append("cmd.exe /C ");
            parameters.append(QUERY_SERVICE_CMD);
            BufferedReader exeRead = null;
            try {
                Runtime run = Runtime.getRuntime();
                Process process = run.exec(parameters.toString());
                exeRead = new BufferedReader(new InputStreamReader(process.getInputStream(), "utf-8"));
                String line = null;
                while ((line = exeRead.readLine()) != null) {
                    if (!line.contains(SERVICE) || !line.contains(HAD)) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("Fail to choose vcs services.", (Throwable)e);
            }
            finally {
                if (exeRead != null) {
                    try {
                        exeRead.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("Fail to close exeRead buffered reader.", (Throwable)e);
                    }
                }
            }
            return false;
        }
        File file = new File("/etc/init.d/vcs");
        return file.isFile();
    }
}

