/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.common.StreamProcUtil;
import com.huawei.elog.util.XmlWriterFactory;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public final class ParseXmlUtil {
    public static final String FILE_NAME = "legoStartup.xml";
    public static final String XML_FILE_NAME = "legoInstalled.xml";
    private static final Logger LOGGER = LoggerFactory.getLogger(ParseXmlUtil.class);

    private ParseXmlUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerServiceName(String serviceName, String path) throws IOException {
        String fileName = path + "/Runtime/bin/etc/config/conf/" + FILE_NAME;
        File file = new File(fileName);
        SAXReader sax = new SAXReader();
        try {
            sax.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            sax.setFeature("http://xml.org/sax/features/external-general-entities", false);
            sax.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (SAXException ex) {
            throw new IOException(ex.getLocalizedMessage());
        }
        Document document = null;
        XMLWriter w = null;
        try {
            document = sax.read(file);
            List elList = document.selectNodes("/startup");
            for (Element el : elList) {
                Element serviceEl = el.addElement("service");
                serviceEl.addAttribute("serviceName", serviceName);
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            w = XmlWriterFactory.getXmlWriter(file, format);
            w.write(document);
            LOGGER.debug("write", (Object)"success");
            StreamProcUtil.close(w);
        }
        catch (DocumentException e) {
            LOGGER.error("parse document occurs error.", (Throwable)e);
        }
        finally {
            StreamProcUtil.close(w);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void registerHttpPortName(String httpPort, String path) throws IOException {
        String fileName = path + "/Runtime/monitor/" + XML_FILE_NAME;
        File file = new File(fileName);
        SAXReader sax = new SAXReader();
        try {
            sax.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            sax.setFeature("http://xml.org/sax/features/external-general-entities", false);
            sax.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        }
        catch (SAXException ex) {
            throw new IOException(ex.getLocalizedMessage());
        }
        Document document = null;
        XMLWriter xmlwrite = null;
        try {
            document = sax.read(file);
            List elist = document.selectNodes("install");
            for (Element el : elist) {
                Element httpEle = el.addElement("httport");
                httpEle.addText(httpPort);
                Element pathElement = el.addElement("installpath");
                pathElement.addAttribute("path", path);
            }
            OutputFormat format = OutputFormat.createPrettyPrint();
            xmlwrite = XmlWriterFactory.getXmlWriter(file, format);
            xmlwrite.write(document);
            LOGGER.debug("write success", (Object)"registerHttpPortName");
            StreamProcUtil.close(xmlwrite);
            return;
        }
        catch (RuntimeException e) {
            throw e;
            catch (Exception e2) {
                LOGGER.error("parse document occurs error.", (Throwable)e2);
                return;
            }
        }
        finally {
            StreamProcUtil.close(xmlwrite);
        }
    }
}

