/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import java.text.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class PathCheckUtil {
    public static String checkPathEnd(String filePath) {
        String path = Normalizer.normalize(filePath, Normalizer.Form.NFKC);
        while (path.endsWith("/") || path.endsWith("\\")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static boolean checkPathChar(String basePath) {
        String[] folderNames;
        String checkPath = basePath;
        String normalizeOsName = Normalizer.normalize(System.getProperty("os.name"), Normalizer.Form.NFKC);
        if (normalizeOsName.contains("Windows")) {
            String unRootPath = checkPath.replace("\\", "/");
            unRootPath = unRootPath.substring(unRootPath.indexOf(":/") + 2);
            folderNames = unRootPath.split("/");
        } else {
            folderNames = checkPath.split("/");
        }
        for (String folder : folderNames) {
            boolean flag1;
            if (folder.length() == 0) continue;
            String normalizeFolder = Normalizer.normalize(folder, Normalizer.Form.NFKC);
            Pattern pattern = Pattern.compile("^[\\u4e00-\\u9fa5\\w-\\s*.]+$");
            Matcher matcher = pattern.matcher(normalizeFolder);
            boolean flag = matcher.matches();
            boolean bl = flag1 = normalizeFolder.indexOf("  ") == -1;
            if (flag && flag1) continue;
            return false;
        }
        return true;
    }
}

