/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.exception.RunningException;
import com.huawei.elog.base.model.ContextPropVal;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.ProUtil;
import com.huawei.elog.util.PropertyManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.HashSet;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PortCheckUtil {
    public static final int PORT_OK = -1;
    private static final Logger LOGGER = LoggerFactory.getLogger(PortCheckUtil.class);
    private static InstallContext instance = InstallContext.getInstance();

    private PortCheckUtil() {
    }

    public static int checkSystemUsing() {
        boolean backEnd = false;
        boolean frontEnd = false;
        if (instance.getEnvirments().isSystemInstalled()) {
            int rmiPortNumber;
            String portStr;
            ContextPropVal httpPortVal = instance.getPropertyMap().getProp("lego.port.http");
            if (httpPortVal != null && (portStr = httpPortVal.getValue().toString()).length() > 0) {
                try {
                    int httpPort = Integer.parseInt(portStr);
                    frontEnd = PortCheckUtil.checkPortUsed(httpPort);
                    if (!frontEnd) {
                        return httpPort;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("HTTP Port is illeagl:" + portStr, (Object)"checkSystemUsing");
                }
            }
            if (!(backEnd = PortCheckUtil.checkPortUsed(rmiPortNumber = Integer.parseInt(PropertyManager.getProValue("rmi.port"))))) {
                return rmiPortNumber;
            }
        }
        return -1;
    }

    public static boolean isCheckSystemUsing() {
        boolean backEnd = false;
        boolean frontEnd = false;
        try {
            String rmiPortNumber = (String)ProUtil.getPro("lego.properties", "base.rmi_port");
            int httpPort = ProUtil.getHttpPort();
            if (0 != httpPort) {
                frontEnd = PortCheckUtil.checkPortUsed(httpPort);
            }
            if (rmiPortNumber != null) {
                backEnd = PortCheckUtil.checkPortUsed(Integer.parseInt(rmiPortNumber.trim()));
            }
        }
        catch (RunningException e) {
            LOGGER.error("IN PortCheckUtil:RunningException", (Throwable)e);
        }
        return backEnd || frontEnd;
    }

    public static boolean checkPortUsed(int port) {
        try {
            return PortCheckUtil.bindPort(ContextUtil.getStrValueFromCtx("lego.base.installIpAddress"), port);
        }
        catch (Exception e) {
            LOGGER.error("IN PortCheckUtil:", (Throwable)e);
            LOGGER.error("IN PortCheckUtil:", (Throwable)new RunningException("port +" + port + " is used."));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean bindPort(String host, int port) {
        ServerSocket s = null;
        try {
            s = new ServerSocket();
            s.bind(new InetSocketAddress(host, port));
            LOGGER.debug(host + ":" + port, (Object)"##--Can Use--##");
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.debug("##--Can Not Use--##", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (s != null) {
                try {
                    s.close();
                }
                catch (IOException e) {
                    LOGGER.error("close io occurs error.", (Throwable)e);
                }
            }
        }
    }

    public static boolean checkPortRepeat(String[] ports) {
        boolean valid = false;
        HashSet<String> set = new HashSet<String>();
        for (String port : ports) {
            if (set.contains(port)) {
                return true;
            }
            set.add(port);
        }
        return valid;
    }

    public static boolean isInvalid4PortRang(String port) {
        boolean isInvalid = true;
        try {
            Long ptLong = Long.parseLong(port);
            if (ptLong < 1L || ptLong > 65535L) {
                isInvalid = false;
            }
        }
        catch (NumberFormatException e) {
            LOGGER.error("Port format is error :" + port, (Object)"checkPort");
        }
        return isInvalid;
    }

    public static boolean isInvalid4PortInput(String port) {
        boolean isInvalid = true;
        if (port.length() > 5) {
            LOGGER.error("Invalid port , please check.");
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]*");
        if (!pattern.matcher(port).matches()) {
            LOGGER.error("Invalid port , please check.");
            return false;
        }
        return isInvalid;
    }
}

