/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.base.exception.StartException;
import com.huawei.elog.base.model.Program;
import com.huawei.elog.base.sdk.IConstant;
import com.huawei.elog.base.tools.PortHelper;
import com.huawei.elog.common.StreamProcUtil;
import com.huawei.elog.util.IOUtil;
import com.huawei.elog.util.ProUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ProgramUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProgramUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execCommand(String command) {
        if (!ProgramUtil.validateCmd(command)) {
            LOGGER.error("executeCommand error, command is invalid.");
            return;
        }
        Process process = null;
        try {
            String[] finalCmd = command.split(" ");
            ProcessBuilder pb = new ProcessBuilder(finalCmd);
            pb.redirectErrorStream(true);
            process = pb.start();
            InputStream inStream = process.getInputStream();
            InputStreamReader inStreamReader = new InputStreamReader(inStream, "utf-8");
            BufferedReader bufReader = new BufferedReader(inStreamReader);
            try {
                String commandLine = null;
                while (null != (commandLine = bufReader.readLine())) {
                    LOGGER.info("execCommand", (Object)"execCommand");
                }
            }
            catch (IOException e) {
                LOGGER.error("Executing task list command has error happened." + e, (Object)"execCommand");
            }
            finally {
                IOUtil.closeReader(bufReader);
                IOUtil.closeReader(inStreamReader);
                IOUtil.closeInputStream(inStream);
                process.destroy();
            }
            process.waitFor();
        }
        catch (InterruptedException e) {
            LOGGER.error("Executing command has error happened." + e, (Object)"execCommand");
            LOGGER.error("in ProgramUtil:execCommand", (Throwable)new StartException(10005L));
            throw new StartException(10005L);
        }
        catch (IOException e) {
            LOGGER.error("Executing command has error happened." + e, (Object)"execCommand");
            LOGGER.error("in ProgramUtil:execCommand", (Throwable)new StartException(10005L));
            throw new StartException(10005L);
        }
        finally {
            if (null != process) {
                process.destroy();
            }
        }
    }

    private static boolean validateCmd(String arg) {
        String[] badInput = new String[]{"&&", "&", "||", "|", ";", "$", ">", ">>", "<"};
        arg = Normalizer.normalize(arg, Normalizer.Form.NFKC);
        for (String bad : badInput) {
            if (!arg.contains(bad)) continue;
            return false;
        }
        return true;
    }

    public static void killLegoProgress() {
        LOGGER.info("Begin shutDownSystem.", (Object)"killLegoProgress");
        String rmiPortNumber = (String)ProUtil.getPro("lego.properties", "base.rmi_port");
        int httpPort = ProUtil.getHttpPort();
        LOGGER.info("rmiPortNumber: " + rmiPortNumber, (Object)"killLegoProgress");
        Program backendPg = ProgramUtil.getProgramByPort(Integer.parseInt(rmiPortNumber));
        Program foreendPg = ProgramUtil.getProgramByPort(httpPort);
        ArrayList<Integer> pidList = new ArrayList<Integer>();
        if (null != backendPg) {
            pidList.add(backendPg.getPid());
        }
        if (null != foreendPg) {
            pidList.add(foreendPg.getPid());
        }
        int[] pids = new int[pidList.size()];
        for (int i = 0; i < pidList.size(); ++i) {
            pids[i] = (Integer)pidList.get(i);
        }
        ProgramUtil.killProgramByPid(pids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killProgramByPid(int ... programPids) {
        Process process;
        block11: {
            LOGGER.info("Kill Program...", (Object)"killProgramByPid");
            if (null == programPids || 0 == programPids.length) {
                return;
            }
            InputStreamReader ir = null;
            StringBuffer command = new StringBuffer();
            process = null;
            LineNumberReader input = null;
            command.append("taskkill");
            for (int programPid : programPids) {
                command.append(" /PID " + programPid);
            }
            command.append(" /F");
            try {
                ProcessBuilder pb = new ProcessBuilder(command.toString().split(" "));
                pb.redirectErrorStream(true);
                process = pb.start();
                ir = new InputStreamReader(process.getInputStream(), "utf-8");
                input = new LineNumberReader(ir);
                String line = input.readLine();
                while (line != null) {
                    line = input.readLine();
                }
                StreamProcUtil.close(input);
            }
            catch (IOException e) {
                LOGGER.error("Killing program by process id has error happened: ", (Throwable)e);
                break block11;
            }
            finally {
                StreamProcUtil.close(input);
                StreamProcUtil.close(ir);
            }
            StreamProcUtil.close(ir);
        }
        if (null != process) {
            int exitValue = -1;
            try {
                exitValue = process.waitFor();
            }
            catch (InterruptedException e) {
                LOGGER.error("Killing program by process id has error happened." + exitValue);
            }
            LOGGER.info("Killing program by process id successed.ExitCode=", (Object)exitValue);
        }
    }

    public static Program getProgramByPort(int port) {
        return ProgramUtil.getProgramByPort(null, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Program getProgramByPort(String strProtocol, int port) {
        StringBuffer command = new StringBuffer();
        command.append("cmd /c netstat -aon ");
        if (null != strProtocol && !strProtocol.trim().isEmpty()) {
            command.append(" | findstr \"");
            command.append(strProtocol);
            command.append('\"');
            if ("TCP".equals(strProtocol)) {
                command.append(" | findstr \"LISTENING\"");
            }
        }
        command.append(" | findstr \".*:");
        command.append(port);
        command.append("\\>\"");
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(command.toString());
        }
        catch (IOException e) {
            LOGGER.error("Getting program by ports has error happened. port:" + port, (Throwable)e);
            return new Program();
        }
        Program program = null;
        InputStream inStream = null;
        InputStreamReader inStreamReader = null;
        BufferedReader bufReader = null;
        try {
            inStream = process.getInputStream();
            inStreamReader = new InputStreamReader(inStream, "utf-8");
            bufReader = new BufferedReader(inStreamReader);
            String listeningCmdLine = null;
            while (null != (listeningCmdLine = bufReader.readLine())) {
                String[] strArray = listeningCmdLine.trim().split("[ ]+");
                String[] ipPort = strArray[1].trim().split(":");
                int parsePort = Integer.parseInt(ipPort[ipPort.length - 1]);
                if (parsePort != port) {
                    LOGGER.info("parsePort is not equal to port of argument: " + port + " - " + parsePort, (Object)"parseListeningCmdLine");
                    continue;
                }
                LOGGER.debug("cmd line parse result: " + Arrays.asList(strArray), (Object)"findProgramByPorts");
                int pid = Integer.parseInt(strArray[strArray.length - 1]);
                program = new Program();
                program.setPid(pid);
                program.addPort(port);
                break;
            }
        }
        catch (IOException e) {
            try {
                LOGGER.error("Getting program by ports has error happened. prot:" + port + e, (Object)"getProgramByPorts");
            }
            catch (Throwable throwable) {
                IOUtil.closeReader(bufReader);
                IOUtil.closeReader(inStreamReader);
                IOUtil.closeInputStream(inStream);
                process.destroy();
                throw throwable;
            }
            IOUtil.closeReader(bufReader);
            IOUtil.closeReader(inStreamReader);
            IOUtil.closeInputStream(inStream);
            process.destroy();
        }
        IOUtil.closeReader(bufReader);
        IOUtil.closeReader(inStreamReader);
        IOUtil.closeInputStream(inStream);
        process.destroy();
        return program;
    }

    public static List<Program> getProgramListTakePortIllegally(String strVersion, Boolean isRun) {
        LinkedList<Program> lPro = new LinkedList<Program>();
        Map<String, List<String>> portMap = PortHelper.getInstance().getPortMap(strVersion);
        for (Map.Entry<String, List<String>> entry : portMap.entrySet()) {
            String protocol = entry.getKey();
            List<String> portList = entry.getValue();
            int port = -1;
            for (int j = 0; j < portList.size(); ++j) {
                Program p;
                port = Integer.parseInt(portList.get(j));
                if ((IConstant.INDEPENDENT_HTTP_PORT == port || IConstant.INDEPENDENT_HTTPS_PORT == port) && !isRun.booleanValue() || null == (p = ProgramUtil.getProgramByPort(protocol, port))) continue;
                boolean portExist = false;
                for (Program pro : lPro) {
                    if (pro.getPid() != p.getPid()) continue;
                    portExist = true;
                    List<Integer> parsePorts = p.getPorts();
                    for (Integer parsePort : parsePorts) {
                        pro.addPort(parsePort);
                    }
                }
                if (portExist) continue;
                lPro.add(p);
            }
            LOGGER.debug("Portocol: " + protocol + ", List: " + portList, (Object)"test");
        }
        for (Program program : lPro) {
            LOGGER.debug("The processes takes the port illegally: " + program, (Object)"checkPortUsed");
        }
        return lPro;
    }
}

