/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.model.EnvirmentProps;
import com.huawei.elog.util.JarFileUtil;
import com.huawei.elog.util.PropertyUtil;
import java.io.File;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PropertyManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyManager.class);
    private static final Map<String, String> PROP_POOL = new HashMap<String, String>();
    private static final String CONFIG_FILE = "/etc/config/conf";

    public static synchronized void registerPropertyFile() {
        String filePath = null;
        String basePath = EnvirmentProps.getInstance().getBasePath();
        if (basePath == null || basePath.trim().isEmpty()) {
            LOGGER.warn("Faild to get base path.");
            basePath = JarFileUtil.getProjectPath();
        }
        filePath = basePath + CONFIG_FILE;
        LOGGER.info("Base path: {}", (Object)basePath);
        LOGGER.info("Db config base path: {}", (Object)filePath);
        if (basePath == null) {
            LOGGER.warn("Faild to get install package path.");
            LOGGER.info("USER DIR: {}", (Object)System.getProperty("user.dir"));
            String configFile = System.getProperty("user.dir");
            if (null != configFile) {
                if ((configFile = Normalizer.normalize(configFile, Normalizer.Form.NFKC)).contains("collector") && !configFile.contains("uninstall")) {
                    String configPaht = configFile.substring(0, System.getProperty("user.dir").lastIndexOf("\\"));
                    filePath = configPaht + "/" + CONFIG_FILE;
                }
            } else {
                filePath = CONFIG_FILE;
            }
        }
        LOGGER.info("Db config saving path: {}", (Object)filePath);
        File dir = new File(filePath);
        File[] files = dir.listFiles();
        if (null != files && files.length > 0) {
            for (File file : files) {
                String normalizeName = Normalizer.normalize(file.getName(), Normalizer.Form.NFKC);
                if (!normalizeName.endsWith(".properties")) continue;
                PropertyUtil enProperties = new PropertyUtil(file);
                Properties pro = enProperties.getProp();
                Set<Map.Entry<Object, Object>> set = pro.entrySet();
                for (Map.Entry<Object, Object> entry : set) {
                    PROP_POOL.put(String.valueOf(entry.getKey()), String.valueOf(entry.getValue()));
                }
            }
        }
    }

    public static String getProValue(String key) {
        String value = PROP_POOL.get(key);
        if (null != value) {
            value = value.trim();
        }
        return value;
    }

    public static void setProValue(String key, String value) {
        PROP_POOL.put(key, value);
    }

    private static void init() {
        try {
            PropertyManager.registerPropertyFile();
            String softWareName = PropertyManager.getProValue("software.install.name");
            if ("legoPlat".equals(InstallContext.getInstance().getInstallType())) {
                softWareName = PropertyManager.getProValue("software.install.name");
            } else if ("Collector".equals(InstallContext.getInstance().getInstallType())) {
                softWareName = PropertyManager.getProValue("software.install.name") + " " + "Collector";
            }
            LOGGER.debug("softWareName: " + softWareName, (Object)"init");
            if (null != softWareName) {
                PropertyManager.setProValue("software.install.name", softWareName);
            } else {
                LOGGER.debug("config :" + PROP_POOL.get("software.install.name"), (Object)"init");
                PropertyManager.setProValue("software.install.name", PROP_POOL.get("software.install.name"));
            }
        }
        catch (Exception e) {
            LOGGER.error("parse porperty manager occurs error.", (Throwable)e);
        }
    }

    static {
        PropertyManager.init();
    }
}

