/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.common.StreamProcUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyUtil.class);
    private Properties prop = null;

    public PropertyUtil(String fileName) {
        this.init(new File(fileName));
    }

    public PropertyUtil(File file) {
        this.init(file);
    }

    public Properties getProp() {
        return this.prop;
    }

    public void setProp(Properties prop) {
        this.prop = prop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void init(File file) {
        this.prop = new Properties();
        BufferedReader br = null;
        FileInputStream in = null;
        InputStreamReader isr = null;
        try {
            in = new FileInputStream(file);
            isr = new InputStreamReader((InputStream)in, "GBK");
            br = new BufferedReader(isr);
            this.prop.load(br);
            StreamProcUtil.close(br);
        }
        catch (RuntimeException e) {
            throw e;
            catch (Exception e2) {
                LOGGER.error("porperty load source file occurs error: ", (Throwable)e2);
                return;
            }
        }
        StreamProcUtil.close(isr);
        StreamProcUtil.close((InputStream)in);
        return;
        finally {
            StreamProcUtil.close(br);
            StreamProcUtil.close(isr);
            StreamProcUtil.close((InputStream)in);
        }
    }

    public String getValue(String key) {
        String value = this.prop.getProperty(key).trim();
        return value;
    }
}

