/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.base.model.EnvirmentProps;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.JarFileUtil;
import com.huawei.elog.util.PropertyUtil;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResourceManager {
    private static Locale resourceLocale = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceManager.class);
    private static final Map<Locale, Map<String, String>> LAUG_POOL = new HashMap<Locale, Map<String, String>>();
    private static final Map<Locale, Map<String, String>> PACKAGE_RES_POOL = new HashMap<Locale, Map<String, String>>();
    private static final String BASE_PATH = EnvirmentProps.getInstance().getBasePath();
    private static final String I18N_FILE = "etc/resource/i18n";
    private static final String I18N_ESIGHTPACKAGE_FILE = "etc/resource/i18n/package";
    private static final String IMAGES_PATH_PREFIX = "etc/resource/images/";
    private static final String EN_FILE = "_en";
    private static final String CN_FILE = "_zh";

    public static void registerResFile() {
        File dir;
        File[] files;
        String filePath = null;
        String basePath = EnvirmentProps.getInstance().getBasePath();
        if (basePath == null || basePath.trim().isEmpty()) {
            basePath = JarFileUtil.getProjectPath();
        }
        filePath = basePath + I18N_ESIGHTPACKAGE_FILE;
        if (basePath == null) {
            String languageFile = System.getProperty("user.dir");
            if ((languageFile = Normalizer.normalize(languageFile, Normalizer.Form.NFKC)).contains("elogcollector") && !languageFile.contains("uninstall")) {
                String languagePath = languageFile.substring(0, System.getProperty("user.dir").lastIndexOf("\\"));
                filePath = languagePath + "/" + I18N_ESIGHTPACKAGE_FILE;
            } else {
                filePath = I18N_ESIGHTPACKAGE_FILE;
            }
        }
        if (null != (files = (dir = new File(filePath)).listFiles()) && files.length > 0) {
            HashMap<String, String> enMap = new HashMap<String, String>();
            HashMap<String, String> cnMap = new HashMap<String, String>();
            for (File file : files) {
                String value;
                String key;
                Set<Map.Entry<Object, Object>> entrSet;
                if (file.getName().contains(CN_FILE)) {
                    PropertyUtil cnProperties = new PropertyUtil(file);
                    Properties cnpro = cnProperties.getProp();
                    entrSet = cnpro.entrySet();
                    for (Map.Entry<Object, Object> entry : entrSet) {
                        key = (String)entry.getKey();
                        value = (String)entry.getValue();
                        cnMap.put(key, value);
                    }
                    continue;
                }
                if (!file.getName().contains(EN_FILE)) continue;
                PropertyUtil enProperties = new PropertyUtil(file);
                Properties enpro = enProperties.getProp();
                entrSet = enpro.entrySet();
                for (Map.Entry<Object, Object> entry : entrSet) {
                    key = (String)entry.getKey();
                    value = (String)entry.getValue();
                    enMap.put(key, value);
                }
            }
            PACKAGE_RES_POOL.put(Locale.CHINESE, cnMap);
            PACKAGE_RES_POOL.put(Locale.ENGLISH, enMap);
        }
    }

    public static synchronized void registerLaugFile() {
        String filePath = null;
        String basePath = EnvirmentProps.getInstance().getBasePath();
        filePath = basePath + I18N_FILE;
        if (basePath == null) {
            String languageFile = System.getProperty("user.dir");
            if ((languageFile = Normalizer.normalize(languageFile, Normalizer.Form.NFKC)).contains("collector") && !languageFile.contains("uninstall")) {
                String languagePath = languageFile.substring(0, System.getProperty("user.dir").lastIndexOf("\\"));
                filePath = languagePath + "/" + I18N_FILE;
            } else {
                filePath = I18N_FILE;
            }
        }
        File dir = new File(filePath);
        File[] files = dir.listFiles();
        HashMap<String, String> enMap = new HashMap<String, String>();
        HashMap<String, String> cnMap = new HashMap<String, String>();
        if (null != files && files.length > 0) {
            for (File file : files) {
                String value;
                String key;
                Set<Map.Entry<Object, Object>> entrSet;
                if (file.getName().contains(CN_FILE)) {
                    PropertyUtil cnProperties = new PropertyUtil(file);
                    Properties cnpro = cnProperties.getProp();
                    entrSet = cnpro.entrySet();
                    for (Map.Entry<Object, Object> entry : entrSet) {
                        key = (String)entry.getKey();
                        value = (String)entry.getValue();
                        cnMap.put(key, value);
                    }
                    continue;
                }
                if (!file.getName().contains(EN_FILE)) continue;
                PropertyUtil enProperties = new PropertyUtil(file);
                Properties enpro = enProperties.getProp();
                entrSet = enpro.entrySet();
                for (Map.Entry<Object, Object> entry : entrSet) {
                    key = (String)entry.getKey();
                    value = (String)entry.getValue();
                    enMap.put(key, value);
                }
            }
        }
        LAUG_POOL.put(Locale.CHINESE, cnMap);
        LAUG_POOL.put(Locale.ENGLISH, enMap);
    }

    public static String getString(String key, String param) {
        String[] params = new String[]{param};
        return ResourceManager.getString(key, params);
    }

    public static String getString(String key) {
        Map<String, String> pro;
        String value;
        Locale locale = resourceLocale;
        if (!Locale.CHINESE.equals(locale)) {
            locale = Locale.ENGLISH;
        }
        if (StringUtils.isEmpty((CharSequence)(value = (pro = LAUG_POOL.get(locale)).get(key)))) {
            LOGGER.warn("retrieve resource of key[{}], the return value is empty.", (Object)key);
            return "";
        }
        return value;
    }

    public static String getResString(String key) {
        Map<String, String> pro;
        String value;
        Locale locale = resourceLocale;
        if (!Locale.CHINESE.equals(locale)) {
            locale = Locale.ENGLISH;
        }
        if (StringUtils.isEmpty((CharSequence)(value = (pro = PACKAGE_RES_POOL.get(locale)).get(key)))) {
            LOGGER.warn("retrieve resource of key[{}], the return value is empty.", (Object)key);
            return "";
        }
        return value;
    }

    public static String getString(String key, String[] params) {
        String value = ResourceManager.getString(key);
        int count = 0;
        for (String param : params) {
            if (null == param) continue;
            String location = "{" + count++ + "}";
            if (null != value) {
                value = value.replace(location, param);
                continue;
            }
            LOGGER.warn("retrieve resource of key[{}], the return value is empty.", (Object)key);
        }
        return value;
    }

    public static Image getImage(String imageName, Locale locale) {
        Image image = null;
        String imagefilename1 = null;
        String imagefilename2 = null;
        if (null != locale) {
            imagefilename1 = IMAGES_PATH_PREFIX + imageName + "_" + locale.toString() + ".gif";
            imagefilename2 = IMAGES_PATH_PREFIX + imageName + "_" + locale.toString() + ".png";
        } else {
            imagefilename1 = IMAGES_PATH_PREFIX + imageName + ".gif";
            imagefilename2 = IMAGES_PATH_PREFIX + imageName + ".png";
        }
        if (new File(imagefilename1).exists()) {
            image = Toolkit.getDefaultToolkit().createImage(imagefilename1);
        } else if (new File(imagefilename2).exists()) {
            image = Toolkit.getDefaultToolkit().createImage(imagefilename2);
        }
        if (null == image) {
            if (null != locale) {
                imagefilename1 = BASE_PATH + IMAGES_PATH_PREFIX + imageName + "_" + locale.toString() + ".gif";
                imagefilename2 = BASE_PATH + IMAGES_PATH_PREFIX + imageName + "_" + locale.toString() + ".png";
            } else {
                imagefilename1 = BASE_PATH + IMAGES_PATH_PREFIX + imageName + ".gif";
                imagefilename2 = BASE_PATH + IMAGES_PATH_PREFIX + imageName + ".png";
            }
            if (new File(imagefilename1).exists()) {
                image = Toolkit.getDefaultToolkit().createImage(imagefilename1);
            } else if (new File(imagefilename2).exists()) {
                image = Toolkit.getDefaultToolkit().createImage(imagefilename2);
            }
        }
        return image;
    }

    public static Image getImage(String imageName) {
        Image image = null;
        String imagefilename1 = null;
        String imagefilename2 = null;
        imagefilename1 = IMAGES_PATH_PREFIX + imageName + ".gif";
        imagefilename2 = IMAGES_PATH_PREFIX + imageName + ".png";
        if (new File(imagefilename1).exists()) {
            image = Toolkit.getDefaultToolkit().createImage(imagefilename1);
        } else if (new File(imagefilename2).exists()) {
            image = Toolkit.getDefaultToolkit().createImage(imagefilename2);
        }
        if (null == image) {
            imagefilename1 = BASE_PATH + IMAGES_PATH_PREFIX + imageName + ".gif";
            imagefilename2 = BASE_PATH + IMAGES_PATH_PREFIX + imageName + ".png";
            if (new File(imagefilename1).exists()) {
                image = Toolkit.getDefaultToolkit().createImage(imagefilename1);
            } else if (new File(imagefilename2).exists()) {
                image = Toolkit.getDefaultToolkit().createImage(imagefilename2);
            }
        }
        return image;
    }

    public static ImageIcon getIcon(String iconName, Locale locale) {
        ImageIcon imageIcon = null;
        String iconfilename1 = null;
        String iconfilename2 = null;
        if (null != locale) {
            iconfilename1 = IMAGES_PATH_PREFIX + iconName + "_" + locale.toString() + ".gif";
            iconfilename2 = IMAGES_PATH_PREFIX + iconName + "_" + locale.toString() + ".png";
        } else {
            iconfilename1 = IMAGES_PATH_PREFIX + iconName + ".gif";
            iconfilename2 = IMAGES_PATH_PREFIX + iconName + ".png";
        }
        if (new File(iconfilename1).exists()) {
            imageIcon = new ImageIcon(iconfilename1);
        } else if (new File(iconfilename2).exists()) {
            imageIcon = new ImageIcon(iconfilename2);
        }
        if (null == imageIcon) {
            if (null != locale) {
                iconfilename1 = BASE_PATH + IMAGES_PATH_PREFIX + iconName + "_" + locale.toString() + ".gif";
                iconfilename2 = BASE_PATH + IMAGES_PATH_PREFIX + iconName + "_" + locale.toString() + ".png";
            } else {
                iconfilename1 = BASE_PATH + IMAGES_PATH_PREFIX + iconName + ".gif";
                iconfilename2 = BASE_PATH + IMAGES_PATH_PREFIX + iconName + ".png";
            }
            if (new File(iconfilename1).exists()) {
                imageIcon = new ImageIcon(iconfilename1);
            } else if (new File(iconfilename2).exists()) {
                imageIcon = new ImageIcon(iconfilename2);
            }
        }
        return imageIcon;
    }

    public static ImageIcon getIcon(String iconName) {
        ImageIcon imageIcon = null;
        String iconfilename1 = null;
        String iconfilename2 = null;
        iconfilename1 = IMAGES_PATH_PREFIX + iconName + ".gif";
        iconfilename2 = IMAGES_PATH_PREFIX + iconName + ".png";
        if (new File(iconfilename1).exists()) {
            imageIcon = new ImageIcon(iconfilename1);
        } else if (new File(iconfilename2).exists()) {
            imageIcon = new ImageIcon(iconfilename2);
        }
        if (null == imageIcon) {
            iconfilename1 = BASE_PATH + IMAGES_PATH_PREFIX + iconName + ".gif";
            iconfilename2 = BASE_PATH + IMAGES_PATH_PREFIX + iconName + ".png";
            if (new File(iconfilename1).exists()) {
                imageIcon = new ImageIcon(iconfilename1);
            } else if (new File(iconfilename2).exists()) {
                imageIcon = new ImageIcon(iconfilename2);
            }
        }
        return imageIcon;
    }

    public static Locale getLocale() {
        return resourceLocale;
    }

    public static void setLocale(Locale locale) {
        resourceLocale = locale;
    }

    public static void addI18NMap(Map<Locale, Map<String, String>> i18nMap) {
        for (Map.Entry<Locale, Map<String, String>> enrty : i18nMap.entrySet()) {
            Map<String, String> m;
            Locale locale = enrty.getKey();
            Map<String, String> map = enrty.getValue();
            if (locale.toString().indexOf("zh") > -1) {
                if (LAUG_POOL.containsKey(Locale.CHINESE)) {
                    m = LAUG_POOL.get(Locale.CHINESE);
                    m.putAll(map);
                    continue;
                }
                LAUG_POOL.put(Locale.CHINESE, map);
                continue;
            }
            if (locale.toString().indexOf("en") > -1) {
                if (LAUG_POOL.containsKey(Locale.ENGLISH)) {
                    m = LAUG_POOL.get(Locale.ENGLISH);
                    m.putAll(map);
                    continue;
                }
                LAUG_POOL.put(Locale.ENGLISH, map);
                continue;
            }
            LOGGER.error("addI18NMap occurs error, not matched i18n file name\uff1a{} ", (Object)locale);
        }
    }

    private static void init() {
        if (resourceLocale == null) {
            String lang = ContextUtil.getStrValueFromCtx("install.lang");
            if (null == lang) {
                Locale osDefaultLocale = Locale.getDefault();
                LOGGER.debug("install.lang is null , and get osDefaultLocale: " + osDefaultLocale, (Object)"init");
                resourceLocale = osDefaultLocale == Locale.CHINA || osDefaultLocale == Locale.CHINESE ? Locale.CHINESE : Locale.ENGLISH;
            } else {
                resourceLocale = lang.contains("zh") ? Locale.CHINESE : Locale.ENGLISH;
            }
            LOGGER.debug("resourceLocale: " + resourceLocale, (Object)"init");
        }
        try {
            ResourceManager.registerLaugFile();
            ResourceManager.registerResFile();
        }
        catch (Exception e) {
            LOGGER.error("init resource manger occurs error.", (Throwable)e);
        }
    }

    static {
        ResourceManager.init();
    }
}

