/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.base.exception.AccessException;
import com.huawei.elog.common.StreamProcUtil;
import com.huawei.elog.util.FileUtil;
import com.huawei.elog.util.ProgramUtil;
import com.huawei.elog.util.thread.ThreadUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.Normalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ServiceUtil {
    public static final String STATE_COLUME = "STATE";
    public static final String STATE_RUNNING_STR = "RUNNING";
    public static final String START_STATUS = "START_TYPE";
    public static final String STATUS_DISABLED = "DISABLED";
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceUtil.class);

    private ServiceUtil() {
    }

    public static boolean deleteService(String service) {
        if (ServiceUtil.isServiceAccessible(service)) {
            while (ServiceUtil.isServiceRunning(service)) {
                ProgramUtil.execCommand("cmd /c sc stop " + service);
                ThreadUtil.sleep(1000L);
            }
            ProgramUtil.execCommand("cmd /c sc delete " + service);
            return !ServiceUtil.isServiceExist(service);
        }
        LOGGER.debug("Current user insufficient permissions", (Object)"clearServiceInstalled");
        throw new AccessException("Current user insufficient permissions");
    }

    public static boolean isServiceExist(String serviceName) {
        return !ServiceUtil.isServiceNotExist(serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isServiceNotExist(String serviceName) {
        boolean notExist;
        block8: {
            notExist = false;
            StringBuffer command = new StringBuffer();
            if (!ServiceUtil.validateCmd(serviceName)) {
                LOGGER.error("isServiceRunning error, serviceName is invalid.");
                return false;
            }
            command.append("cmd /c sc query ").append(serviceName).append(" | findstr \"").append("OpenService").append('\"').append(" | findstr \"").append("1060:").append('\"');
            Runtime runtime = Runtime.getRuntime();
            Process process = null;
            InputStream inS = null;
            InputStreamReader inR = null;
            BufferedReader buffR = null;
            try {
                process = runtime.exec(command.toString());
                inS = process.getInputStream();
                inR = new InputStreamReader(inS, "UTF-8");
                buffR = new BufferedReader(inR);
                String lineString = null;
                while (null != (lineString = buffR.readLine())) {
                    LOGGER.debug(lineString, (Object)"isServiceNotExist");
                    if (!lineString.contains("OpenService")) continue;
                    notExist = true;
                    break;
                }
                StreamProcUtil.close(buffR);
            }
            catch (RuntimeException e) {
                throw e;
                catch (Exception e2) {
                    LOGGER.error("isServiceExist", (Throwable)e2);
                    break block8;
                }
            }
            StreamProcUtil.close(inR);
            StreamProcUtil.close(inS);
            break block8;
            finally {
                StreamProcUtil.close(buffR);
                StreamProcUtil.close(inR);
                StreamProcUtil.close(inS);
            }
        }
        LOGGER.debug("System service of " + serviceName + " exist or not: " + !notExist, (Object)"isServiceExist");
        return notExist;
    }

    public static boolean isServiceDataInitialize(String datadir) {
        File dir = new File(datadir + "mysql");
        if (!dir.exists()) {
            return false;
        }
        File[] subDirs = dir.listFiles((dir1, name) -> name.equals("user.MYI") || name.equals("user.MYD") || name.equals("user.frm"));
        LOGGER.info("isServiceDataInitialize : " + subDirs);
        return null != subDirs && subDirs.length == 3;
    }

    public static void mysqlDataDirClear(String datadir) {
        File dir = new File(datadir);
        if (!dir.exists()) {
            return;
        }
        FileUtil.deleteAllFilesInFolder(dir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServiceRunning(String serviceName) {
        boolean isRunning = false;
        String command = "cmd /c sc query " + serviceName;
        if (!ServiceUtil.validateCmd(command)) {
            LOGGER.error("isServiceRunning error, command is invalid.");
            return isRunning;
        }
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(command);
        }
        catch (IOException e) {
            LOGGER.error("check service running status has error happened. command: ", (Throwable)e);
        }
        if (null == process) {
            return false;
        }
        InputStream inStream = process.getInputStream();
        InputStreamReader inStreamReader = null;
        BufferedReader bufReader = null;
        String listeningCmdLine = null;
        try {
            inStreamReader = new InputStreamReader(inStream, "UTF-8");
            bufReader = new BufferedReader(inStreamReader);
            while (null != (listeningCmdLine = bufReader.readLine())) {
                if (!listeningCmdLine.contains(STATE_COLUME) || !listeningCmdLine.contains(STATE_RUNNING_STR)) continue;
                LOGGER.info("get running status source cmd succeed.", (Object)"isServiceRunning");
                isRunning = true;
            }
        }
        catch (IOException e) {
            LOGGER.error("GetStatus has error happened. command: ", (Throwable)e);
        }
        finally {
            try {
                if (bufReader != null) {
                    bufReader.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("isServiceRunning", (Throwable)e);
            }
            try {
                if (inStreamReader != null) {
                    inStreamReader.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("isServiceRunning", (Throwable)e);
            }
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("isServiceRunning", (Throwable)e);
                }
            }
            process.destroy();
        }
        LOGGER.info("Service of " + serviceName + " running state: " + isRunning, (Object)"isServiceRunning");
        return isRunning;
    }

    private static boolean validateCmd(String arg) {
        String[] badInput = new String[]{"&&", "&", "||", "|", ";", "$", ">", ">>", "<"};
        arg = Normalizer.normalize(arg, Normalizer.Form.NFKC);
        for (String bad : badInput) {
            if (!arg.contains(bad)) continue;
            return false;
        }
        return true;
    }

    public static boolean isServiceNotRunning(String serviceName) {
        return !ServiceUtil.isServiceRunning(serviceName);
    }

    public static boolean isServiceEnable(String serviceName) {
        return !ServiceUtil.isServiceDisabled(serviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServiceDisabled(String serviceName) {
        boolean disabled = false;
        StringBuffer command = new StringBuffer();
        if (!ServiceUtil.validateCmd(serviceName)) {
            LOGGER.error("isServiceDisabled error, serviceName is invalid.");
            return false;
        }
        command.append("cmd /c sc qc " + serviceName);
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(command.toString());
        }
        catch (IOException e) {
            LOGGER.error("getStatuString has error happened. command: ", (Throwable)e);
        }
        if (null != process) {
            InputStream inStream = process.getInputStream();
            InputStreamReader inStreamReader = null;
            BufferedReader bufReader = null;
            String listeningCmdLine = null;
            try {
                inStreamReader = new InputStreamReader(inStream, "UTF-8");
                bufReader = new BufferedReader(inStreamReader);
                while (null != (listeningCmdLine = bufReader.readLine())) {
                    if (!listeningCmdLine.contains(START_STATUS) || !listeningCmdLine.contains(STATUS_DISABLED)) continue;
                    disabled = true;
                    LOGGER.info("getStatuString is true", (Object)"getStatuString");
                }
            }
            catch (IOException e) {
                LOGGER.error("GetStatus has error happened. command: ", (Throwable)e);
            }
            finally {
                try {
                    if (bufReader != null) {
                        bufReader.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error("isServiceDisabled", (Throwable)e);
                }
                try {
                    if (inStreamReader != null) {
                        inStreamReader.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error("isServiceDisabled", (Throwable)e);
                }
                if (null != inStream) {
                    try {
                        inStream.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("isServiceDisabled", (Throwable)e);
                    }
                }
                process.destroy();
            }
        }
        return disabled;
    }

    public static boolean isServiceAccessible(String cmd) {
        return !ServiceUtil.isServiceNotAccessible(cmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServiceNotAccessible(String service) {
        boolean isNotAccessible = false;
        if (!ServiceUtil.validateCmd(service)) {
            LOGGER.error("isServiceNotAccessible error, service is invalid.");
            return false;
        }
        StringBuilder command = new StringBuilder();
        command.append("cmd /c sc query ").append(service).append(" | findstr \"").append("OpenService").append('\"').append(" | findstr \"").append("5:").append('\"');
        Runtime runtime = Runtime.getRuntime();
        BufferedReader bufReader = null;
        InputStreamReader inStreamReader = null;
        InputStream inStream = null;
        Process process = null;
        try {
            String listeningCmdLine;
            process = runtime.exec(command.toString());
            inStream = process.getInputStream();
            inStreamReader = new InputStreamReader(inStream, "UTF-8");
            bufReader = new BufferedReader(inStreamReader);
            while (null != (listeningCmdLine = bufReader.readLine())) {
                if (!(listeningCmdLine = Normalizer.normalize(listeningCmdLine, Normalizer.Form.NFKC)).startsWith("OpenService")) continue;
                LOGGER.info("===" + listeningCmdLine + "===", (Object)"checkAccess");
                isNotAccessible = true;
            }
        }
        catch (IOException e) {
            LOGGER.error("checkAccess", (Throwable)e);
        }
        finally {
            if (null != bufReader) {
                try {
                    bufReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("checkAccess", (Throwable)e);
                }
            }
            if (null != inStreamReader) {
                try {
                    inStreamReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("checkAccess", (Throwable)e);
                }
            }
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("checkAccess", (Throwable)e);
                }
            }
            if (null != process) {
                process.destroy();
            }
        }
        return isNotAccessible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getServiceBinayPath(String serviceName) {
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        InputStream inStream = null;
        InputStreamReader inStreamReader = null;
        BufferedReader bufReader = null;
        String path = null;
        if (!ServiceUtil.validateCmd(serviceName)) {
            LOGGER.error("getServiceBinayPath error, serviceName is invalid.");
            return null;
        }
        try {
            String tempPath;
            String normalizeOsName = Normalizer.normalize(System.getProperty("os.name"), Normalizer.Form.NFKC);
            if (!normalizeOsName.contains("Windows")) {
                LOGGER.error("getServiceBinayPath in linux is undo", (Object)"getServiceBinayPath");
                String string = "";
                return string;
            }
            process = runtime.exec("cmd /c sc qc " + serviceName);
            inStream = process.getInputStream();
            inStreamReader = new InputStreamReader(inStream, "UTF-8");
            bufReader = new BufferedReader(inStreamReader);
            while (null != (tempPath = bufReader.readLine())) {
                String normalizeTempPath = Normalizer.normalize(tempPath, Normalizer.Form.NFKC);
                if (!normalizeTempPath.trim().startsWith("BINARY_PATH_NAME")) continue;
                normalizeTempPath = normalizeTempPath.substring(normalizeTempPath.indexOf(":") + 1, normalizeTempPath.indexOf("--")).trim();
                path = normalizeTempPath = normalizeTempPath.substring(0, normalizeTempPath.length() - 17);
                break;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("getServiceBinayPath", (Throwable)e);
        }
        finally {
            if (null != bufReader) {
                try {
                    bufReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("getServiceBinayPath", (Throwable)e);
                }
            }
            if (null != inStreamReader) {
                try {
                    inStreamReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("getServiceBinayPath", (Throwable)e);
                }
            }
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("getServiceBinayPath", (Throwable)e);
                }
            }
            if (null != process) {
                process.destroy();
            }
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isLinuxServiceRunning(String serviceName) {
        boolean isRunning = false;
        InputStreamReader inputStreamReader = null;
        if (!ServiceUtil.validateCmd(serviceName)) {
            LOGGER.error("isLinuxServiceRunning error, serviceName is invalid.");
            return false;
        }
        BufferedReader bfReader = null;
        try {
            String[] cmds = new String[]{"/bin/sh", "-c", "ps -ef | grep " + serviceName + " | grep -v grep"};
            Process process = Runtime.getRuntime().exec(cmds);
            inputStreamReader = new InputStreamReader(process.getInputStream(), "utf-8");
            bfReader = new BufferedReader(inputStreamReader);
            String lineString = bfReader.readLine();
            while (lineString != null) {
                isRunning = true;
                lineString = bfReader.readLine();
            }
            return isRunning;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Exception occurs when obtaining service status ", (Throwable)e);
            return isRunning;
        }
        finally {
            if (bfReader != null) {
                try {
                    bfReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("Exception occurs when obtaining service status ", (Throwable)e);
                }
                finally {
                    if (inputStreamReader != null) {
                        try {
                            inputStreamReader.close();
                        }
                        catch (IOException e) {
                            LOGGER.error("Exception occurs when obtaining service status ", (Throwable)e);
                        }
                    }
                }
            }
        }
    }
}

