/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.base.exception.AccessException;
import com.huawei.elog.base.exception.StartException;
import com.huawei.elog.util.EnvUtil;
import com.huawei.elog.util.FileUtil;
import com.huawei.elog.util.ProUtil;
import com.huawei.elog.util.ProgramUtil;
import com.huawei.elog.util.PropertyManager;
import com.huawei.elog.util.ServiceUtil;
import com.huawei.elog.util.thread.ThreadUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.text.Normalizer;
import java.util.List;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StartsvcUtil {
    public static final int OVER_TIME = 120;
    public static final String SVC_COLLECTOR_NAME = "DDOSCOLLECTORSVC";
    public static final String SVC_WMI_NAME = PropertyManager.getProValue("COLLECTOR.ELOG.WMISERVER.SERVICENAME");
    public static final String SVC_SFTP_NAME = PropertyManager.getProValue("COLLECTOR.SFTP.SERVICENAME");
    public static final String SVC_JDBC_NAME = PropertyManager.getProValue("COLLECTOR.JDBC.SERVICENAME");
    public static final String SVC_INDEXSERVER_NAME = "IndexServer";
    public static final String SVC_INDEXDATASERVER_NAME = "IndexDataServer";
    public static final String SVC_MONITOR_NAME = "ATICCOLLECTORGUARDSERVICE";
    private static final Logger LOGGER = LoggerFactory.getLogger(StartsvcUtil.class);
    private static final int SLEEP_TIME = 1000;

    public static void startService(String svcName) {
        LOGGER.info("===start service {}......===" + svcName);
        StartsvcUtil.checkAccess("cmd /c sc start " + svcName);
        if (ServiceUtil.isServiceNotRunning(svcName)) {
            ProgramUtil.execCommand("cmd /c sc start " + svcName);
            int i = 0;
            while (ServiceUtil.isServiceNotRunning(svcName)) {
                if (i % 2 == 0) {
                    ProgramUtil.execCommand("cmd /c sc start " + svcName);
                }
                ThreadUtil.sleep(1000L);
                if (i == 120) {
                    throw new StartException(StartsvcUtil.chooseCode(svcName));
                }
                LOGGER.debug("i: {}", (Object)(++i));
            }
            LOGGER.info("==={} start succ===", (Object)svcName);
        } else {
            LOGGER.info("==={} is started.===", (Object)svcName);
        }
    }

    public static void stopService(String svcName) {
        LOGGER.info("===stop service {}......===", (Object)svcName);
        StartsvcUtil.checkAccess("cmd /c sc stop " + svcName);
        if (ServiceUtil.isServiceRunning(svcName)) {
            ProgramUtil.execCommand("cmd /c sc stop " + svcName);
            int i = 0;
            while (ServiceUtil.isServiceRunning(svcName)) {
                if (i % 2 == 0) {
                    ProgramUtil.execCommand("cmd /c sc stop " + svcName);
                }
                ThreadUtil.sleep(1000L);
                if (i == 120) {
                    throw new StartException(StartsvcUtil.chooseCode(svcName));
                }
                ++i;
            }
            LOGGER.info("==={} stop succ===", (Object)svcName);
        } else {
            LOGGER.info("==={} is stoped.===", (Object)svcName);
        }
    }

    public static void stopProsvc() {
        LOGGER.info("###ShutDown Product service start...###", (Object)"stopProsvc");
        String elogCollectorName = PropertyManager.getProValue("COLLECTOR.ELOG.ELOGSERVER.SERVICENAME");
        List<String> services = ProUtil.getProductServices();
        for (String cmd : services) {
            String commandShutDownOsgi;
            if (cmd.equals(elogCollectorName)) {
                StartsvcUtil.stopElogCollector();
            } else if (cmd.equals("eLogSFTP")) {
                commandShutDownOsgi = "cmd /c sc stop " + cmd;
                ProgramUtil.execCommand(commandShutDownOsgi);
                ThreadUtil.sleep(10L);
            } else if (cmd.equals(SVC_INDEXSERVER_NAME)) {
                if (StartsvcUtil.isIndexServerEnabled()) {
                    if (ServiceUtil.isServiceRunning(SVC_INDEXDATASERVER_NAME)) {
                        commandShutDownOsgi = "cmd /c sc stop IndexDataServer";
                        ProgramUtil.execCommand(commandShutDownOsgi);
                        ThreadUtil.sleep(10L);
                    }
                    commandShutDownOsgi = "cmd /c sc stop " + cmd;
                    ProgramUtil.execCommand(commandShutDownOsgi);
                    ThreadUtil.sleep(10L);
                }
            } else if (cmd.equals(SVC_INDEXDATASERVER_NAME)) {
                if (StartsvcUtil.isIndexServerEnabled()) {
                    commandShutDownOsgi = "cmd /c sc stop " + cmd;
                    ProgramUtil.execCommand(commandShutDownOsgi);
                    ThreadUtil.sleep(10L);
                }
            } else if (ServiceUtil.isServiceRunning(cmd)) {
                commandShutDownOsgi = "cmd /c sc stop " + cmd;
                ProgramUtil.execCommand(commandShutDownOsgi);
                ThreadUtil.sleep(10L);
            }
            LOGGER.info("#ShutDown " + cmd + "service succes.##", (Object)"stopProsvc");
        }
        LOGGER.info("###ShutDown Product service end...###", (Object)"stopProsvc");
    }

    public static void stopElogCollector() {
        int i;
        String elogCollectorName = PropertyManager.getProValue("COLLECTOR.ELOG.ELOGSERVER.SERVICENAME");
        String elogWmiName = PropertyManager.getProValue("COLLECTOR.ELOG.WMISERVER.SERVICENAME");
        ProgramUtil.execCommand("cmd /c sc stop " + elogWmiName);
        for (i = 0; ServiceUtil.isServiceRunning(elogWmiName) && i < 120; ++i) {
            ThreadUtil.sleep(1000L);
        }
        for (i = 0; ServiceUtil.isServiceRunning(elogCollectorName) && i < 120; ++i) {
            ProgramUtil.execCommand("cmd /c sc stop " + elogCollectorName);
            ThreadUtil.sleep(1000L);
        }
    }

    public static long chooseCode(String svcName) {
        long code = 0L;
        String ddosCollectorName = PropertyManager.getProValue("COLLECTOR.DDOS.DDOSSERVER.SERVICENAME");
        String ddosGuardName = PropertyManager.getProValue("COLLECTOR.DDOS.GUARDSERVER.SERVICENAME");
        String elogCollecotName = PropertyManager.getProValue("COLLECTOR.ELOG.ELOGSERVER.SERVICENAME");
        String elogWmiName = PropertyManager.getProValue("COLLECTOR.ELOG.WMISERVER.SERVICENAME");
        String namingName = PropertyManager.getProValue("COLLECTOR.ELOG.NAMINGSERVICE.SERVICENAME");
        String elogName = PropertyManager.getProValue("COLLECTOR.ELOG.ELOGSERVICES.SERVICENAME");
        if (svcName.equals(ddosGuardName)) {
            code = 20001L;
        }
        if (svcName.equals(ddosCollectorName)) {
            code = 20002L;
        }
        if (svcName.equals(elogCollecotName)) {
            code = 20003L;
        }
        if (svcName.equals(elogWmiName)) {
            code = 20004L;
        }
        if (svcName.equals(namingName)) {
            code = 20005L;
        }
        if (svcName.equals(elogName)) {
            code = 20006L;
        }
        LOGGER.info("Product choose code is :  " + svcName + "    " + code, (Object)"chooseCode");
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkAccess(String cmd) {
        Runtime runtime = Runtime.getRuntime();
        BufferedReader bufReader = null;
        InputStreamReader inStreamReader = null;
        InputStream inStream = null;
        Process process = null;
        if (!StartsvcUtil.validateCmd(cmd)) {
            LOGGER.error("isServiceRunning error, serviceName is invalid.");
            try {
                throw new IOException();
            }
            catch (IOException e) {
                LOGGER.error("isServiceRunning error, serviceName is invalid.");
            }
        }
        try {
            String listeningCmdLine;
            String str = "cmd /c chcp 437 && " + cmd + " | findstr \"Access is denied\"";
            process = runtime.exec(str);
            inStream = process.getInputStream();
            inStreamReader = new InputStreamReader(inStream, "UTF-8");
            bufReader = new BufferedReader(inStreamReader);
            while (null != (listeningCmdLine = bufReader.readLine())) {
                if (!(listeningCmdLine = Normalizer.normalize(listeningCmdLine, Normalizer.Form.NFKC)).startsWith("Access is denied")) continue;
                LOGGER.info("The User Insufficient permissions", (Object)"checkAccess");
                throw new AccessException(30001L);
            }
        }
        catch (IOException e) {
            LOGGER.error("checkAccess", (Throwable)e);
        }
        finally {
            if (null != bufReader) {
                try {
                    bufReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("checkAccess", (Throwable)e);
                }
            }
            if (null != inStreamReader) {
                try {
                    inStreamReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("checkAccess", (Throwable)e);
                }
            }
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("checkAccess", (Throwable)e);
                }
            }
            if (null != process) {
                process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkSFTPStatus(String path) {
        File file;
        boolean isOnline = false;
        String pro = "";
        String basePath = "";
        String jarPath = EnvUtil.getEnv("LOGCENTER_ROOT");
        String normalizeOsName = Normalizer.normalize(System.getProperty("os.name"), Normalizer.Form.NFKC);
        if (jarPath.indexOf(":") != -1 && normalizeOsName.contains("Windows")) {
            try {
                jarPath = URLDecoder.decode(jarPath, "UTF-8");
            }
            catch (Exception e) {
                LOGGER.error("checkSStatus", (Throwable)e);
            }
            basePath = jarPath + "/collector/sftpService/etc/sftp.xml";
        }
        if ((file = new File(basePath)).exists()) {
            FileInputStream in = null;
            try {
                String readinString;
                in = new FileInputStream(file);
                byte[] bytes = new byte[200];
                if (in.read(bytes) != -1 && (pro = (readinString = new String(bytes, "UTF-8")).substring(readinString.indexOf("<ONLINE value=") + 15, readinString.indexOf("/>", readinString.indexOf("<ONLINE value=")) - 1)).equals("true")) {
                    isOnline = true;
                }
                in.close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("checkSStatus", (Throwable)e);
            }
            finally {
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("checkSStatus", (Throwable)e);
                    }
                }
            }
        }
        return isOnline;
    }

    public static boolean isIndexServerEnabled() {
        File file;
        boolean isOnline = false;
        String basePath = "";
        String jarPath = EnvUtil.getEnv("LOGCENTER_ROOT");
        String normalizeOsName = Normalizer.normalize(System.getProperty("os.name"), Normalizer.Form.NFKC);
        if (jarPath.indexOf(":") != -1 && normalizeOsName.contains("Windows")) {
            try {
                jarPath = URLDecoder.decode(jarPath, "UTF-8");
            }
            catch (Exception e) {
                LOGGER.error("checkIndexServerStatus", (Throwable)e);
            }
            basePath = jarPath + "/indexserver/etc/indexServer.xml";
        }
        if ((file = new File(basePath)).exists()) {
            Properties pFile = null;
            try {
                pFile = FileUtil.getProportyFromFile(basePath);
            }
            catch (Exception e) {
                return isOnline;
            }
            LOGGER.info(pFile.getProperty("index_start"));
            if ("true".equals(pFile.getProperty("index_start"))) {
                isOnline = true;
            }
        }
        LOGGER.debug("checkIndexServerStatus file path, start: " + isOnline, (Object)"checkIndexServerStatus");
        return isOnline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkJDBCStatus(String path) {
        File file;
        boolean isOnline = false;
        String pro = "";
        String basePath = "";
        String jarPath = EnvUtil.getEnv("LOGCENTER_ROOT");
        String normalizeOsName = Normalizer.normalize(System.getProperty("os.name"), Normalizer.Form.NFKC);
        if (jarPath.indexOf(":") != -1 && normalizeOsName.contains("Windows")) {
            try {
                jarPath = URLDecoder.decode(jarPath, "UTF-8");
            }
            catch (Exception e) {
                LOGGER.error("checkJDBCStatus", (Throwable)e);
            }
            basePath = jarPath + "/collector/jdbcService/etc/jdbc.xml";
        }
        if ((file = new File(basePath)).exists()) {
            FileInputStream in = null;
            try {
                in = new FileInputStream(file);
                byte[] bytes = new byte[200];
                if (in.read(bytes) != -1) {
                    String readinString = new String(bytes, "UTF-8");
                    LOGGER.debug(readinString + " -- " + readinString.indexOf("ONLINE\">"), (Object)"checkJDBCStatus");
                    pro = readinString.substring(readinString.indexOf("ONLINE") + 14, readinString.indexOf("\"/>"));
                    if (pro.equals("true")) {
                        isOnline = true;
                    }
                }
                in.close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                LOGGER.error("checkJDBCStatus", (Throwable)e);
            }
            finally {
                if (null != in) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        LOGGER.error("checkjdbcStatus", (Throwable)e);
                    }
                }
            }
        }
        LOGGER.debug("jdbc file path, isOnline: " + isOnline, (Object)"checkjdbcStatus");
        return isOnline;
    }

    public static boolean validateCmd(String arg) {
        String[] badInput = new String[]{"&&", "&", "||", "|", ";", "$", ">", ">>", "<"};
        arg = Normalizer.normalize(arg, Normalizer.Form.NFKC);
        for (String bad : badInput) {
            if (!arg.contains(bad)) continue;
            return false;
        }
        return true;
    }
}

