/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.base.BaseStyle;
import com.huawei.elog.base.InstallContext;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UIUtil {
    public static final int BUTTON_GAP_SAME_GROUP = 4;
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    private static final Integer[] BUTTON_WIDTH_CHOICES = new Integer[]{60, 70, 80, 90, 100, 110};
    private static Font defaultFont = new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 12);
    private static final Logger LOGGER = LoggerFactory.getLogger(UIUtil.class);

    public static Font getDefaultFont() {
        return defaultFont;
    }

    public static void setSize(JComponent swing, Dimension dim) {
        swing.setPreferredSize(dim);
        swing.setMaximumSize(dim);
        swing.setMinimumSize(dim);
    }

    public static void setUIDefaultFont() {
        UIManager.put("Button.font", defaultFont);
        UIManager.put("ToggleButton.font", defaultFont);
        UIManager.put("RadioButton.font", defaultFont);
        UIManager.put("Label.font", defaultFont);
        UIManager.put("List.font", defaultFont);
        UIManager.put("OptionPane.buttonFont", defaultFont);
        UIManager.put("OptionPane.messageFont", defaultFont);
        UIManager.put("EditorPane.font", defaultFont);
        UIManager.put("TitledBorder.font", defaultFont);
        UIManager.put("Panel.font", defaultFont);
        UIManager.put("TextArea.font", defaultFont);
        UIManager.put("ComboBox.font", defaultFont);
        UIManager.put("CheckBox.font", defaultFont);
        UIManager.put("Panel.font", defaultFont);
        UIManager.put("ProgressBar.font", defaultFont);
        UIManager.put("ScrollPane.font", defaultFont);
        UIManager.put("Viewport", defaultFont);
        UIManager.put("TabbedPane.font", defaultFont);
        UIManager.put("TableHeader.font", defaultFont);
        UIManager.put("TextField.font", defaultFont);
        UIManager.put("PasswordFiled.font", defaultFont);
        UIManager.put("TextArea.font", defaultFont);
        UIManager.put("TextPane.font", defaultFont);
        UIManager.put("EditorPane.font", defaultFont);
        UIManager.put("TitledBorder.font", defaultFont);
        UIManager.put("ToolBar.font", defaultFont);
        UIManager.put("ToolTip.font", defaultFont);
        UIManager.put("Tree.font", defaultFont);
    }

    public static void boxAddComponents(Box box, Component component) {
        Component[] comps;
        if (null == box || null == component) {
            return;
        }
        for (Component comp : comps = box.getComponents()) {
            if (!comp.equals(component)) continue;
            return;
        }
        box.add(component);
    }

    public static void setComboBoxSelected(JComboBox comb, String value) {
        if (null == value || value.trim().isEmpty()) {
            return;
        }
        int size = comb.getItemCount();
        for (int i = 0; i < size; ++i) {
            Object obj = comb.getItemAt(i);
            if (!value.equalsIgnoreCase(String.valueOf(obj))) continue;
            comb.setSelectedIndex(i);
            break;
        }
    }

    public static boolean isComboBoxContained(JComboBox comb, String value) {
        if (null == value || value.trim().isEmpty()) {
            return false;
        }
        int size = comb.getItemCount();
        for (int i = 0; i < size; ++i) {
            Object obj = comb.getItemAt(i);
            if (!value.equalsIgnoreCase(String.valueOf(obj))) continue;
            comb.setSelectedIndex(i);
            return true;
        }
        return false;
    }

    public static boolean addComboBoxItem(JComboBox comb, String value) {
        if (null == value || value.trim().isEmpty()) {
            return false;
        }
        if (UIUtil.isComboBoxContained(comb, value)) {
            return false;
        }
        comb.addItem(value);
        return true;
    }

    public static int[] getScreenSize() {
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension screenSize = kit.getScreenSize();
        int screenWidth = screenSize.width;
        int screenHeight = screenSize.height;
        return new int[]{screenWidth, screenHeight};
    }

    public static Dimension getScreenDimension() {
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension screenSize = kit.getScreenSize();
        return screenSize;
    }

    public static void initProgressBarStyle() {
        UIManager.getDefaults().put("ProgressBarUI", "javax.swing.plaf.metal.MetalProgressBarUI");
        UIManager.getDefaults().put("ProgressBar.selectionForeground", BaseStyle.PROGRESSBAR_UI_SELECTION_FOREGROUND);
    }

    public static JButton createButton(String text, Dimension size) {
        JButton button = new JButton();
        button.setPreferredSize(size);
        button.setMaximumSize(size);
        button.setMinimumSize(size);
        button.setText(text);
        return button;
    }

    public static JButton createButton(String text, char mnemonic) {
        JButton tempButton = new JButton();
        tempButton.setText(text);
        tempButton.setMnemonic(mnemonic);
        Dimension size = UIUtil.computeButtonPreferredSize(tempButton);
        JButton button = UIUtil.createButton(text, size);
        button.setMnemonic(mnemonic);
        return button;
    }

    public static Dimension computeButtonPreferredSize(AbstractButton button) {
        Dimension dimension = button.getPreferredSize();
        Integer[] widthChoices = BUTTON_WIDTH_CHOICES;
        int widthMultiple = 10;
        int height = 21;
        int preferredWidthIndex = UIUtil.findNearest(dimension.width, widthChoices);
        dimension.width = preferredWidthIndex >= 0 ? widthChoices[preferredWidthIndex] : (dimension.width + widthMultiple / 2) / widthMultiple * widthMultiple;
        dimension.height = height;
        return dimension;
    }

    private static Integer findNearest(Integer value, Integer[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (value > array[i]) continue;
            return i;
        }
        return -1;
    }

    public static void hideColumn(JTable table, int index) {
        if (null == table || index < 0) {
            return;
        }
        TableColumn tc = table.getColumnModel().getColumn(index);
        tc.setMaxWidth(0);
        tc.setPreferredWidth(0);
        tc.setWidth(0);
        tc.setMinWidth(0);
        table.getTableHeader().getColumnModel().getColumn(index).setMaxWidth(0);
        table.getTableHeader().getColumnModel().getColumn(index).setMinWidth(0);
    }

    public static List<String> getCheckedTabaleRowsValues(DefaultTableModel model, int colIndex) {
        ArrayList<String> ids = new ArrayList<String>();
        if (null == model) {
            return ids;
        }
        int rowCount = model.getRowCount();
        Object checkBoxObj = null;
        for (int i = 0; i < rowCount; ++i) {
            checkBoxObj = model.getValueAt(i, 0);
            if (checkBoxObj instanceof Boolean) {
                Boolean b = (Boolean)checkBoxObj;
                if (!b.booleanValue()) continue;
                Object idObj = model.getValueAt(i, colIndex);
                ids.add(String.valueOf(idObj));
                continue;
            }
            LOGGER.error("Unkown type : " + checkBoxObj);
        }
        return ids;
    }

    public static boolean isSilentMode() {
        String guiMode = InstallContext.getInstance().getGuiMode();
        return "silent".equals(guiMode);
    }
}

