/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.model.DataBaseInfo;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.ui.window.PreWindows;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.HalfFullCheckUtil;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.WindowUtil;
import com.huawei.elog.util.WindowsGetMem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.text.Normalizer;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ValidateUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ValidateUtil.class);
    private static ValidateUtil instance = null;

    private ValidateUtil() {
    }

    public static synchronized ValidateUtil getInstance() {
        if (instance == null) {
            instance = new ValidateUtil();
        }
        return instance;
    }

    public boolean isValidVersion(String oldId, String newId) {
        boolean newVersion = false;
        String[] oldVersions = oldId.split("\\.");
        String[] newVersions = newId.split("\\.");
        for (int i = 0; i < oldVersions.length; ++i) {
            if (Integer.parseInt(oldVersions[i]) < Integer.parseInt(newVersions[i])) {
                newVersion = true;
                break;
            }
            if (Integer.parseInt(oldVersions[i]) <= Integer.parseInt(newVersions[i])) continue;
            newVersion = false;
            break;
        }
        return newVersion;
    }

    public boolean checkIp(DataBaseInfo dbInfo) {
        if ("Integrated Scene".equals(CommonUtil.getInstallScene())) {
            return true;
        }
        boolean flag0 = false;
        boolean flag1 = false;
        String ip = dbInfo.getDbHost();
        ip = Normalizer.normalize(ip, Normalizer.Form.NFKC);
        Pattern pattern = Pattern.compile("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b");
        Matcher matcher = pattern.matcher(ip);
        flag0 = matcher.matches();
        if (!flag0) {
            return false;
        }
        String[] numbers = ip.replace(".", ";").split(";");
        try {
            int number0 = Integer.parseInt(numbers[0]);
            int number3 = Integer.parseInt(numbers[3]);
            if (number0 >= 1 && number0 <= 223 && number3 >= 1 && number3 <= 255) {
                flag1 = true;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            flag1 = false;
        }
        return flag0 & flag1;
    }

    public boolean checkIp(String ip) {
        boolean flag0 = false;
        boolean flag1 = false;
        ip = Normalizer.normalize(ip, Normalizer.Form.NFKC);
        Pattern pattern = Pattern.compile("\\b((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\.((?!\\d\\d\\d)\\d+|1\\d\\d|2[0-4]\\d|25[0-5])\\b");
        Matcher matcher = pattern.matcher(ip);
        flag0 = matcher.matches();
        if (!flag0) {
            return false;
        }
        String[] numbers = ip.replace(".", ";").split(";");
        try {
            int number0 = Integer.parseInt(numbers[0]);
            int number3 = Integer.parseInt(numbers[3]);
            if (number0 >= 1 && number0 <= 223 && number3 >= 1 && number3 <= 255) {
                flag1 = true;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            flag1 = false;
        }
        return flag0 & flag1;
    }

    public boolean checkLegal(DataBaseInfo dbInfo) {
        boolean legal = true;
        if (dbInfo.getDbHost().trim().length() == 0) {
            OptionPane.showInfoDialog(ResourceManager.getString("LEGO.COMMON.NULL.ERROR", ResourceManager.getString("LEGO.DB.SET.DB.DBSERVER").replace(":", "")));
            return false;
        }
        if (!this.checkIp(dbInfo)) {
            OptionPane.showInfoDialog(ResourceManager.getString("LEGO.DB.SET.SERVERNAME.ERROR"));
            return false;
        }
        if (dbInfo.getDbPort().trim().length() == 0) {
            OptionPane.showInfoDialog(ResourceManager.getString("LEGO.COMMON.NULL.ERROR", ResourceManager.getString("LEGO.DB.SET.DB.PORT").replace(":", "")));
            return false;
        }
        if (dbInfo.getDbUserName().length() == 0) {
            OptionPane.showInfoDialog(ResourceManager.getString("LEGO.DB.SET.USERNAME.ERROR"));
            return false;
        }
        if (dbInfo.getDbNmsUserName().length() == 0) {
            OptionPane.showInfoDialog(ResourceManager.getString("LEGO.DB.SET.USERNAME.ERROR"));
            return false;
        }
        if (!"".equals(dbInfo.getDbUserName()) && null != dbInfo.getDbUserName()) {
            String patternStr = ".*[[\\u4e00-\\u9fa5]\\\\!`~@#$%^&*)(=+|{\\[\\]};:'\",<\u00b7.>/? ]+.*";
            Pattern pattern = Pattern.compile(patternStr);
            String dbUserName = dbInfo.getDbUserName();
            Matcher matcher = pattern.matcher(dbUserName = Normalizer.normalize(dbUserName, Normalizer.Form.NFKC));
            boolean matchFound = matcher.matches();
            if (matchFound) {
                PreWindows.getInstance().setVisible(false);
                OptionPane.showErrorDialog(ResourceManager.getString("VSM.DATABASE.USERNAME.CHECK"));
                return false;
            }
        } else if (HalfFullCheckUtil.isnInvalid4PortFullChar(dbInfo.getDbUserName())) {
            OptionPane.showInfoDialog(ResourceManager.getString("LEGO.DB.SET.USERNAME.ERROR.FULLWIDTH"));
            return false;
        }
        if (dbInfo.getDbPassword().length() == 0 || HalfFullCheckUtil.isnInvalid4PortFullChar(dbInfo.getDbUserName())) {
            OptionPane.showInfoDialog(ResourceManager.getString("LEGO.DB.SET.PASSWORD.ERROR"));
            return false;
        }
        if (Integer.parseInt(dbInfo.getDbPort().trim()) == Integer.parseInt(ContextUtil.getStrValueFromCtx("lego.port.http").trim()) || Integer.parseInt(dbInfo.getDbPort().trim()) == Integer.parseInt(ContextUtil.getStrValueFromCtx("lego.port.https").trim())) {
            String msg = ResourceManager.getString("LEGO.PORT.USED", dbInfo.getDbPort().trim());
            OptionPane.showInfoDialog(msg);
            return false;
        }
        if (!ValidateUtil.isNotUsePort((String)InstallContext.getInstance().getPropertyMap().getProp("lego.base.path").getValue() + "etc/config/conf/vsm_port.txt", dbInfo.getDbPort().trim())) {
            String[] regMgrArray = new String[]{dbInfo.getDbPort().trim(), ContextUtil.getStrValueFromCtx("software.install.name")};
            OptionPane.showInfoDialog(ResourceManager.getString("VSM.CHECK.HTTS.HTTPS.PORT", regMgrArray));
            return false;
        }
        return legal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isNotUsePort(String portFile, String http) {
        String reader = "";
        String port = "";
        BufferedReader br = null;
        InputStreamReader fileReader = null;
        try {
            fileReader = new InputStreamReader((InputStream)new FileInputStream(new File(portFile)), "utf-8");
            br = new BufferedReader(fileReader);
            while ((reader = br.readLine()) != null) {
                port = reader.substring(reader.indexOf("=") + 1);
                if (port.equals(http) && !"".equals(http)) {
                    boolean bl = false;
                    return bl;
                }
                if (!port.equals(http) || "".equals(http)) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("check portfile by port occurs error.", (Throwable)e);
        }
        finally {
            if (null != br) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    LOGGER.error("close io occurs error.", (Throwable)e);
                }
            }
            if (null != fileReader) {
                try {
                    fileReader.close();
                }
                catch (IOException e) {
                    LOGGER.error("close io occurs error.", (Throwable)e);
                }
            }
        }
        return true;
    }

    public boolean checkPathChar(String path) {
        if (null == path || path.trim().length() < 1) {
            return false;
        }
        String[] folderNames = null;
        if (System.getProperty("os.name").contains("Windows")) {
            String unRootPath = path.substring(path.indexOf(":\\") + 2);
            unRootPath = unRootPath.replace("\\", "/");
            folderNames = unRootPath.split("/");
        } else {
            folderNames = path.split("/");
        }
        for (String folder : folderNames) {
            boolean flag1;
            if (folder.length() == 0) continue;
            folder = Normalizer.normalize(folder, Normalizer.Form.NFKC);
            Pattern pattern = Pattern.compile("^[\\u4e00-\\u9fa5\\w-\\s*.]+$");
            Matcher matcher = pattern.matcher(folder);
            boolean flag = matcher.matches();
            boolean bl = flag1 = folder.indexOf("  ") == -1;
            if (flag && flag1) continue;
            return false;
        }
        return true;
    }

    public boolean checkPassComplexity(String username, String password) {
        boolean isMatch = false;
        int count = 0;
        String inputPassword = password;
        StringBuffer sb = new StringBuffer(inputPassword);
        LOGGER.debug("", (Object)"##------inputPassword-----##");
        String descPassword = sb.reverse().toString();
        LOGGER.debug("", (Object)"##------sDbInfor.getDbUserName()-------##");
        LOGGER.debug("", (Object)"##------descPassword-------##");
        if (inputPassword.length() >= 8 && !username.equals(inputPassword) && !username.equals(descPassword) && inputPassword.length() <= 64) {
            String regex4;
            String regex3;
            String regex2;
            String regex1 = ".*[A-Z]+.*";
            isMatch = Pattern.matches(regex1, inputPassword);
            if (isMatch) {
                LOGGER.debug(isMatch + ":::" + count, (Object)"##---------The A-Z  State---------##");
                ++count;
            }
            if (isMatch = Pattern.matches(regex2 = ".*[a-z]+.*", inputPassword)) {
                LOGGER.debug(isMatch + ":::" + count, (Object)"##---------The [a-z]  State---------##");
                ++count;
            }
            if (isMatch = Pattern.matches(regex3 = ".*[0-9]+.*", inputPassword)) {
                LOGGER.debug(isMatch + ":::" + count, (Object)"##---------The [0-9]  State---------##");
                ++count;
            }
            if (isMatch = Pattern.matches(regex4 = "[\\w|=|\\-|_|!|@|#|$|%|*|/|;|^|||:|,|.|+|}|{]*", inputPassword)) {
                LOGGER.debug(isMatch + ":::" + count, (Object)"##---------The [\\w|=|\\-|_|!|@|#|$|%|/|;|*|^|||:|,|.|+|}|{]*  State---------##");
                ++count;
            }
            if (count >= 3) {
                return true;
            }
        }
        return false;
    }

    public boolean checkRegditLocked() {
        boolean isLocked = false;
        Map<String, String> regmap = WindowUtil.readRegPath("HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Policies\\System");
        if (regmap.containsKey("DisableRegistryTools") && Integer.parseInt(regmap.get("DisableRegistryTools")) == 2) {
            isLocked = true;
        }
        return isLocked;
    }

    public boolean checkDigitalFormat() {
        boolean isValid = true;
        long gb = 0x100000L;
        Properties props = System.getProperties();
        String strOS = props.getProperty("os.name");
        DecimalFormat formatter = new DecimalFormat("0.00");
        double totalMemorySize = 0.0;
        if (strOS.contains("Windows")) {
            totalMemorySize = WindowsGetMem.getTotalMemInfo();
        }
        String totoMemory = formatter.format((Object)(totalMemorySize / (double)gb));
        LOGGER.debug("TotoMem=" + totoMemory, (Object)"checkDigitalFormat");
        if (totoMemory.contains(",")) {
            isValid = false;
        }
        return isValid;
    }
}

