/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.ui.OptionPane;
import com.huawei.elog.util.EnvUtil;
import com.huawei.elog.util.ProgramUtil;
import com.huawei.elog.util.PropertyManager;
import com.huawei.elog.util.ResourceManager;
import com.huawei.elog.util.StartsvcUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.Normalizer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WindowUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowUtil.class);

    private WindowUtil() {
    }

    public static boolean testPathValid(CharSequence inputStr, String pathName) {
        if (!WindowUtil.testPathValidBase(inputStr, pathName)) {
            return false;
        }
        inputStr = Normalizer.normalize(inputStr, Normalizer.Form.NFKC);
        String patternStr = "([a-zA-Z])(\\:)((\\\\)((\\w)+?)*?)+?";
        Pattern pattern = Pattern.compile(patternStr, 4);
        Matcher matcher = pattern.matcher(inputStr);
        boolean matchFound = matcher.matches();
        if (!matchFound) {
            OptionPane.showInfoDialog(ResourceManager.getString("VSM.EXTEND.ELOG.MESSAGE.ERRPATH", pathName));
            return false;
        }
        return true;
    }

    public static boolean testPathValidBase(CharSequence inputStr, String pathName) {
        try {
            int j;
            File[] roots = File.listRoots();
            if (null == roots) {
                LOGGER.error("testPathValidBase failed:roots is null.", (Object)"testPathValidBase");
                return false;
            }
            for (j = 0; j < roots.length && inputStr.charAt(0) != roots[j].toString().toCharArray()[0] && inputStr.charAt(0) != roots[j].toString().toLowerCase(Locale.ENGLISH).toCharArray()[0]; ++j) {
            }
            if (j == roots.length) {
                OptionPane.showInfoDialog(ResourceManager.getString("VSM.EXTEND.ELOG.MESSAGE.NODISKPATH", pathName));
                return false;
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("testPathValidBase failed:" + e.getMessage(), (Object)"testPathValidBase");
            return false;
        }
    }

    public static boolean checkSysDrive(String sSavePath) {
        int result;
        String sysDriver = System.getProperty("SystemDrive");
        if (null == sysDriver) {
            sysDriver = System.getProperty("SYSTEMDRIVE");
        }
        LOGGER.debug("sysDriver = " + sysDriver, (Object)"checkSysDrive");
        return !InstallContext.getInstance().getEnvirments().isSystemInstalled() && sysDriver != null && (sSavePath.startsWith(sysDriver.toLowerCase(Locale.ENGLISH)) || sSavePath.startsWith(sysDriver.toUpperCase(Locale.ENGLISH))) && 0 == (result = OptionPane.showWarnConfirmDialog(ResourceManager.getString("COLLECTOR.SYSTEMDRIVER.PATH.CHECK.MESSAGE")));
    }

    public static String getInstallPath() {
        String entEnvRoot = PropertyManager.getProValue("ent.env.root");
        String value = EnvUtil.getEnv(entEnvRoot);
        return value;
    }

    public static String getInstalledLegoInfoFile() {
        String path = WindowUtil.getInstallPath() + File.separator + InstallContext.getInstance().getInstallType() + "Installed.xml";
        return path;
    }

    public static String getInstalledCollectorInfoFile() {
        String path = WindowUtil.getInstallPath() + File.separator + "elogCollectorInstalled.xml";
        return path;
    }

    public static void restartSystem() {
        LOGGER.warn("System will be restarted.", (Object)"restartSystem");
        String restartCmd = " cmd /c shutdown.exe -f -r -t 0";
        ProgramUtil.execCommand(restartCmd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String findType() {
        Runtime runtime = Runtime.getRuntime();
        BufferedReader bufReader = null;
        InputStreamReader inStreamReader = null;
        InputStream inStream = null;
        Process process = null;
        String type = null;
        try {
            String str = "cmd /c systeminfo | findstr \"based\"";
            process = runtime.exec(str);
            inStream = process.getInputStream();
            inStreamReader = new InputStreamReader(inStream, "utf-8");
            bufReader = new BufferedReader(inStreamReader);
            String listeningCmdLine = bufReader.readLine();
            while (null != listeningCmdLine) {
                if (listeningCmdLine.contains("based")) {
                    type = listeningCmdLine.split(":")[1].trim().substring(0, 3);
                    break;
                }
                listeningCmdLine = bufReader.readLine();
            }
            LOGGER.debug(type + "find System's type is:::", (Object)"findType");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error(e + "find System's type Exception", (Object)"findType");
        }
        finally {
            if (null != bufReader) {
                try {
                    bufReader.close();
                }
                catch (IOException e) {
                    LOGGER.error(e + "find System's type IOException", (Object)"findType");
                }
            }
            if (null != inStreamReader) {
                try {
                    inStreamReader.close();
                }
                catch (IOException e) {
                    LOGGER.error(e + "find System's type IOException", (Object)"findType");
                }
            }
            if (null != inStream) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    LOGGER.error(e + "find System's type IOException", (Object)"findType");
                }
            }
            if (null != process) {
                process.destroy();
            }
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> readRegPath(String regPath) {
        Process ps = null;
        BufferedReader ir = null;
        HashMap<String, String> regMap = new HashMap<String, String>();
        if (!StartsvcUtil.validateCmd(regPath)) {
            return null;
        }
        try {
            String line;
            ps = Runtime.getRuntime().exec("reg query \"" + regPath + "\"");
            ps.getOutputStream().close();
            InputStreamReader in = new InputStreamReader(ps.getInputStream(), "UTF-8");
            ir = new BufferedReader(in);
            while ((line = ir.readLine()) != null) {
                String[] reg;
                if (!line.trim().contains("    ") || (reg = line.trim().split("    ")).length != 3) continue;
                String key = reg[0];
                String value = reg[2];
                regMap.put(key, value);
            }
        }
        catch (IOException e) {
            LOGGER.error("readRegPath" + e);
        }
        finally {
            if (ir != null) {
                try {
                    ir.close();
                }
                catch (IOException e) {
                    LOGGER.error("readRegPath" + e);
                }
            }
        }
        return regMap;
    }

    public static boolean writeRegPath(String regPath) {
        boolean result = true;
        if (!StartsvcUtil.validateCmd(regPath)) {
            LOGGER.error("isServiceRunning error, serviceName is invalid.");
            try {
                throw new IOException();
            }
            catch (IOException e) {
                LOGGER.error("isServiceRunning error, serviceName is invalid.");
            }
        }
        try {
            Runtime.getRuntime().exec("REG ADD " + regPath);
        }
        catch (IOException e) {
            result = false;
            LOGGER.error("writeRegPath : " + e);
            return result;
        }
        return result;
    }

    public static boolean removeRegPath(String regPath) {
        boolean result = true;
        if (!StartsvcUtil.validateCmd(regPath)) {
            LOGGER.error("isServiceRunning error, serviceName is invalid.");
            try {
                throw new IOException();
            }
            catch (IOException e) {
                LOGGER.error("isServiceRunning error, serviceName is invalid.");
            }
        }
        try {
            Runtime.getRuntime().exec("REG DELETE " + regPath);
        }
        catch (IOException e) {
            result = false;
            LOGGER.error("removeRegPath : " + e);
        }
        return result;
    }
}

