/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.model.CpuMemoryInfo;
import com.huawei.elog.base.sdk.IInstallContext;
import com.huawei.elog.util.MonitorCpuInfo;
import com.huawei.elog.util.StartsvcUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WindowsGetMem {
    private static final String MEM_TOTALMEM = " TOTALMEM";
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowsGetMem.class);
    private static IInstallContext installConext = InstallContext.getInstance();
    private static final String TOOLS_PATH = '\"' + installConext.getEnvirments().getBasePath() + "Runtime/LegoRuntime/tools/Resource.exe" + '\"';
    private static MonitorCpuInfo monitorCpuInfo = new MonitorCpuInfo();
    private static CpuMemoryInfo cpuMemoryInfo = monitorCpuInfo.getMonitorInfoBean();

    private WindowsGetMem() {
    }

    public static long getTotalMemInfo() {
        return WindowsGetMem.getCPUAndMenInfo(TOOLS_PATH, MEM_TOTALMEM) != 0L ? WindowsGetMem.getCPUAndMenInfo(TOOLS_PATH, MEM_TOTALMEM) : cpuMemoryInfo.getTotalMemorySize();
    }

    public static long getToTalMemory() {
        return WindowsGetMem.getCPUAndMenInfo(TOOLS_PATH, MEM_TOTALMEM) != 0L ? WindowsGetMem.getCPUAndMenInfo(TOOLS_PATH, MEM_TOTALMEM) : cpuMemoryInfo.getTotalMemorySize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getCPUAndMenInfo(String toolPath, String para) {
        para = (toolPath = toolPath.replace("\\/", "/").replace(" ", "\" \"")) + para;
        if (!StartsvcUtil.validateCmd(para)) {
            LOGGER.error("isServiceRunning error, serviceName is invalid.");
            try {
                throw new IOException();
            }
            catch (IOException e) {
                LOGGER.error("isServiceRunning error, serviceName is invalid.");
            }
        }
        long result = 1L;
        Process pp = null;
        BufferedReader input = null;
        try {
            pp = Runtime.getRuntime().exec("cmd /c " + para);
            InputStreamReader ir = new InputStreamReader(pp.getInputStream(), "utf-8");
            input = new LineNumberReader(ir);
            String nextStr = ((LineNumberReader)input).readLine();
            if (nextStr != null) {
                result = Long.parseLong(nextStr);
            }
        }
        catch (IOException e) {
            LOGGER.error("get cup and memory info occurs error.", (Throwable)e);
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    LOGGER.error("close io occurs error.", (Throwable)e);
                }
            }
            if (null != pp) {
                pp.destroy();
            }
        }
        LOGGER.info("excute result: {}", (Object)result);
        return result;
    }
}

