/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util.combinateconf;

import com.huawei.elog.common.StreamProcUtil;
import com.huawei.elog.util.combinateconf.PropUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileUtil {
    private static final int NUM_2048 = 2048;
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtil.class);

    public static void listJarFilesList(List<JarFile> fileList, String filePath) {
        String fs = FileUtil.getFileSeparator();
        File path = new File(filePath);
        String[] fileNames = path.list();
        String pollingConfFileName = PropUtil.getInstance().getValue("polling.conf.file.name");
        if (fileNames != null) {
            LOGGER.debug("listJarFilesList.filePath.fileNames:" + fileNames.length, (Object)"listJarFilesList");
            for (int i = 0; i < fileNames.length; ++i) {
                String pathStr = path.getPath();
                String fileName = fileNames[i];
                if (-1 != fileName.lastIndexOf(".") && !fileName.substring(fileName.lastIndexOf(".")).equals(".jar")) continue;
                try {
                    JarFile currentFile = new JarFile(pathStr + fs + fileName);
                    if (!FileUtil.validIfProductBundle(currentFile, pollingConfFileName)) continue;
                    fileList.add(currentFile);
                    continue;
                }
                catch (IOException e) {
                    LOGGER.error("jar file init occurs error.", (Throwable)e);
                }
            }
        }
    }

    private static boolean validIfProductBundle(JarFile jarFile, String pollingConfFileName) {
        JarEntry entry = jarFile.getJarEntry(pollingConfFileName);
        try {
            if (null == entry || null == jarFile.getInputStream(entry)) {
                jarFile.close();
                return false;
            }
        }
        catch (Exception e) {
            LOGGER.debug("validIfProductBundle faild ,it is not the performance jar", (Object)"validIfProductBundle");
            try {
                jarFile.close();
            }
            catch (IOException ex) {
                LOGGER.error("close io occurs error.", (Throwable)e);
            }
            return false;
        }
        return true;
    }

    public static String getFileSeparator() {
        String fs = System.getProperties().getProperty("file.separator");
        return fs;
    }

    public static boolean createNewDir(String dirPath) {
        String newDirPath;
        File file2;
        int pos = dirPath.lastIndexOf("/");
        if (pos == -1) {
            pos = dirPath.lastIndexOf("\\");
        }
        if (!(file2 = new File(newDirPath = dirPath.substring(0, pos))).exists()) {
            return file2.mkdirs();
        }
        return false;
    }

    public static String convertFilePathToPackage(String preFixPath, String filePath) {
        String newPrefixPath = preFixPath.replace("\\", "/");
        String newFilePath = filePath.replace("\\", "/");
        if (newFilePath.indexOf(newPrefixPath) < 0) {
            LOGGER.debug("input parameters error...", (Object)"validIfProductBundle");
            return "";
        }
        String result = newFilePath.substring(newPrefixPath.length());
        return result;
    }

    public static String getPathFrom(String pathStr) {
        String fs = FileUtil.getFileSeparator();
        String path = "";
        StringBuilder sb = new StringBuilder();
        String[] pathArray = pathStr.split("[.]");
        if (0 == pathArray.length) {
            return null;
        }
        for (String str : pathArray) {
            sb.append(str + fs);
        }
        path = sb.toString();
        path = path.substring(0, path.lastIndexOf(fs));
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String src, String dest) {
        FileInputStream sIn = null;
        FileOutputStream sOut = null;
        try {
            int byteread = 0;
            File oldfile = new File(src);
            if (oldfile.exists()) {
                oldfile.setWritable(true);
                sIn = new FileInputStream(src);
                sOut = new FileOutputStream(dest);
                byte[] buffer = new byte[2048];
                while ((byteread = ((InputStream)sIn).read(buffer)) != -1) {
                    ((OutputStream)sOut).write(buffer, 0, byteread);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("input parameters error..." + e, (Object)"copyFile");
        }
        finally {
            StreamProcUtil.close(sIn);
            StreamProcUtil.close(sOut);
        }
    }

    public static boolean deleteFile(String fileName) throws IOException {
        File file = new File(fileName);
        if (file.exists()) {
            file.setWritable(true);
            return file.delete();
        }
        return false;
    }
}

