/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util.combinateconf;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropUtil.class);
    private static PropUtil sInstance = null;
    private static Map<String, String> sPropertiesMap = new HashMap<String, String>();
    private static final String PROPERTIES_FILE_PATH = "/installConf.properties";

    PropUtil() {
        this.init();
    }

    public static synchronized PropUtil getInstance() {
        if (sInstance == null) {
            sInstance = new PropUtil();
        }
        return sInstance;
    }

    public String getValue(String key) {
        return sPropertiesMap.get(key);
    }

    private void init() {
        this.initPropertiesKeyValue(PROPERTIES_FILE_PATH);
    }

    private void initPropertiesKeyValue(String filePath) {
        Set<Map.Entry<Object, Object>> entrySet = this.getEntrySet(filePath);
        if (null == entrySet) {
            return;
        }
        for (Map.Entry<Object, Object> entry : entrySet) {
            String servKey = (String)entry.getKey();
            String servValue = (String)entry.getValue();
            sPropertiesMap.put(servKey, servValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Map.Entry<Object, Object>> getEntrySet(String filePath) {
        InputStream inStream = PropUtil.class.getResourceAsStream(filePath);
        Properties serviceProp = new Properties();
        Set<Map.Entry<Object, Object>> entrySet = null;
        try {
            serviceProp.load(inStream);
            entrySet = serviceProp.entrySet();
        }
        catch (IOException e) {
            LOGGER.error("get entryset occurs error.", (Throwable)e);
        }
        finally {
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    LOGGER.error("close io occurs error.", (Throwable)e);
                }
            }
        }
        return entrySet;
    }
}

