/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util.db;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.model.DataBaseInfo;
import com.huawei.elog.base.sdk.IInstallContext;
import com.huawei.elog.common.StreamProcUtil;
import com.huawei.elog.util.FileUtil;
import com.huawei.elog.util.IgnoreDTDEntityResolver;
import com.huawei.elog.util.JarFileUtil;
import com.huawei.elog.util.PropertyManager;
import com.huawei.elog.util.XmlWriterFactory;
import com.huawei.elog.util.sdp.EncryptData;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;

public abstract class ChangeDbInforInJar {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChangeDbInforInJar.class);
    private static IInstallContext installContext = InstallContext.getInstance();
    private static final String DEFAULT_IP = "[IPADDRESS]";
    private static final String DEFAULT_PORT = "[PORT]";
    private static final String MYSQL = "MySQL";
    private static final String SQLSERVER = "Microsoft SQL Server";
    private static final String ORACLE = "Oracle";
    private static final EncryptData ENCRYPT_DATA = EncryptData.getInstanse();

    public static void changePropDBFile(DataBaseInfo dbInfor, String savePath) throws IOException {
        LOGGER.info("Change DB Properties ", (Object)"changePropDBFile");
        String dbHost = dbInfor.getDbHost();
        String dbuseName = dbInfor.getDbUserName();
        String dbType = dbInfor.getDbType();
        String dbPort = dbInfor.getDbPort();
        String dbPassword = dbInfor.getDbPassword();
        String fileNameOne = "";
        String[] keys = new String[5];
        String[] values = new String[5];
        keys[0] = "hibernate.connection.driver_class";
        keys[1] = "hibernate.connection.username";
        keys[2] = "hibernate.dialect";
        keys[3] = "hibernate.connection.url";
        keys[4] = "hibernate.connection.password";
        if (dbType.equalsIgnoreCase(MYSQL)) {
            fileNameOne = installContext.getEnvirments().getBasePath() + PropertyManager.getProValue("hibernate.dbfile.mysql.prop");
            values[0] = PropertyManager.getProValue("hibernate.mysql.connection.driver_class");
            values[1] = dbuseName;
            values[2] = PropertyManager.getProValue("hibernate.mysql.dialect");
            values[3] = PropertyManager.getProValue("hibernate.mysql.connection.url.property").replace(DEFAULT_IP, dbHost).replace(DEFAULT_PORT, dbPort);
            values[4] = ENCRYPT_DATA.encrypt(dbPassword);
        }
        String targetFile = savePath + PropertyManager.getProValue("hibernate.dbfile.prop.replace");
        FileUtil.modifyDBPropFileUsingStr(fileNameOne, keys, values, targetFile);
        JarFileUtil.editJar(savePath + "/" + PropertyManager.getProValue("install.lego_version.backend.jar.path") + "/" + PropertyManager.getProValue("install.db.propfile.jar"), "lego.properties", targetFile);
        LOGGER.info("Finish Replace the lego.properties file in jar.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void changeDBXmlFile(DataBaseInfo dbInfor, String savePath) throws DocumentException, IOException {
        String targetFile = savePath + PropertyManager.getProValue("hibernate.dbfile.xml.replace");
        LOGGER.info("Change DB XML ", (Object)"changeDBXmlFile");
        String fileNameTow = "";
        SAXReader reader = new SAXReader();
        reader.setEntityResolver((EntityResolver)new IgnoreDTDEntityResolver());
        Document document = null;
        if (dbInfor.getDbType().equalsIgnoreCase(MYSQL)) {
            fileNameTow = installContext.getEnvirments().getBasePath() + PropertyManager.getProValue("hibernate.dbfile.mysql.xml");
            document = reader.read(new File(fileNameTow));
            ChangeDbInforInJar.changeXmlInMysql(document, dbInfor);
        } else if (dbInfor.getDbType().equalsIgnoreCase(SQLSERVER)) {
            fileNameTow = installContext.getEnvirments().getBasePath() + PropertyManager.getProValue("hibernate.dbfile.sqlserver.xml");
            document = reader.read(new File(fileNameTow));
            ChangeDbInforInJar.changeXmlInSqlserver(document, dbInfor);
        } else if (dbInfor.getDbType().equalsIgnoreCase(ORACLE)) {
            fileNameTow = installContext.getEnvirments().getBasePath() + PropertyManager.getProValue("hibernate.dbfile.oracle.xml");
            document = reader.read(new File(fileNameTow));
            ChangeDbInforInJar.changeXmlInOracle(document, dbInfor);
        }
        if (null == document) {
            LOGGER.error("changeDBXmlFile error,document is null.");
            return;
        }
        XMLWriter writer = null;
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            writer = XmlWriterFactory.getXmlWriter(new File(targetFile), format);
            writer.write(document);
        }
        catch (FileNotFoundException e) {
            LOGGER.error("File no found: ", (Throwable)e);
            StreamProcUtil.close(writer);
        }
        catch (UnsupportedEncodingException e2) {
            LOGGER.error("File no found: ", (Throwable)e2);
            {
                catch (Throwable throwable) {
                    StreamProcUtil.close(writer);
                    throw throwable;
                }
            }
            StreamProcUtil.close(writer);
        }
        StreamProcUtil.close(writer);
        LOGGER.info("Finish Replace the lego.properties file in jar.");
    }

    private static void changeXmlInSqlserver(Document document, DataBaseInfo dbInfor) {
        List eleList = document.selectNodes("/hibernate-configuration/session-factory/property");
        for (Element element : eleList) {
            String key = element.attributeValue("name");
            if ("connection.driver_class".equalsIgnoreCase(key)) {
                element.setText(PropertyManager.getProValue("hibernate.sqlserver.connection.driver_class"));
            } else if ("connection.url".equalsIgnoreCase(key)) {
                String url = PropertyManager.getProValue("hibernate.sqlserver.connection.url.xml");
                url = url.replace(DEFAULT_IP, dbInfor.getDbHost());
                url = url.replace(DEFAULT_PORT, dbInfor.getDbPort());
                element.setText(url);
            } else if ("connection.username".equalsIgnoreCase(key)) {
                element.setText(dbInfor.getDbUserName());
            } else if ("connection.encryptedpassword".equalsIgnoreCase(key)) {
                element.setText(ENCRYPT_DATA.encrypt(dbInfor.getDbPassword()));
            } else if ("dialect".equalsIgnoreCase(key)) {
                element.setText(PropertyManager.getProValue("hibernate.sqlserver.dialect"));
            } else if ("databasename".equalsIgnoreCase(key)) {
                element.setText("MSSQL");
            }
            LOGGER.info("modified sqlserver.property.");
        }
    }

    private static void changeXmlInMysql(Document document, DataBaseInfo dbInfor) {
        List eleList = document.selectNodes("/hibernate-configuration/session-factory/property");
        for (Element element : eleList) {
            String key = element.attributeValue("name");
            if ("connection.driver_class".equalsIgnoreCase(key)) {
                element.setText(PropertyManager.getProValue("hibernate.mysql.connection.driver_class"));
            } else if ("connection.url".equalsIgnoreCase(key)) {
                element.setText(PropertyManager.getProValue("hibernate.mysql.connection.url.xml").replace(DEFAULT_IP, dbInfor.getDbHost()).replace(DEFAULT_PORT, dbInfor.getDbPort()));
            } else if ("connection.username".equalsIgnoreCase(key)) {
                element.setText(dbInfor.getDbUserName());
            } else if ("connection.encryptedpassword".equalsIgnoreCase(key)) {
                element.setText(ENCRYPT_DATA.encrypt(dbInfor.getDbPassword()));
            } else if ("dialect".equalsIgnoreCase(key)) {
                element.setText(PropertyManager.getProValue("hibernate.mysql.dialect"));
            } else if ("databasename".equalsIgnoreCase(key)) {
                element.setText("MYSQL");
            }
            LOGGER.info("modified mysql.property.");
        }
    }

    private static void changeXmlInOracle(Document document, DataBaseInfo dbInfor) {
        List eleList = document.selectNodes("/hibernate-configuration/session-factory/property");
        for (Element element : eleList) {
            String key = element.attributeValue("name");
            if ("connection.driver_class".equalsIgnoreCase(key)) {
                element.setText(PropertyManager.getProValue("hibernate.oracle.connection.driver_class"));
            } else if ("connection.url".equalsIgnoreCase(key)) {
                element.setText(PropertyManager.getProValue("hibernate.oracle.connection.url.xml").replace(DEFAULT_IP, dbInfor.getDbHost()).replace(DEFAULT_PORT, dbInfor.getDbPort()));
            } else if ("connection.username".equalsIgnoreCase(key)) {
                element.setText(dbInfor.getDbUserName());
            } else if ("connection.encryptedpassword".equalsIgnoreCase(key)) {
                element.setText(ENCRYPT_DATA.encrypt(dbInfor.getDbPassword()));
            } else if ("dialect".equalsIgnoreCase(key)) {
                element.setText(PropertyManager.getProValue("hibernate.oracle.dialect"));
            } else if ("databasename".equalsIgnoreCase(key)) {
                element.setText("ORACLE");
            }
            LOGGER.info("modified Oracle.property.");
        }
    }
}

