/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util.db;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.model.DataBaseInfo;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.DBConnectionFactory;
import com.huawei.elog.util.IDBConnection;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DBUtil {
    private static final Logger LOG = LoggerFactory.getLogger(DBUtil.class);

    private DBUtil() {
    }

    public static boolean checkDbValid() {
        DataBaseInfo dbInfor;
        IDBConnection dbConnection;
        if (InstallContext.getInstance().getInstallType().contains("Collector")) {
            return true;
        }
        if (InstallContext.getInstance().getInstallType().contains("legoPlat") && null != (dbConnection = DBConnectionFactory.getInstance(dbInfor = DBUtil.getBaseInfo()))) {
            return dbConnection.isConnected(dbInfor, true);
        }
        return false;
    }

    public static DataBaseInfo getBaseInfo() {
        DataBaseInfo dbInfo = new DataBaseInfo();
        try {
            String dbType = ContextUtil.getStrValueFromCtx("lego.db.type");
            String host = ContextUtil.getStrValueFromCtx("lego.db.ipaddress");
            String port = ContextUtil.getStrValueFromCtx("lego.db.port");
            String user = ContextUtil.getStrValueFromCtx("lego.db.username");
            String password = ContextUtil.getStrValueFromCtx("lego.db.password");
            String nmsuser = ContextUtil.getStrValueFromCtx("esight.db.nmsdbuser");
            String nmspassword = ContextUtil.getStrValueFromCtx("esight.db.nmsdbpassword");
            String sid = ContextUtil.getStrValueFromCtx("database.sid");
            dbInfo.setDbType(dbType);
            dbInfo.setDbHost(host);
            dbInfo.setDbPort(port);
            dbInfo.setDbUserName(user);
            dbInfo.setDbPassword(password);
            dbInfo.setDbNmsUserName(nmsuser);
            dbInfo.setDbNmsPassword(nmspassword);
            dbInfo.setSid(sid);
        }
        catch (Exception e) {
            LOG.error("setConnParam error" + e, (Object)"setConnParam");
        }
        return dbInfo;
    }

    public static String curTimeZone() {
        TimeZone timeZone = TimeZone.getDefault();
        LOG.info("curTimeZone : " + timeZone.getID());
        LOG.info(timeZone.getDisplayName());
        try {
            return URLEncoder.encode(timeZone.getID(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "UTC";
        }
    }
}

