/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util.db;

import com.huawei.elog.base.InstallContext;
import com.huawei.elog.base.model.DataBaseInfo;
import com.huawei.elog.util.BubbleSorter;
import com.huawei.elog.util.DbScript;
import com.huawei.elog.util.InitSQL;
import com.huawei.elog.util.PropertyManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InitDBTool {
    private static final Logger LOGGER = LoggerFactory.getLogger(InitDBTool.class);
    private static final String CREATE_TABLE = "create-table.properties";
    private static final String CREATE_DB = "create-db.properties";
    private static final String CREATE_OTHERS = "others.properties";
    private static final String MYSQL = "MySQL";
    private static final String SQLSERVER = "Microsoft SQL Server";
    private static String basePath = InstallContext.getInstance().getEnvirments().getPropertyMap().getProp("lego.base.path").getValue().toString();

    public static void updatePlatformDB(DataBaseInfo dbInfor, String ptVersion) throws IOException {
        DbScript dbinit = InitDBTool.getPlatformDBUpdate(dbInfor, ptVersion);
        InitSQL init = new InitSQL(dbinit);
        try {
            init.fixDB(dbInfor);
            init.fixTable(dbInfor);
            init.fixData(dbInfor);
        }
        catch (SQLException e) {
            LOGGER.error("modified platform occurs error.", (Throwable)e);
        }
    }

    public static void initProductDB(DataBaseInfo dbInfor, String productPath) throws IOException {
        DbScript dbinit = InitDBTool.getProductDBInit(dbInfor, productPath);
        InitSQL init = new InitSQL(dbinit);
        try {
            init.fixDB(dbInfor);
            init.fixTable(dbInfor);
            init.fixData(dbInfor);
            init.fixOtherSQLs(dbInfor);
        }
        catch (SQLException e) {
            LOGGER.error("modified product db occurs error.", (Throwable)e);
        }
    }

    public static void updateProductDB(DataBaseInfo dbInfor, String productPath, String pdVersion) throws IOException {
        DbScript dbinit = InitDBTool.getProductDBUpdate(dbInfor, productPath, pdVersion);
        InitSQL init = new InitSQL(dbinit);
        try {
            init.fixDB(dbInfor);
            init.fixTable(dbInfor);
            init.fixData(dbInfor);
            init.fixOtherSQLs(dbInfor);
        }
        catch (SQLException e) {
            LOGGER.error("modified product db occurs error.", (Throwable)e);
        }
    }

    private static DbScript getProductDBUpdate(DataBaseInfo dbInfor, String productId, String pdVersion) throws IOException {
        String dbFolder = "";
        if (SQLSERVER.equalsIgnoreCase(dbInfor.getDbType())) {
            dbFolder = basePath + "Plug-In/" + productId + "/script/dbscript/update/sqlserver/";
        } else if (MYSQL.equalsIgnoreCase(dbInfor.getDbType())) {
            dbFolder = basePath + "Plug-In/" + productId + "/script/dbscript/update/mysql/";
        }
        DbScript dbinit = new DbScript();
        File[] files = InitDBTool.getInsertDB(dbFolder);
        dbinit.setDataFiles(InitDBTool.filterSqlFiles(files, pdVersion));
        dbinit.setTable((LinkedHashMap)InitDBTool.getKeyValueMap(dbFolder + CREATE_TABLE));
        dbinit.setDb((LinkedHashMap)InitDBTool.getKeyValueMap(dbFolder + CREATE_DB));
        files = InitDBTool.getOtherSQLs(dbFolder);
        dbinit.setOtherFiles(InitDBTool.filterSqlFiles(files, pdVersion));
        return dbinit;
    }

    private static DbScript getProductDBInit(DataBaseInfo dbInfor, String productPath) throws IOException {
        String dbFolder = "";
        if ("SQLSERVER".equalsIgnoreCase(dbInfor.getDbType())) {
            dbFolder = basePath + "Plug-In/" + productPath + "/script/dbscript/install/sqlserver/";
        } else if ("MYSQL".equalsIgnoreCase(dbInfor.getDbType())) {
            dbFolder = basePath + "Plug-In/" + productPath + "/script/dbscript/install/mysql/";
        }
        DbScript dbinit = new DbScript();
        dbinit.setDataFiles(InitDBTool.getInsertDB(dbFolder));
        dbinit.setTable((LinkedHashMap)InitDBTool.getKeyValueMap(dbFolder + CREATE_TABLE));
        dbinit.setDb((LinkedHashMap)InitDBTool.getKeyValueMap(dbFolder + CREATE_DB));
        dbinit.setOtherFiles(InitDBTool.getOtherSQLs(dbFolder));
        return dbinit;
    }

    private static DbScript getPlatformDBUpdate(DataBaseInfo dbInfor, String ptVersion) throws IOException {
        String dbFolder = "";
        if (SQLSERVER.equalsIgnoreCase(dbInfor.getDbType())) {
            dbFolder = basePath + PropertyManager.getProValue("update.initdb.sqlserver");
        } else if (MYSQL.equalsIgnoreCase(dbInfor.getDbType())) {
            dbFolder = basePath + PropertyManager.getProValue("update.initdb.mysql");
        }
        DbScript dbinit = new DbScript();
        File[] files = InitDBTool.getInsertDB(dbFolder);
        dbinit.setDataFiles(InitDBTool.filterSqlFiles(files, ptVersion));
        dbinit.setTable((LinkedHashMap)InitDBTool.getKeyValueMap(dbFolder + CREATE_TABLE));
        dbinit.setDb((LinkedHashMap)InitDBTool.getKeyValueMap(dbFolder + CREATE_DB));
        dbinit.setOtherFiles(InitDBTool.getOtherSQLs(dbFolder));
        return dbinit;
    }

    private static File[] getInsertDB(String dbFolder) {
        File folder = new File(dbFolder);
        Comparable[] files = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".sql");
            }
        });
        if (null == files || files.length < 1) {
            return new File[0];
        }
        BubbleSorter sorter = new BubbleSorter();
        sorter.sort(files);
        return files;
    }

    private static File[] filterSqlFiles(File[] files, String version) {
        int i;
        File[] newFiles = null;
        ArrayList<File> filesTmp = new ArrayList<File>();
        if (null != files && files.length > 0) {
            for (i = 0; i < files.length; ++i) {
                File file = files[i];
                String fileName = file.getName();
                String sqlVersion = fileName.substring(0, fileName.indexOf("_"));
                boolean isNewVersion = InitDBTool.validVersion(version, sqlVersion);
                if (!isNewVersion) continue;
                filesTmp.add(file);
            }
        }
        newFiles = new File[filesTmp.size()];
        for (i = 0; i < filesTmp.size(); ++i) {
            newFiles[i] = (File)filesTmp.get(i);
        }
        return newFiles;
    }

    private static boolean validVersion(String id1, String id2) {
        boolean newVersion = false;
        String[] oldVersions = id1.split("\\.");
        String[] newVersions = id2.split("\\.");
        for (int i = 0; i < oldVersions.length; ++i) {
            if (Integer.parseInt(oldVersions[i]) >= Integer.parseInt(newVersions[i])) continue;
            newVersion = true;
            break;
        }
        return newVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> getKeyValueMap(String fileName) throws IOException {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        File file = new File(fileName);
        if (!file.exists()) {
            return map;
        }
        BufferedReader bufferReader = null;
        InputStreamReader fileReader = null;
        try {
            fileReader = new InputStreamReader((InputStream)new FileInputStream(file), "utf-8");
            bufferReader = new BufferedReader(fileReader);
            String text = null;
            while ((text = bufferReader.readLine()) != null) {
                if (!(text = Normalizer.normalize(text, Normalizer.Form.NFKC)).contains("=")) continue;
                int firstIndex = text.indexOf("=");
                map.put(text.substring(0, firstIndex), text.substring(firstIndex + 1));
            }
            return map;
        }
        catch (IOException e) {
            LOGGER.error("getKeyValueMap", (Throwable)e);
            return map;
        }
        finally {
            try {
                if (bufferReader != null) {
                    bufferReader.close();
                }
            }
            catch (IOException e) {
                LOGGER.error("getKeyValueMap", (Throwable)e);
            }
            finally {
                try {
                    if (fileReader != null) {
                        fileReader.close();
                    }
                }
                catch (IOException e) {
                    LOGGER.error("getKeyValueMap", (Throwable)e);
                }
            }
        }
    }

    private static File[] getOtherSQLs(String dbFolder) {
        File folder = new File(dbFolder);
        Comparable[] files = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(InitDBTool.CREATE_OTHERS);
            }
        });
        if (null == files || files.length < 1) {
            return new File[0];
        }
        BubbleSorter sorter = new BubbleSorter();
        sorter.sort(files);
        return files;
    }
}

