/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util.sdp;

import com.hs.lego.core.sdk.file.util.PropertiesLoader;
import com.huawei.elog.base.InstallContext;
import com.huawei.elog.util.CommonUtil;
import com.huawei.elog.util.ContextUtil;
import com.huawei.elog.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DataProtectConfigHelper {
    private static Logger log = LoggerFactory.getLogger(DataProtectConfigHelper.class);
    private static Properties configs = null;

    public static String getKmcConfigRootPath() {
        String installPath = ContextUtil.getStrValueFromCtx("lego.base.installpath");
        String path = null;
        log.info("INSTALL_PATH: ({}), user.dir: ({})", (Object)installPath, (Object)System.getProperty("user.dir"));
        if (null != installPath && !"".equals(installPath)) {
            String installType = InstallContext.getInstance().getInstallType();
            log.info("{} was installed, begin to get sdp path.", (Object)installType);
            path = installType.contains("legoPlat") ? installPath + "/Runtime/bin/etc/config/sdp" : (installType.contains("Collector") ? installPath + "/antiddos_collector/uninstall/etc/config/sdp" : System.getProperty("user.dir") + "/etc/config/sdp");
        } else {
            log.info("ATIC was not installed, begin to get sdp path.");
            path = System.getProperty("user.home") + "/logcenter/etc/config/sdp";
            FileUtil.deleteAllFolder(new File(path));
            if (!new File(path).exists()) {
                String oldPath = System.getProperty("user.dir") + "/etc/config/sdp";
                String installType = InstallContext.getInstance().getInstallType();
                if (installType.contains("Collector")) {
                    oldPath = System.getProperty("user.dir") + "/../etc/config/sdp";
                }
                CommonUtil.copyFolder(oldPath, path);
            }
        }
        path = path.replace("/", File.separator);
        log.info("Last sdp path  is: " + path);
        return path;
    }

    public static String getKmclibPath() {
        String libPath = System.getProperty("user.dir") + "/lib";
        String installType = InstallContext.getInstance().getInstallType();
        if ("Collector".equals(installType)) {
            libPath = System.getProperty("user.dir") + "/../lib";
        }
        log.info("kmc libPath:" + libPath);
        return libPath;
    }

    public static synchronized String getConfigValue(String key) {
        if (null == configs) {
            String fileFullPath = DataProtectConfigHelper.getKmcConfigRootPath() + "/sdp.xml";
            if (!new File(fileFullPath).exists()) {
                log.error("Failed to find kmc path: {}", (Object)fileFullPath);
            }
            try {
                configs = PropertiesLoader.load(fileFullPath, false);
            }
            catch (IOException e) {
                configs = new Properties();
                log.error("load fail: ", (Throwable)e);
            }
        }
        return configs.getProperty(key);
    }
}

