/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.elog.util.sdp;

import com.hs.lego.core.sdk.base.dataprotect.DataProtector;
import com.hs.lego.core.sdk.base.dataprotect.KmcFiles;
import com.huawei.elog.base.InstallContext;
import com.huawei.elog.util.sdp.DataProtectConfigHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EncryptData {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptData.class);
    private static EncryptData instanse = null;
    private static DataProtector dataProtectorInit = null;
    private static DataProtector dataProtectorNew = null;
    private static long local = 0L;

    private EncryptData() {
    }

    public static synchronized EncryptData getInstanse() {
        if (instanse == null) {
            instanse = new EncryptData();
            String libFolderPath = DataProtectConfigHelper.getKmclibPath();
            String sdpConfigRootPath = DataProtectConfigHelper.getKmcConfigRootPath();
            String kmcLogConfigFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("kmcLogConfigFile");
            String initkeyStoreFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("init-keyStoreFile");
            String initkeyStoreBakFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("init-keyStoreBakFile");
            String initkmcCfgFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("init-kmcCfgFile");
            String initkmcCfgBakFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("init-kmcCfgBakFile");
            KmcFiles kfInit = new KmcFiles();
            kfInit.setKeyStoreFile(initkeyStoreFile);
            kfInit.setKeyStoreBakFile(initkeyStoreBakFile);
            kfInit.setKmcCfgFile(initkmcCfgFile);
            kfInit.setKmcCfgBakFile(initkmcCfgBakFile);
            kfInit.setLogConfigFile(kmcLogConfigFile);
            dataProtectorInit = new DataProtector(libFolderPath, kfInit);
            String keyStoreFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("keyStoreFile");
            String keyStoreBakFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("keyStoreBakFile");
            String kmcCfgFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("kmcCfgFile");
            String kmcCfgBakFile = sdpConfigRootPath + DataProtectConfigHelper.getConfigValue("kmcCfgBakFile");
            KmcFiles kf = new KmcFiles();
            kf.setKeyStoreFile(keyStoreFile);
            kf.setKeyStoreBakFile(keyStoreBakFile);
            kf.setKmcCfgFile(kmcCfgFile);
            kf.setKmcCfgBakFile(kmcCfgBakFile);
            kf.setLogConfigFile(kmcLogConfigFile);
            dataProtectorNew = new DataProtector(libFolderPath, kf);
        }
        return instanse;
    }

    public String encrypt(String pucPlainText) {
        return dataProtectorNew.sdpEncrypt(local, pucPlainText);
    }

    public String decrypt(String pucCipherText) {
        DataProtector dp = null;
        DataProtector dp2 = null;
        String installMode = InstallContext.getInstance().getInstallMode();
        if ("install".equals(installMode)) {
            dp = dataProtectorInit;
            dp2 = dataProtectorNew;
        } else {
            dp = dataProtectorNew;
            dp2 = dataProtectorInit;
        }
        String result = dp.sdpDecrypt(local, pucCipherText);
        if (null == result) {
            LOGGER.warn("Failed to decrypt with init key, try another key");
            result = dp2.sdpDecrypt(local, pucCipherText);
        }
        if (null == result) {
            LOGGER.error("Failed to decrypt at last.");
        } else {
            LOGGER.info("Successed in decrypting at last.");
        }
        return result;
    }
}

