/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.comm.internal.jms;

import com.hs.lego.cbb.util.ArrayDeepClone;
import com.hs.lego.comm.internal.jms.MessageRegister;
import com.hs.lego.comm.internal.jms.MessageUnit;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public abstract class MessageTaskManager {
    protected ExecutorService threadPool = null;
    private String listenerAppName = "";
    private transient Log logger = LogFactory.getInstance((Module)Module.ATIC_COM_INTERNAL);

    public MessageTaskManager() {
        this.buildThraedPool(2, this.getClass().getName());
    }

    public MessageTaskManager(int poolsize, String listenerAppName) {
        this.buildThraedPool(poolsize, listenerAppName);
    }

    private void buildThraedPool(int poolsize, String listenAppName) {
        this.threadPool = 0 < poolsize && 6 > poolsize ? Executors.newFixedThreadPool(poolsize) : Executors.newFixedThreadPool(2);
        if (null != listenAppName && listenAppName.equals("")) {
            throw new LegoUncheckedException("when creating MessageTaskManager,the args needed listenerAppName,but current name is : " + listenAppName);
        }
        this.listenerAppName = listenAppName;
    }

    public abstract void onMessage(MessageUnit var1);

    public abstract MessageRegister[] getTypes();

    public final void setMessage(byte[] b) {
        MessageTask mt = new MessageTask();
        mt.setB(b);
        if (!this.threadPool.submit(mt).isDone()) {
            this.logger.error((Object)"threadPool.submit isnt Done");
        }
    }

    public final void destory() {
        try {
            if (null != this.threadPool) {
                this.threadPool.shutdown();
            }
        }
        catch (Exception e) {
            this.logger.error((Object)"Exception ", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MessageUnit decodeMessage(byte[] b) {
        MessageUnit mu = null;
        ObjectInputStream oos = null;
        ByteArrayInputStream os = null;
        try {
            os = new ByteArrayInputStream(b);
            oos = new ObjectInputStream(os);
            mu = (MessageUnit)oos.readObject();
        }
        catch (IOException e) {
            this.logger.error((Object)"IOException error");
        }
        catch (ClassNotFoundException e) {
            this.logger.error((Object)"ClassNotFoundException ", (Throwable)e);
        }
        finally {
            try {
                if (null != oos) {
                    oos.close();
                }
                if (null != os) {
                    os.close();
                }
            }
            catch (IOException e) {
                this.logger.error((Object)"decodeMessage(byte[] b) is error!!");
            }
        }
        return mu;
    }

    public class MessageTask
    implements Runnable {
        private byte[] b = null;

        public byte[] getB() {
            return (byte[])ArrayDeepClone.deepClone((Object)this.b);
        }

        public void setB(byte[] b) {
            this.b = (byte[])ArrayDeepClone.deepClone((Object)b);
        }

        @Override
        public void run() {
            if (null != this.b) {
                long first = System.currentTimeMillis();
                MessageUnit mu = MessageTaskManager.this.decodeMessage(this.b);
                if (null == mu) {
                    return;
                }
                long second = System.currentTimeMillis();
                MessageTaskManager.this.logger.info((Object)("be ready for onMessage(mu)!receiveApp's name is :" + MessageTaskManager.this.listenerAppName + " | the command code is : " + mu.getCmdcode() + "||||the time is : " + (second - first)));
                MessageTaskManager.this.onMessage(mu);
            }
        }
    }
}

