/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.comm.internal.jms.consumer;

import com.hs.lego.comm.internal.jms.MessageRegister;
import com.hs.lego.comm.internal.jms.MessageTaskManager;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoExceptionTranslator;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;

public class SubscriberProxy
implements MessageListener {
    private static final int POOL_SIZE = 5;
    private transient Log log = null;
    private Map<Long, BlockingQueue<MessageTaskManager>> subscribers = Collections.synchronizedMap(new HashMap());
    private ExecutorService threadPool = Executors.newFixedThreadPool(5);

    public SubscriberProxy() {
        this.log = LogFactory.getInstance((Module)Module.ATIC_COM_INTERNAL);
    }

    public void addSubscriber(MessageRegister mr, MessageTaskManager msb) {
        try {
            for (Long mt : mr.getMessageCodes()) {
                this.log.info((Object)(">>>>>>>register'messagecode is : -- " + mt));
                BlockingQueue<MessageTaskManager> msqueue = this.subscribers.get(mt);
                if (msqueue != null) {
                    msqueue.put(msb);
                } else {
                    msqueue = new LinkedBlockingQueue<MessageTaskManager>();
                    msqueue.put(msb);
                }
                this.subscribers.put(mt, msqueue);
            }
        }
        catch (InterruptedException e) {
            throw LegoExceptionTranslator.convert((Throwable)e);
        }
    }

    public void delSubscriber(List<String> ss) {
        ArrayList<MessageTaskManager> mtmList = new ArrayList<MessageTaskManager>();
        for (BlockingQueue<MessageTaskManager> mtmblockq : this.subscribers.values()) {
            for (MessageTaskManager mtm : mtmblockq) {
                if (!this.checkClassExist(mtm.getClass().getName(), ss)) continue;
                mtmList.add(mtm);
                this.log.info((Object)(">>>>>>>remove subscriber : -- " + mtm.getClass().getName()));
            }
            for (MessageTaskManager mtm : mtmList) {
                mtmblockq.remove(mtm);
            }
            mtmList.clear();
        }
    }

    private boolean checkClassExist(String classname, List<String> ss) {
        for (String s : ss) {
            if (!s.endsWith(classname)) continue;
            return true;
        }
        return false;
    }

    public void onMessage(Message message) {
        if (null == message) {
            return;
        }
        SubscriberThread thread = new SubscriberThread();
        thread.setMessage(message);
        if (!this.threadPool.submit(thread).isDone()) {
            this.log.error((Object)"threadPool.submit isnt Done");
        }
    }

    public void destory() {
        if (null != this.subscribers && !this.subscribers.isEmpty()) {
            Iterator<BlockingQueue<MessageTaskManager>> iterator = this.subscribers.values().iterator();
            while (iterator.hasNext()) {
                for (MessageTaskManager msb : iterator.next()) {
                    msb.destory();
                }
            }
            this.threadPool.shutdown();
        }
    }

    class SubscriberThread
    implements Runnable {
        private Message message;

        SubscriberThread() {
        }

        public void setMessage(Message message) {
            this.message = message;
        }

        @Override
        public void run() {
            try {
                if (null == this.message) {
                    return;
                }
                BytesMessage bm = (BytesMessage)this.message;
                long type = this.message.getLongProperty("filter");
                BlockingQueue subscriberqueue = (BlockingQueue)SubscriberProxy.this.subscribers.get(type);
                if (null == subscriberqueue) {
                    this.message = null;
                    return;
                }
                long messLength = bm.getBodyLength();
                if (0L >= type || 0L >= messLength) {
                    return;
                }
                byte[] b = new byte[(int)messLength];
                bm.readBytes(b);
                for (MessageTaskManager msb : subscriberqueue) {
                    msb.setMessage(b);
                }
                return;
            }
            catch (JMSException e) {
                SubscriberProxy.this.log.error((Object)"Get Message Type Error!", (Throwable)e);
                return;
            }
        }
    }
}

