/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.comm.internal.jms.core;

import com.hs.lego.comm.internal.jms.IMessageCenter;
import com.hs.lego.comm.internal.jms.MessageRegister;
import com.hs.lego.comm.internal.jms.MessageTaskManager;
import com.hs.lego.comm.internal.jms.MessageTopic;
import com.hs.lego.comm.internal.jms.MessageUnit;
import com.hs.lego.comm.internal.jms.consumer.SubscriberProxy;
import com.hs.lego.comm.internal.jms.core.MsqQueueClient;
import com.hs.lego.comm.internal.jms.messagecodebase.MessageCodeRegisterException;
import com.hs.lego.comm.internal.jms.productor.TopicClient;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.jms.LegoJMSInitializeException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import com.hs.lego.core.sdk.util.LegoProperties;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.activemq.broker.BrokerService;
import org.springframework.beans.factory.DisposableBean;

public final class MessageCenter
implements DisposableBean,
IMessageCenter {
    private static transient Log log = LogFactory.getInstance((Module)Module.ATIC_COM_INTERNAL);
    private static final Object LOCK = new Object();
    private static MessageCenter mcinstance = null;
    private static Map<Long, Class> messCodeRegister = new HashMap<Long, Class>();
    private static boolean isSuccessful = false;
    private MessageTopic[] topics = new MessageTopic[]{MessageTopic.COMMAND, MessageTopic.CONFIG, MessageTopic.DATA};
    private Map<MessageTopic, MsqQueueClient> clients = Collections.synchronizedMap(new HashMap());
    private Map<MessageTopic, SubscriberProxy> proxys = Collections.synchronizedMap(new HashMap());
    private BrokerService broker = null;

    private MessageCenter() {
        this.initProxys();
    }

    private void initProxys() {
        for (int i = 0; i < this.topics.length; ++i) {
            TopicClient client = new TopicClient();
            client.setName(this.topics[i].name());
            this.clients.put(this.topics[i], client);
            SubscriberProxy proxy = new SubscriberProxy();
            this.proxys.put(this.topics[i], proxy);
        }
    }

    public static boolean isSuccessful() {
        return isSuccessful;
    }

    public static void setSuccessfulCp(boolean isSuccessfulCp) {
        isSuccessful = isSuccessfulCp;
    }

    public void setSuccessful(boolean isSuccessfulCp) {
        MessageCenter.setSuccessfulCp(isSuccessfulCp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageCenter getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (null == mcinstance) {
                mcinstance = new MessageCenter();
            }
            return mcinstance;
        }
    }

    public void registerMessageCode(long messcode, Class<?> c) {
        messCodeRegister.put(messcode, c);
    }

    private void initBroker(String url) {
        try {
            log.info((Object)"intialize broker");
            this.broker = new BrokerService();
            this.broker.setPersistent(false);
            this.broker.setUseJmx(false);
            this.broker.addConnector(url);
            log.info((Object)"begin to start broker");
            this.broker.start();
        }
        catch (Exception e) {
            log.error((Object)"init broken Exception", (Throwable)e);
        }
        catch (Error e) {
            log.error((Object)"init broken Error", (Throwable)e);
        }
    }

    public void initializeMessageCenter() {
        String addr;
        log.info((Object)"the MessageCenter is initializing!");
        String url = addr = LegoProperties.getInstance().getProperty("jms.server", "tcp://127.0.0.1:32226");
        log.info((Object)("connection url:" + url));
        this.initBroker(url);
        log.info((Object)("begin to init listen clients: " + this.topics.length));
        for (int i = 0; i < this.topics.length; ++i) {
            try {
                log.info((Object)("begin to create MsqQueueClient:" + (Object)((Object)this.topics[i])));
                MsqQueueClient client = this.clients.get((Object)this.topics[i]);
                client.connect(url);
                SubscriberProxy proxy = this.proxys.get((Object)this.topics[i]);
                client.setListener(proxy);
                log.info((Object)("finished create MsqQueueClient ok:" + (Object)((Object)this.topics[i])));
                continue;
            }
            catch (Exception e) {
                log.error((Object)"Set Listener Exception! ", (Throwable)e);
                throw new LegoJMSInitializeException("Set Listener Exception! ", (Throwable)e);
            }
            catch (Error e) {
                log.error((Object)"Set Listener Error! ", (Throwable)e);
                throw new LegoJMSInitializeException("Set Listener Error! ", (Throwable)e);
            }
        }
        this.setSuccessful(true);
        log.info((Object)"the MessageCenter's initializing is OK!!");
    }

    public void destroy() {
        if (null != this.clients && !this.clients.isEmpty()) {
            for (MsqQueueClient client : this.clients.values()) {
                client.disconnect();
            }
        }
        try {
            this.broker.stop();
        }
        catch (Exception e) {
            log.error((Object)"stop borken failed:", (Throwable)e);
        }
    }

    @Override
    public void addSubscriberTo(MessageTaskManager subscriber) {
        log.info((Object)(">>>>>>>MessageTaskManager:--" + subscriber.getClass().getName()));
        for (MessageRegister mr : subscriber.getTypes()) {
            log.info((Object)(">>>>>>>MessageTopic is : --" + (Object)((Object)mr.getMessageTopic())));
            SubscriberProxy proxy = this.proxys.get((Object)mr.getMessageTopic());
            proxy.addSubscriber(mr, subscriber);
        }
    }

    public void delSubscriberTo(List<String> ss) {
        for (SubscriberProxy proxy : this.proxys.values()) {
            proxy.delSubscriber(ss);
        }
    }

    private String checkSendMessage(MessageUnit mu) {
        Long messagecode = mu.getCmdcode();
        Class c = messCodeRegister.get(messagecode);
        log.info((Object)("!isSuccessful: " + !isSuccessful));
        log.info((Object)("null == c: " + (null == c)));
        if (!isSuccessful || null == c) {
            throw new MessageCodeRegisterException("the messageCode is not legal OR MessageCenter's initializing is not over!!");
        }
        return c.getName();
    }

    @Override
    public void sendMessage(String appName, MessageUnit detail, MessageTopic dest) {
        if (null == appName || appName.equals("")) {
            log.error((Object)("when sending message,appName is : " + appName));
            return;
        }
        if (null == dest) {
            log.error((Object)"when sending message,MessageTopic is null!");
            return;
        }
        try {
            String messagecodeclassname = this.checkSendMessage(detail);
            MsqQueueClient client = this.clients.get((Object)dest);
            client.sendObj(detail);
            log.info((Object)("sending message is over!the sendApp's name is : " + appName + " | the Command code is : " + detail.getCmdcode() + "the RegisterClassName with the messagecode is :--" + messagecodeclassname));
        }
        catch (Exception e) {
            log.error((Object)"send message Exception", (Throwable)e);
        }
        catch (Error e) {
            log.error((Object)"send message Error", (Throwable)e);
        }
    }

    @Override
    public void sendMessage(MessageUnit detail) {
        if (null == detail) {
            log.error((Object)"when sending message,--send's detail is null!");
            return;
        }
        try {
            String messagecodeclassname = this.checkSendMessage(detail);
            MsqQueueClient client = this.clients.get((Object)detail.getMt());
            client.sendObj(detail);
            log.info((Object)("sending message is over!the sendApp's name is : " + detail.getSourceAppName() + " | the Command code is : " + detail.getCmdcode() + "the RegisterClassName with the messagecode is :--" + messagecodeclassname));
        }
        catch (Exception e) {
            log.error((Object)"send message Exception", (Throwable)e);
        }
        catch (Error e) {
            log.error((Object)"send message Error", (Throwable)e);
        }
    }
}

