/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.comm.internal.jms.messagemanager;

import com.hs.lego.comm.internal.jms.core.MessageCenter;
import com.hs.lego.comm.internal.jms.messagecodebase.CommandCodeBase;
import com.hs.lego.comm.internal.jms.messagecodebase.MessageCodeRegisterException;
import com.hs.lego.comm.internal.jms.messagecodebase.ProductName;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MessageChecker {
    private static String methodName = "getProductName";
    private Map<ProductName, MessageLimitS> messSegmentFilter = null;
    private transient Log log = LogFactory.getInstance((Module)Module.ATIC_COM_INTERNAL);
    private List<Class<?>> clas = null;

    public MessageChecker() {
        this.messSegmentFilter = new HashMap<ProductName, MessageLimitS>();
        try {
            Field[] fds = CommandCodeBase.class.getDeclaredFields();
            List<ProductName> pns = ProductName.values();
            long base = 0L;
            long max = 0L;
            int index = 0;
            for (int i = 0; i < fds.length; ++i) {
                if (0 != (i + 1) % 2) {
                    base = fds[i].getLong(CommandCodeBase.class);
                    continue;
                }
                max = fds[i].getLong(CommandCodeBase.class);
                MessageLimitS mls = new MessageLimitS();
                mls.setBase(base);
                mls.setMax(max);
                this.messSegmentFilter.put(pns.get(index), mls);
                ++index;
            }
        }
        catch (IllegalArgumentException e) {
            this.log.error((Object)e.getMessage());
        }
        catch (IllegalAccessException e) {
            this.log.error((Object)e.getMessage());
        }
    }

    public void setClasss(List<Class<?>> classs) {
        this.clas = classs;
    }

    public void checkClasss(MessageCenter mc) {
        this.log.info((Object)"checkClasss(MessageCenter mc)");
        if (null != this.clas) {
            for (Class<?> s : this.clas) {
                this.judgeSpecialMessageClass(s, mc);
            }
        }
    }

    public void judgeSpecialMessageClass(Class c, MessageCenter mc) {
        try {
            this.log.info((Object)"judgeSpecialMessageClass(Class c,MessageCenter mc)");
            Object mcb = c.newInstance();
            Method m = c.getDeclaredMethod(methodName, new Class[0]);
            Object pn = m.invoke(mcb, new Object[0]);
            Field[] fds = c.getDeclaredFields();
            for (int i = 0; i < fds.length; ++i) {
                long code = fds[i].getLong(mcb);
                this.judgeSpecialMessageCode(pn, code);
                mc.registerMessageCode(code, c);
                this.log.info((Object)("register's code is:-" + code + " | the class is:-" + c.getName()));
            }
        }
        catch (InstantiationException e) {
            this.log.error((Object)e);
        }
        catch (IllegalAccessException e) {
            this.log.error((Object)e);
        }
        catch (NoSuchMethodException e) {
            this.log.error((Object)e);
        }
        catch (SecurityException e) {
            this.log.error((Object)e);
        }
        catch (IllegalArgumentException e) {
            this.log.error((Object)e);
        }
        catch (InvocationTargetException e) {
            this.log.error((Object)e);
        }
    }

    public void judgeSpecialMessageCode(Object productname, long messcode) {
        block8: {
            try {
                Method m = productname.getClass().getDeclaredMethod(methodName, new Class[0]);
                Object ro = m.invoke(productname, new Object[0]);
                String proname = ro.toString();
                ProductName pn = ProductName.fromString(proname);
                if (null != pn) {
                    MessageLimitS mls = this.messSegmentFilter.get(pn);
                    long base = mls.getBase();
                    long max = mls.getMax();
                    if (base >= messcode && max < messcode) {
                        String errorinfo = "the productname is: " + proname + ". messagecode segment is from " + base + " to " + max + " --but current messagecode is: " + messcode;
                        throw new MessageCodeRegisterException(errorinfo);
                    }
                    break block8;
                }
                String errorinfo = "the productname isn't registed!! ";
                throw new MessageCodeRegisterException(errorinfo);
            }
            catch (NoSuchMethodException e) {
                this.log.error((Object)e.getMessage());
            }
            catch (SecurityException e) {
                this.log.error((Object)e.getMessage());
            }
            catch (IllegalAccessException e) {
                this.log.error((Object)e.getMessage());
            }
            catch (IllegalArgumentException e) {
                this.log.error((Object)e.getMessage());
            }
            catch (InvocationTargetException e) {
                this.log.error((Object)e.getMessage());
            }
        }
    }

    private static class MessageLimitS {
        private long base = 0L;
        private long max = 0L;

        private MessageLimitS() {
        }

        public long getBase() {
            return this.base;
        }

        public void setBase(long base) {
            this.base = base;
        }

        public long getMax() {
            return this.max;
        }

        public void setMax(long max) {
            this.max = max;
        }
    }
}

