/*
 * Decompiled with CFR 0.152.
 */
package com.hs.lego.comm.internal.jms.productor;

import com.hs.lego.comm.internal.jms.MessageUnit;
import com.hs.lego.comm.internal.jms.core.MsqQueueClient;
import com.hs.lego.core.base.constant.Module;
import com.hs.lego.core.sdk.exception.LegoUncheckedException;
import com.hs.lego.core.sdk.exception.jms.LegoJMSDestoryException;
import com.hs.lego.core.sdk.exception.jms.LegoJMSInitializeException;
import com.hs.lego.core.sdk.exception.jms.LegoJMSRuntimeException;
import com.hs.lego.core.sdk.log.Log;
import com.hs.lego.core.sdk.log.LogFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import org.apache.activemq.ActiveMQConnectionFactory;

public class TopicClient
implements MsqQueueClient {
    BlockingQueue<MessageUnit> failMsgs = new LinkedBlockingQueue<MessageUnit>();
    private TopicConnection conn;
    private TopicSession session;
    private String name;
    private Topic topic;
    private TopicPublisher publisher;
    private TopicSubscriber subscriber;
    private MessageListener messagelistener = null;
    private String filter = "";
    private String url = "";
    private final ReentrantLock sessionLock = new ReentrantLock();
    private transient Log log = LogFactory.getInstance((Module)Module.ATIC_COM_INTERNAL);

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setFilter(String filter) {
        this.filter = filter;
    }

    @Override
    public void setListener(MessageListener listener) {
        this.log.info((Object)("Set listener " + this.topic));
        try {
            this.subscriber = this.filter.equals("") ? this.session.createSubscriber(this.topic) : this.session.createSubscriber(this.topic, this.filter, false);
            if (null == this.messagelistener) {
                this.messagelistener = listener;
            }
            this.subscriber.setMessageListener(listener);
        }
        catch (JMSException e) {
            this.log.error((Object)"setListener create subscriber error!", (Throwable)e);
            throw new LegoJMSRuntimeException("setListener create subscriber error!", (Throwable)e);
        }
    }

    @Override
    public void connect(String connectFactory) {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(connectFactory);
        try {
            this.doReConnect((TopicConnectionFactory)connectionFactory);
            this.log.info((Object)"conn.start() is successful!");
            this.session = this.conn.createTopicSession(false, 1);
            this.topic = this.session.createTopic(this.name);
            this.publisher = this.session.createPublisher(this.topic);
        }
        catch (JMSException e) {
            this.log.error((Object)"connect activemq server error!", (Throwable)e);
            throw new LegoJMSInitializeException("connect activemq server error!", (Throwable)e);
        }
    }

    private void doReConnect(TopicConnectionFactory tcf) {
        try {
            this.conn = tcf.createTopicConnection();
            this.log.info((Object)"conn = connectionFactory.createTopicConnection()!");
            this.conn.start();
        }
        catch (JMSException e) {
            this.log.error((Object)"doReConnect failed!", (Throwable)e);
            try {
                if (null != this.conn) {
                    this.conn.close();
                }
                this.log.info((Object)"Attempt to connect Broker is failed, Do reconnect after 3s!");
                TimeUnit.MILLISECONDS.sleep(3000L);
            }
            catch (InterruptedException e1) {
                this.log.error((Object)("sleep is error : --" + e1.getMessage()));
            }
            catch (JMSException e1) {
                this.log.error((Object)("doReConnect failed!" + e1.getMessage()));
            }
            this.doReConnect(tcf);
        }
    }

    @Override
    public void closeRecv() {
        try {
            this.subscriber.close();
        }
        catch (JMSException e) {
            this.log.error((Object)"error occur closing receiver ", (Throwable)e);
            throw new LegoJMSDestoryException("error occur closing receiver ", (Throwable)e);
        }
    }

    @Override
    public void sendObj(MessageUnit detail) {
        BytesMessage bytesMessage = null;
        try {
            bytesMessage = this.session.createBytesMessage();
            bytesMessage.writeBytes(this.encodeSendMessage(detail));
            bytesMessage.setLongProperty("filter", detail.getCmdcode());
        }
        catch (JMSException e) {
            if (this.sessionLock.isLocked()) {
                this.log.error((Object)"session.createObjectMessage is failed!-----sendObj(Serializable detail, MessageType type), MessageType type)", (Throwable)e);
                try {
                    this.failMsgs.put(detail);
                }
                catch (InterruptedException e1) {
                    this.log.error((Object)"failMsgs.put(mu) is InterruptedException!!");
                    return;
                }
                return;
            }
            this.rebuildsession();
            this.sendObj(detail);
            while (this.failMsgs.peek() != null) {
                MessageUnit mu = (MessageUnit)this.failMsgs.poll();
                this.sendObj(mu);
            }
            this.log.error((Object)"ActiveMQ create message object error!", (Throwable)e);
            throw new LegoJMSRuntimeException("ActiveMQ create message object error!", (Throwable)e);
        }
        try {
            this.publisher.publish((Message)bytesMessage);
        }
        catch (JMSException e) {
            this.log.error((Object)"ActiveMQ publisher error!", (Throwable)e);
            throw new LegoJMSRuntimeException("ActiveMQ publisher error!", (Throwable)e);
        }
    }

    public byte[] encodeSendMessage(MessageUnit detail) {
        byte[] bytes = null;
        ByteArrayOutputStream os = null;
        ObjectOutputStream oos = null;
        try {
            os = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(os);
            oos.writeObject(detail);
            bytes = os.toByteArray();
        }
        catch (IOException e) {
            this.log.error((Object)"encodeMessage is error!");
            throw new LegoUncheckedException("encodeSendMessage is error!", (Throwable)e);
        }
        finally {
            try {
                if (null != oos) {
                    oos.close();
                }
                if (null != os) {
                    os.close();
                }
            }
            catch (IOException e) {
                this.log.error((Object)"stream's closing is error!");
            }
        }
        return bytes;
    }

    private void reconnect(String connectFactory) {
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory(connectFactory);
        try {
            if (null != this.subscriber) {
                this.subscriber.close();
            }
            if (null != this.publisher) {
                this.publisher.close();
            }
            if (null != this.session) {
                this.session.close();
            }
            if (null != this.conn) {
                this.conn.stop();
                this.conn.close();
            }
            this.conn = connectionFactory.createTopicConnection();
            this.conn.start();
            this.session = this.conn.createTopicSession(false, 1);
            this.topic = this.session.createTopic(this.name);
            this.publisher = this.session.createPublisher(this.topic);
            if (null != this.messagelistener) {
                this.setListener(this.messagelistener);
            } else {
                this.log.error((Object)"when reconnect,the TopoicClient's SubscriberProxy-messagelistener is null !!");
            }
        }
        catch (JMSException e) {
            this.log.error((Object)"reconnect activemq server error!", (Throwable)e);
            throw new LegoJMSInitializeException("reconnect activemq server error!", (Throwable)e);
        }
    }

    private void rebuildsession() {
        this.sessionLock.lock();
        try {
            if (null != this.subscriber) {
                this.subscriber.close();
            }
            if (null != this.publisher) {
                this.publisher.close();
            }
            if (null != this.session) {
                this.session.close();
            }
            this.session = this.conn.createTopicSession(false, 1);
            this.topic = this.session.createTopic(this.name);
            this.publisher = this.session.createPublisher(this.topic);
            if (null != this.messagelistener) {
                this.setListener(this.messagelistener);
            } else {
                this.log.error((Object)"when rebuildsession,the TopoicClient's SubscriberProxy-messagelistener is null !!");
            }
        }
        catch (JMSException e) {
            this.log.error((Object)"rebuildsession error!!", (Throwable)e);
            this.reconnect(this.url);
        }
        finally {
            this.sessionLock.unlock();
        }
    }

    @Override
    public void disconnect() {
        try {
            this.publisher.close();
            this.conn.stop();
            this.session.close();
            this.conn.close();
        }
        catch (JMSException e) {
            this.log.error((Object)"disconnect topic error!", (Throwable)e);
            throw new LegoJMSDestoryException("disconnect topic error!", (Throwable)e);
        }
    }
}

