/*
 * Decompiled with CFR 0.152.
 */
package com.hs.ha;

import com.hs.ha.ActionThread;
import com.hs.ha.AticInstallUtil;
import com.hs.ha.CmdUtil;
import com.hs.ha.Configer;
import com.hs.ha.LogManager;
import com.hs.ha.LogUtil;
import com.hs.ha.MonitorThread;
import com.hs.ha.RmiServiceUtil;
import com.hs.ha.monitor.BasicMonitor;
import com.hs.ha.monitor.DatabaseMonitor;
import com.hs.ha.monitor.FileMonitor;
import com.hs.ha.monitor.HaSwitchMonitor;
import com.hs.ha.monitor.HeartbeatMonitor;
import com.hs.ha.monitor.MysqlSlaveMonitor;
import com.hs.ha.monitor.NetInterfaceMonitor;
import com.hs.ha.monitor.WinServiceMonitor;
import com.hs.ha.rmi.PairMessageService;
import com.hs.ha.vo.MonitorInfo;
import java.io.IOException;
import java.rmi.NotBoundException;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public final class Manager {
    public static final String PAIR = "pair";
    public static final String SINGLE = "single";
    public static final String PRIMARY = "primary";
    public static final String STANDBY = "standby";
    public static final long HA_START_SLEEP_TIME = 5000L;
    private static Logger logger = LogManager.getInstance().getHaLog();
    private static List<MonitorThread> monitorThreadList = new Vector<MonitorThread>();
    private static List<MonitorInfo> monitorInfoList = new Vector<MonitorInfo>();
    private static List<BasicMonitor> actionList = new Vector<BasicMonitor>();
    private static Configer configer = Configer.getInstance();
    private static Manager manager = new Manager();
    private ActionThread actionThread = new ActionThread();
    private long localHaRunDate = 0L;
    private long remoteHaRunDate = 0L;
    private String manageIp;
    private boolean haPair = false;
    private boolean haPrimary = true;
    private boolean autoSwitch = false;
    private boolean currHaPrimary = true;
    private boolean haEnabled = false;
    private boolean isSwitch = false;
    private boolean isSameRole = false;
    private int localHaPrimaryToken = 0;
    private int remoteHaPrimaryToken = 0;
    private boolean isModifyingVsmServer = false;

    private Manager() {
        this.initConfig();
    }

    public boolean isModifyingVsmServer() {
        return this.isModifyingVsmServer;
    }

    public void setModifyingVsmServer(boolean isModifyingVsmServerT) {
        this.isModifyingVsmServer = isModifyingVsmServerT;
    }

    public List<MonitorThread> getMonitorThreadList() {
        return monitorThreadList;
    }

    public static Manager getInstance() {
        return manager;
    }

    private void initThread() {
        this.initHaSwitchThread();
        this.initHaNameAndRole();
        this.initHeartbeatThread();
        this.initNetInterfaceThread();
        this.initMysqlSlaveThread();
        this.initDatabaseThread();
        this.initWinServiceThread();
        this.initFileThread();
    }

    private synchronized void initConfig() {
        this.autoSwitch = configer.isAutoSwitch();
        this.currHaPrimary = this.haPrimary = configer.isHaPrimary();
        this.haPair = configer.isHaPair();
        this.manageIp = configer.getManageLocalIp();
    }

    private void initHaNameAndRole() {
        monitorInfoList.addAll(Configer.getInstance().buildGlobleMonitorInfo());
    }

    private void initHaSwitchThread() {
        HaSwitchMonitor haSwitchMonitor = configer.buildHaSwitchMonitor();
        MonitorThread thread = new MonitorThread(haSwitchMonitor);
        monitorThreadList.add(thread);
    }

    private void initHeartbeatThread() {
        HeartbeatMonitor heartbeatMonitor;
        if (this.haPair && (heartbeatMonitor = configer.buildHeartbeatMonitor()).getMonitorInfoList().size() > 0) {
            monitorInfoList.addAll(heartbeatMonitor.getMonitorInfoList());
            MonitorThread heartbeatThread = new MonitorThread(heartbeatMonitor);
            monitorThreadList.add(heartbeatThread);
        }
    }

    private void initNetInterfaceThread() {
        NetInterfaceMonitor netInterfaceMonitor = configer.buildNetInterfaceMonitor();
        if (netInterfaceMonitor.getMonitorInfoList().size() > 0) {
            monitorInfoList.addAll(netInterfaceMonitor.getMonitorInfoList());
            MonitorThread thread = new MonitorThread(netInterfaceMonitor);
            monitorThreadList.add(thread);
        }
    }

    private void initDatabaseThread() {
        DatabaseMonitor databaseMonitor = configer.buildDatabaseMonitor();
        if (databaseMonitor.getMonitorInfoList().size() > 0) {
            monitorInfoList.addAll(databaseMonitor.getMonitorInfoList());
            MonitorThread thread = new MonitorThread(databaseMonitor);
            monitorThreadList.add(thread);
        }
    }

    private void initMysqlSlaveThread() {
        MysqlSlaveMonitor mysqlSlaveMonitor = configer.buildMysqlSlaveMonitor();
        if (mysqlSlaveMonitor.getMonitorInfoList().size() > 0) {
            monitorInfoList.addAll(mysqlSlaveMonitor.getMonitorInfoList());
            MonitorThread thread = new MonitorThread(mysqlSlaveMonitor);
            monitorThreadList.add(thread);
        }
    }

    private void initWinServiceThread() {
        WinServiceMonitor winServiceMonitor = configer.buildWinServiceMonitor();
        if (winServiceMonitor.getMonitorInfoList().size() > 0) {
            monitorInfoList.addAll(winServiceMonitor.getMonitorInfoList());
            MonitorThread thread = new MonitorThread(winServiceMonitor);
            monitorThreadList.add(thread);
        }
    }

    private void initFileThread() {
        FileMonitor fileMonitor;
        if (this.haPair && (fileMonitor = configer.buildFileMonitor()).getMonitorInfoList().size() > 0) {
            monitorInfoList.addAll(fileMonitor.getMonitorInfoList());
            MonitorThread thread = new MonitorThread(fileMonitor);
            monitorThreadList.add(thread);
        }
    }

    public boolean checkMonitorRunning() {
        return this.haEnabled;
    }

    public synchronized void start() {
        this.haEnabled = true;
        this.initThread();
        logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(12), String.valueOf(Manager.getInstance().isCurrHaPrimary()), new Object[0]));
        for (MonitorThread monitorThread : monitorThreadList) {
            monitorThread.start();
            logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(1), "running", monitorThread.getName()));
        }
        this.actionThread = new ActionThread();
        this.actionThread.start();
        logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(1), "running", "action"));
    }

    public synchronized void stop() {
        this.haEnabled = false;
        this.actionThread.setStop();
        for (MonitorThread monitorThread : monitorThreadList) {
            monitorThread.setStop();
        }
        monitorThreadList.clear();
        monitorInfoList.clear();
        actionList.clear();
    }

    public void notifySwitch() {
        for (MonitorThread monitorThread : monitorThreadList) {
            if (!monitorThread.getMonitor().getName().equalsIgnoreCase("haswitch")) continue;
            ((HaSwitchMonitor)monitorThread.getMonitor()).setSwitch(true);
        }
    }

    public synchronized void switchHa() {
        if (Configer.getInstance().isFloatIP()) {
            this.deleteFloatIp();
            Object addCmd = "";
            String cmd = "";
            if (!this.currHaPrimary) {
                boolean isFloatIpAvailable = false;
                boolean isRemoteFloatIpAvailable = false;
                if (AticInstallUtil.getInstance().getAticInstallOS() == 1) {
                    addCmd = "sudo ifconfig " + Configer.getInstance().getFloatInterface() + ":flo " + Configer.getInstance().getFloatIP() + " netmask " + Configer.getInstance().getFloatSubmask();
                } else {
                    addCmd = "netsh interface ip add address name=\"" + Configer.getInstance().getFloatInterface() + "\" addr=" + Configer.getInstance().getFloatIP() + " mask=" + Configer.getInstance().getFloatSubmask();
                    cmd = "netsh interface ip add address name=\"" + Configer.getInstance().getFloatInterface() + "\" gateway=" + Configer.getInstance().getFloatGateway() + " gwmetric=auto";
                }
                while (!isFloatIpAvailable) {
                    try {
                        CmdUtil.execCmd((String)addCmd);
                        CmdUtil.execCmd(cmd);
                        if (NetInterfaceMonitor.isHaveFloatIP()) {
                            isFloatIpAvailable = true;
                            logger.info((Object)"float ip is available,  start switch");
                        } else {
                            logger.error((Object)"float ip is invalid, retry after 10 seconds");
                        }
                        if (!isFloatIpAvailable) {
                            PairMessageService pairMessageService = RmiServiceUtil.getPairMessageService(Configer.getInstance().getRemoteHeartRmiIp(), String.valueOf(Configer.getInstance().getHeartRmiPort()));
                            if (null != pairMessageService) {
                                isRemoteFloatIpAvailable = pairMessageService.isHaveFloatIp();
                                if (isRemoteFloatIpAvailable) {
                                    logger.error((Object)"isRemoteFloatIpAvailable is true, switch will exit");
                                    return;
                                }
                                logger.error((Object)"isRemoteFloatIpAvailable is false, check float will go on");
                            } else {
                                logger.error((Object)"pairMessageService is null, check float will go on");
                            }
                        }
                        this.wait(10000L);
                    }
                    catch (IOException e) {
                        logger.error((Object)"check float ip available error", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        logger.error((Object)"check float ip available sleep error", (Throwable)e);
                    }
                    catch (NotBoundException e1) {
                        logger.error((Object)"get remote float ip error, switch failed", (Throwable)e1);
                    }
                    catch (RuntimeException e) {
                        logger.error((Object)"check float ip available error", (Throwable)e);
                    }
                }
            }
        }
        this.setSwitch(true);
        this.currHaPrimary = !this.currHaPrimary;
        actionList.clear();
        for (MonitorInfo monitorInfo : monitorInfoList) {
            if (!monitorInfo.getName().equals("haRole")) continue;
            if (this.currHaPrimary) {
                monitorInfo.setLocalStatus(PRIMARY);
                monitorInfo.setRemoteStatus(STANDBY);
                break;
            }
            monitorInfo.setLocalStatus(STANDBY);
            monitorInfo.setRemoteStatus(PRIMARY);
            break;
        }
        if (Configer.getInstance().isFloatIP()) {
            this.changeFloatIp();
            try {
                this.wait(1000L);
            }
            catch (InterruptedException e) {
                logger.error((Object)"switchHa sleep error", (Throwable)e);
            }
        }
        for (MonitorThread monitorThread : monitorThreadList) {
            BasicMonitor monitor = monitorThread.getMonitor();
            if (!(monitor instanceof WinServiceMonitor)) continue;
            ((WinServiceMonitor)monitor).resetThreshold();
            try {
                if (this.currHaPrimary) {
                    monitor.start();
                    break;
                }
                monitor.stop();
            }
            catch (Exception e) {
                logger.error((Object)"error", (Throwable)e);
            }
            break;
        }
        if (this.currHaPrimary) {
            logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(2), "true", new Object[0]));
            this.modifyVsmServer(true);
        }
        logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(12), String.valueOf(Manager.getInstance().isCurrHaPrimary()), new Object[0]));
        if (this.currHaPrimary) {
            this.setLocalHaPrimaryToken(this.getRemoteHaPrimaryToken() + 1);
        }
        if (this.currHaPrimary) {
            this.resetFileMonitor();
        }
        this.setSwitch(false);
    }

    public void resetFileMonitor() {
        for (MonitorThread monitorThread : monitorThreadList) {
            if (!monitorThread.getMonitor().getName().equalsIgnoreCase("file")) continue;
            ((FileMonitor)monitorThread.getMonitor()).resetFileUtil();
            break;
        }
    }

    public void changeFloatIp() {
        for (MonitorThread monitorThread : monitorThreadList) {
            if (!monitorThread.getMonitor().getName().equalsIgnoreCase("netinterface")) continue;
            ((NetInterfaceMonitor)monitorThread.getMonitor()).changeFloatIp();
            break;
        }
    }

    public void checkFloatIp() {
        for (MonitorThread monitorThread : monitorThreadList) {
            if (!monitorThread.getMonitor().getName().equalsIgnoreCase("netinterface")) continue;
            ((NetInterfaceMonitor)monitorThread.getMonitor()).checkFloatIp();
            break;
        }
    }

    public void modifyVsmServer(boolean isFirstTry) {
        for (MonitorThread monitorThread : monitorThreadList) {
            if (!monitorThread.getMonitor().getName().equalsIgnoreCase("haswitch")) continue;
            if (isFirstTry) {
                ((HaSwitchMonitor)monitorThread.getMonitor()).setModifyVsmServerTimes(0);
            }
            this.setModifyingVsmServer(true);
            ((HaSwitchMonitor)monitorThread.getMonitor()).setVsmServerModify(true);
        }
    }

    public List<MonitorInfo> getMonitorInfoList() {
        return monitorInfoList;
    }

    public String getAvailableRemoteIp() {
        return configer.getManageRemoteIp();
    }

    public synchronized BasicMonitor getFirstAction() {
        BasicMonitor action = null;
        if (!actionList.isEmpty()) {
            action = actionList.get(0);
        }
        return action;
    }

    public synchronized void removeFirstAction() {
        if (!actionList.isEmpty()) {
            actionList.remove(0);
        }
    }

    public synchronized void addAction(BasicMonitor action) {
        if (action != null && !actionList.contains(action)) {
            actionList.add(action);
        }
    }

    public String getManageIp() {
        return this.manageIp;
    }

    public void setManageIp(String manageIp) {
        this.manageIp = manageIp;
    }

    public boolean isAutoSwitch() {
        return this.autoSwitch;
    }

    public void setAutoSwitch(boolean autoSwitch) {
        this.autoSwitch = autoSwitch;
    }

    public synchronized void setHaPair(boolean haPair) {
        this.haPair = haPair;
    }

    public synchronized boolean isHaPair() {
        return this.haPair;
    }

    public boolean isHaEnabled() {
        return this.haEnabled;
    }

    public void setHaEnabled(boolean haEnabled) {
        this.haEnabled = haEnabled;
    }

    public synchronized boolean isHaPrimary() {
        return this.haPrimary;
    }

    public synchronized void setHaPrimary(boolean haPrimary) {
        this.haPrimary = haPrimary;
    }

    public boolean isSameRole() {
        return this.isSameRole;
    }

    public void setSameRole(boolean isSameRoleT) {
        this.isSameRole = isSameRoleT;
    }

    public int getLocalHaPrimaryToken() {
        return this.localHaPrimaryToken;
    }

    public void setLocalHaPrimaryToken(int localHaPrimaryToken) {
        this.localHaPrimaryToken = localHaPrimaryToken;
    }

    public int getRemoteHaPrimaryToken() {
        return this.remoteHaPrimaryToken;
    }

    public void setRemoteHaPrimaryToken(int remoteHaPrimaryToken) {
        this.remoteHaPrimaryToken = remoteHaPrimaryToken;
    }

    public long getLocalHaRunDate() {
        return this.localHaRunDate;
    }

    public void setLocalHaRunDate(long localHaRunDate) {
        this.localHaRunDate = localHaRunDate;
    }

    public long getRemoteHaRunDate() {
        return this.remoteHaRunDate;
    }

    public void setRemoteHaRunDate(long remoteHaRunDate) {
        this.remoteHaRunDate = remoteHaRunDate;
    }

    public synchronized boolean isCurrHaPrimary() {
        return this.currHaPrimary;
    }

    public synchronized void setCurrHaPrimary(boolean currHaPrimary) {
        this.currHaPrimary = currHaPrimary;
    }

    public boolean isSwitch() {
        return this.isSwitch;
    }

    public void setSwitch(boolean isSwitchT) {
        this.isSwitch = isSwitchT;
    }

    public synchronized boolean isHaStatusOk() {
        int i;
        boolean isOk = true;
        logger.debug((Object)("---------------Manager.isHaStatusOk.isSwitch=" + this.isSwitch()));
        if (this.isSwitch()) {
            return false;
        }
        logger.debug((Object)("---------------Manager.isHaStatusOk.isModifyingVsmServer=" + this.isModifyingVsmServer()));
        if (this.isModifyingVsmServer()) {
            return false;
        }
        logger.debug((Object)"---------------Manager.actionList");
        logger.debug((Object)("---------------Manager.actionList.size()=" + actionList.size()));
        int actionType = 0;
        for (i = 0; i < actionList.size(); ++i) {
            logger.debug((Object)("---------------Manager.actionList." + i + "=" + actionList.get(i).getName()));
            BasicMonitor monitor = actionList.get(i);
            actionType = monitor.getActionType();
            logger.debug((Object)("---------------Manager.actionList.actionType." + i + "=" + actionType));
            if (actionType != 2 && actionType != 1 && actionType != 3 && actionType != 4) continue;
            isOk = false;
            break;
        }
        logger.debug((Object)"---------------Manager.monitorThreadList");
        logger.debug((Object)("---------------Manager.monitorThreadList.size()=" + monitorThreadList.size()));
        for (i = 0; i < monitorThreadList.size(); ++i) {
            MonitorThread monitorThread = monitorThreadList.get(i);
            logger.debug((Object)("---------------Manager.monitorThreadList." + i + ".getName=" + monitorThread.getName() + ";monitorThread.getMonitor().getFailedTimes()=" + monitorThread.getMonitor().getFailedTimes()));
            if (monitorThread.getName().equals("database") || monitorThread.getName().equals("winservicebase") || monitorThread.getName().equals("netinterface")) {
                if (monitorThread.getMonitor().getFailedTimes() <= 0) continue;
                isOk = false;
                break;
            }
            if (!monitorThread.getName().equalsIgnoreCase("haswitch")) continue;
            logger.debug((Object)("---------------((HaSwitchMonitor) monitorThread.getMonitor()).isSwitch()=" + ((HaSwitchMonitor)monitorThread.getMonitor()).isSwitch()));
            if (!((HaSwitchMonitor)monitorThread.getMonitor()).isSwitch()) continue;
            isOk = false;
            break;
        }
        return isOk;
    }

    public synchronized boolean isInActionList(String monitorName) {
        boolean is = false;
        for (BasicMonitor monitor : actionList) {
            if (!monitor.getName().equalsIgnoreCase(monitorName)) continue;
            is = true;
            break;
        }
        return is;
    }

    public synchronized boolean canBeArranged() {
        int i;
        boolean isOk = true;
        logger.debug((Object)("---------------Manager.isHaStatusOk.isSwitch=" + this.isSwitch()));
        if (this.isSwitch()) {
            return false;
        }
        logger.debug((Object)("---------------Manager.isHaStatusOk.isModifyingVsmServer=" + this.isModifyingVsmServer()));
        if (this.isModifyingVsmServer()) {
            return false;
        }
        logger.debug((Object)"---------------Manager.actionList");
        logger.debug((Object)("---------------Manager.actionList.size()=" + actionList.size()));
        int actionType = 0;
        for (i = 0; i < actionList.size(); ++i) {
            logger.debug((Object)("---------------Manager.actionList." + i + "=" + actionList.get(i).getName()));
            BasicMonitor monitor = actionList.get(i);
            if (monitor.getName().equals("heratbeat")) continue;
            actionType = monitor.getActionType();
            logger.debug((Object)("---------------Manager.actionList.actionType." + i + "=" + actionType));
            if (actionType != 2 && actionType != 1 && actionType != 3 && actionType != 4) continue;
            isOk = false;
            break;
        }
        logger.debug((Object)"---------------Manager.monitorThreadList");
        logger.debug((Object)("---------------Manager.monitorThreadList.size()=" + monitorThreadList.size()));
        for (i = 0; i < monitorThreadList.size(); ++i) {
            MonitorThread monitorThread = monitorThreadList.get(i);
            logger.debug((Object)("---------------Manager.monitorThreadList." + i + ".getName=" + monitorThread.getName() + ";monitorThread.getMonitor().getFailedTimes()=" + monitorThread.getMonitor().getFailedTimes()));
            if (!monitorThread.getName().equalsIgnoreCase("haswitch")) continue;
            logger.debug((Object)("---------------((HaSwitchMonitor) monitorThread.getMonitor()).isSwitch()=" + ((HaSwitchMonitor)monitorThread.getMonitor()).isSwitch()));
            if (!((HaSwitchMonitor)monitorThread.getMonitor()).isSwitch()) continue;
            isOk = false;
            break;
        }
        return isOk;
    }

    public synchronized void deleteFloatIp() {
        try {
            if (Configer.getInstance().isFloatIP()) {
                String deleteCmd = "";
                deleteCmd = AticInstallUtil.getInstance().getAticInstallOS() == 1 ? "sudo ifconfig " + Configer.getInstance().getFloatInterface() + ":flo " + Configer.getInstance().getFloatIP() + " down" : "netsh interface ip delete address name=\"" + Configer.getInstance().getFloatInterface() + "\" addr=" + Configer.getInstance().getFloatIP();
                CmdUtil.execCmd(deleteCmd);
            }
        }
        catch (IOException e) {
            logger.error((Object)"delete float ip error", (Throwable)e);
        }
    }
}

