/*
 * Decompiled with CFR 0.152.
 */
package com.hs.ha;

import com.hs.atic.rmi.ClientSocketFactory;
import com.hs.atic.rmi.DualHostSwitchService;
import com.hs.ha.Configer;
import com.hs.ha.HaRmi;
import com.hs.ha.LogManager;
import com.hs.ha.LogUtil;
import com.hs.ha.rmi.PairMessageService;
import com.hs.ha.vo.MonitorInfo;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class RmiServiceUtil {
    private static Logger logger = LogManager.getInstance().getHaLog();

    public static PairMessageService getPairMessageService() throws RemoteException, NotBoundException {
        if (HaRmi.getInstance().getMessageRmiConfig() == null) {
            return null;
        }
        String remoteIp = HaRmi.getInstance().getMessageRmiConfig().getRemoteIp();
        String remotePort = String.valueOf(HaRmi.getInstance().getMessageRmiConfig().getPort());
        return RmiServiceUtil.getPairMessageService(remoteIp, remotePort);
    }

    public static PairMessageService getPairMessageService(String remoteIp, String remotePort) throws RemoteException, NotBoundException {
        PairMessageService messageService = null;
        int port = Integer.parseInt(remotePort);
        Registry registry = LocateRegistry.getRegistry(remoteIp, port);
        try {
            messageService = (PairMessageService)registry.lookup("messageService");
        }
        catch (Exception e) {
            return null;
        }
        return messageService;
    }

    public static String sendPairHeartbeat(String remoteIp, String port) throws RemoteException, NotBoundException {
        PairMessageService messageService = RmiServiceUtil.getPairMessageService(remoteIp, port);
        if (null != messageService) {
            return messageService.sendHeartbeat(remoteIp);
        }
        return "";
    }

    public static List<MonitorInfo> getPairMonitorInfoList() throws Exception {
        List<MonitorInfo> monifoInfoList = new Vector<MonitorInfo>();
        PairMessageService messageService = RmiServiceUtil.getPairMessageService();
        if (messageService != null) {
            monifoInfoList = messageService.getMonitorInfoList();
        }
        return monifoInfoList;
    }

    public static boolean notifyHaSwitch() {
        boolean result = false;
        try {
            PairMessageService messageService = RmiServiceUtil.getPairMessageService();
            result = messageService.notifyHaSwitch();
        }
        catch (RemoteException e) {
            logger.error((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(4), "failure", new Object[0]));
        }
        catch (NotBoundException e) {
            logger.error((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(5), "failure", new Object[0]));
        }
        catch (RuntimeException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        return result;
    }

    public static boolean notifyHaStart() {
        boolean result = false;
        try {
            PairMessageService messageService = RmiServiceUtil.getPairMessageService();
            messageService.notifyHaStart();
            result = true;
        }
        catch (RemoteException e) {
            logger.error((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(4), "failure", new Object[0]));
        }
        catch (NotBoundException e) {
            logger.error((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(5), "failure", new Object[0]));
        }
        catch (RuntimeException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        return result;
    }

    public static boolean notifyHaStop() {
        boolean result = false;
        try {
            PairMessageService messageService = RmiServiceUtil.getPairMessageService();
            messageService.notifyHaStop();
            result = true;
        }
        catch (RemoteException e) {
            logger.error((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(6), "failure", new Object[0]));
        }
        catch (NotBoundException e) {
            logger.error((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(7), "failure", new Object[0]));
        }
        catch (RuntimeException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        return result;
    }

    public static DualHostSwitchService getVSMDualHostSwitchService() throws Exception {
        int vsmRmiPort;
        String vsmRmiIp = Configer.getInstance().getManageLocalIp();
        Registry registry = RmiServiceUtil.getSSLRegistry(vsmRmiIp, vsmRmiPort = 11098);
        if (null == registry) {
            logger.error((Object)("getVSMDualHostSwitchService error, registry is null, vsmRmiIp=" + vsmRmiIp + ", vsmRmiPort=" + vsmRmiPort));
            return null;
        }
        DualHostSwitchService dualHostSwitchService = (DualHostSwitchService)registry.lookup("DualHostSwitchService");
        if (null == dualHostSwitchService) {
            logger.error((Object)("getVSMDualHostSwitchService error, dualHostSwitchService is null, vsmRmiIp=" + vsmRmiIp + ", vsmRmiPort=" + vsmRmiPort));
            return null;
        }
        return dualHostSwitchService;
    }

    public static boolean isHaStatusOk() {
        boolean result = false;
        try {
            PairMessageService messageService = RmiServiceUtil.getPairMessageService();
            if (messageService == null) {
                return false;
            }
            result = messageService.isHaStatusOk();
        }
        catch (AccessException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        catch (RemoteException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        catch (NotBoundException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        return result;
    }

    public static Registry getSSLRegistry(String vsmRmiIp, int port) {
        System.setProperty("javax.net.ssl.trustStore", "keystore");
        System.setProperty("javax.net.ssl.trustStorePassword", "Admin@123");
        System.setProperty("javax.net.ssl.keyStore", "keystore");
        System.setProperty("javax.net.ssl.keyStorePassword", "Admin@123");
        Registry registry = null;
        try {
            ClientSocketFactory csf = new ClientSocketFactory(true);
            registry = LocateRegistry.getRegistry(vsmRmiIp, port, csf);
        }
        catch (Exception e) {
            logger.error((Object)("vsmRmiIp:" + vsmRmiIp + ", Regist failed !"), (Throwable)e);
            registry = null;
        }
        return registry;
    }
}

