/*
 * Decompiled with CFR 0.152.
 */
package com.hs.ha.monitor;

import com.hs.ha.Configer;
import com.hs.ha.LogManager;
import com.hs.ha.LogUtil;
import com.hs.ha.Manager;
import com.hs.ha.vo.MonitorInfo;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public abstract class BasicMonitor {
    public static final int NOACTION = 0;
    public static final int RESTART = 1;
    public static final int REBOOT = 2;
    public static final int SWITCH = 3;
    public static final int VSM_SERVER_MODIFY = 4;
    public static final int HA_PRIMARY_ARRANGE = 5;
    public static final int MAX_INDEX = 100;
    public static final int MIN_INDEX = 0;
    protected static final Logger LOGGER = LogManager.getInstance().getHaLog();
    protected List<MonitorInfo> monitorInfoList = new Vector<MonitorInfo>();
    private String name;
    private int cycle = 5000;
    private int maxFailedTimes = 3;
    private int monitorThreshold = 50;
    private int failedTimes = 0;

    public abstract void start() throws Exception;

    public abstract void stop() throws Exception;

    protected abstract int monitorHaIndex();

    public abstract int getActionType();

    public void setFailedTimes(int failedTimes) {
        this.failedTimes = failedTimes;
    }

    public void monitor() {
        if (Manager.getInstance().isInActionList(this.getName())) {
            return;
        }
        int haIndex = this.monitorHaIndex();
        if (haIndex < this.monitorThreshold) {
            ++this.failedTimes;
            LOGGER.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(8), String.valueOf(this.failedTimes), this.getName(), this.failedTimes));
        } else {
            this.clearFailedTimes();
        }
    }

    public void restart() throws Exception {
        if (this.failedTimes > 0) {
            this.stop();
            this.clearFailedTimes();
            this.start();
        }
    }

    public void clearFailedTimes() {
        this.failedTimes = 0;
    }

    public int getFailedTimes() {
        return this.failedTimes;
    }

    public void setCycle(int cycle) {
        this.cycle = cycle;
    }

    public int getCycle() {
        return this.cycle;
    }

    public void setMaxFaileTimes(int maxFailes) {
        if (maxFailes > 0) {
            this.maxFailedTimes = maxFailes;
        }
    }

    public int getMaxFaileTimes() {
        return this.maxFailedTimes;
    }

    public void setMonitorThreshold(int monitorThreshold) {
        if (monitorThreshold > 0 && monitorThreshold <= 100) {
            this.monitorThreshold = monitorThreshold;
        }
    }

    public int getMonitorThreshold() {
        return this.monitorThreshold;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void addMonitorInfo(MonitorInfo monitorInfo) {
        this.monitorInfoList.add(monitorInfo);
    }

    public List<MonitorInfo> getMonitorInfoList() {
        return this.monitorInfoList;
    }
}

