/*
 * Decompiled with CFR 0.152.
 */
package com.hs.ha.monitor;

import com.hs.ha.Configer;
import com.hs.ha.LogManager;
import com.hs.ha.LogUtil;
import com.hs.ha.Manager;
import com.hs.ha.RmiServiceUtil;
import com.hs.ha.XmlUtil;
import com.hs.ha.monitor.BasicMonitor;
import com.hs.ha.monitor.FileUtil;
import com.hs.ha.vo.MonitorInfo;
import java.io.IOException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class FileMonitor
extends BasicMonitor {
    private static final int PRIMARY_FILE_THRESHOLD = 1;
    private static final int STANDBY_FILE_THRESHOLD = 2;
    private static Logger logger = LogManager.getInstance().getHaLog();
    ArrayList<FileUtil> rootList = new ArrayList();

    public FileMonitor() {
        this.setName("file");
        this.initThreshold();
    }

    public ArrayList<FileUtil> getRootList() {
        return this.rootList;
    }

    public void addFileUtil(FileUtil fileUtil) {
        this.rootList.add(fileUtil);
    }

    private void initThreshold() {
        if (Manager.getInstance().isCurrHaPrimary()) {
            this.setMonitorThreshold(1);
        } else {
            this.setMonitorThreshold(2);
        }
    }

    @Override
    public int monitorHaIndex() {
        return this.checkFile();
    }

    @Override
    public void start() throws Exception {
    }

    @Override
    public void stop() throws Exception {
    }

    public void deleteHaTempFilesAtBeginning() {
        for (FileUtil fileUtil : this.rootList) {
            fileUtil.deleteCurrentFolderHaTempFiles(fileUtil.getRootpath());
        }
    }

    private int checkFile() {
        int index = 100;
        try {
            MonitorInfo monitorInfo;
            if (!Manager.getInstance().isHaPair()) {
                return index;
            }
            for (int i = 0; i < this.monitorInfoList.size(); ++i) {
                monitorInfo = (MonitorInfo)this.monitorInfoList.get(i);
                monitorInfo.setLocalStatus("up");
            }
            block5: for (FileUtil fileUtil : this.rootList) {
                if (fileUtil.isDeleting() || fileUtil.isSending()) break;
                boolean checkFileStatus = Manager.getInstance().isCurrHaPrimary() ? fileUtil.readAllFilesInfo() : fileUtil.checkFileDirectory();
                logger.info((Object)("checkFile rootPath" + fileUtil.getRootpath() + " checkFileStatus " + checkFileStatus));
                if (checkFileStatus) {
                    if (!Manager.getInstance().isCurrHaPrimary()) continue;
                    fileUtil.compareDeleteFilesInfo();
                    fileUtil.compareSendFilesInfo();
                    continue;
                }
                for (int i = 0; i < this.monitorInfoList.size(); ++i) {
                    monitorInfo = (MonitorInfo)this.monitorInfoList.get(i);
                    if (!monitorInfo.getLocalConfig().equals(fileUtil.getRootpath())) continue;
                    monitorInfo.setLocalStatus("down");
                    continue block5;
                }
            }
            if (Manager.getInstance().isCurrHaPrimary()) {
                for (FileUtil fileUtil : this.rootList) {
                    if (fileUtil.isDeleting() || RmiServiceUtil.getPairMessageService().isDeleteFile(fileUtil.getRootpath())) continue;
                    if (fileUtil.getDeleteFileMapSize() > 0) {
                        logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(44), "running", fileUtil.getRootpath()));
                        fileUtil.deleteFiles();
                        logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(44), "over", fileUtil.getRootpath()));
                        break;
                    }
                    if (fileUtil.isSending() || RmiServiceUtil.getPairMessageService().isSendFile(fileUtil.getRootpath())) continue;
                    if (fileUtil.getSendFileMapSize() > 0) {
                        logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(27), "running", fileUtil.getRootpath()));
                        fileUtil.sendFiles();
                        logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(27), "over", fileUtil.getRootpath()));
                    }
                    if (fileUtil.getFailedFileMapSize() <= 0) continue;
                    logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(32), "running", fileUtil.getRootpath()));
                    fileUtil.resendFailedFiles();
                    logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(32), "over", fileUtil.getRootpath()));
                }
                Map<String, String> keystorePassMap = XmlUtil.getTomcatKeystorePass();
                RmiServiceUtil.getPairMessageService().modifyTomcatKeystorePass(keystorePassMap.get("keystorePass1"), keystorePassMap.get("keystorePass2"));
                Map<String, String> dbPwdMap = XmlUtil.getInstallXmlPwd();
                RmiServiceUtil.getPairMessageService().modifyRemoteInstallXml(dbPwdMap.get("legoDbPwd"), dbPwdMap.get("eSightDbPwd"));
            }
        }
        catch (RemoteException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        catch (NotBoundException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        return index;
    }

    @Override
    public int getActionType() {
        return 0;
    }

    public void resetFileUtil() {
        if (!Manager.getInstance().isHaPair() || !Manager.getInstance().isCurrHaPrimary()) {
            return;
        }
        for (FileUtil fileUtil : this.rootList) {
            fileUtil.resetLocalFileUtilRemoteFileMap();
        }
    }
}

