/*
 * Decompiled with CFR 0.152.
 */
package com.hs.ha.monitor;

import com.hs.ha.AticInstallUtil;
import com.hs.ha.Configer;
import com.hs.ha.LogManager;
import com.hs.ha.LogUtil;
import com.hs.ha.RmiServiceUtil;
import com.hs.ha.monitor.FileInfo;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.rmi.AccessException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class FileUtil {
    public static final String FILE_TYPE = "file";
    public static final String DOCUMENT_TYPE = "document";
    public static final String POSTFIX = ".ha!";
    private static Logger logger = LogManager.getInstance().getHaLog();
    private static final int SEND_MARK_RUNNING = 0;
    private static final int SEND_MARK_OVER = 1;
    private static final int MAX_READ_BYTE = 1024;
    private static final int MAX_BYTE = 0x100000;
    private String rootpath;
    private boolean isLocalExist = false;
    private boolean isRemoteExist = false;
    private Map<String, FileInfo> lastLocalFileMap = new HashMap<String, FileInfo>();
    private Map<String, FileInfo> localFileMap = new HashMap<String, FileInfo>();
    private Map<String, FileInfo> remoteFileMap = new HashMap<String, FileInfo>();
    private Map<String, FileInfo> deleteFileMap = new HashMap<String, FileInfo>();
    private Map<String, FileInfo> sendFileMap = new HashMap<String, FileInfo>();
    private Map<String, FileInfo> failedFileMap = new HashMap<String, FileInfo>();
    private FileInfo notCompleteFile = new FileInfo();
    private boolean isDeleting = false;
    private boolean isSending = false;

    public FileUtil(String rootpath) {
        this.rootpath = rootpath;
    }

    public boolean isLocalExist() {
        return this.isLocalExist;
    }

    public boolean isRemoteExist() {
        return this.isRemoteExist;
    }

    public String getRootpath() {
        return this.rootpath;
    }

    public Map<String, FileInfo> getLastLocalFileMap() {
        return this.lastLocalFileMap;
    }

    public Map<String, FileInfo> getLocalFileMap() {
        return this.readCurrentFolderFilesInfoMap(this.rootpath);
    }

    public boolean isDeleting() {
        return this.isDeleting;
    }

    public boolean isSending() {
        return this.isSending;
    }

    public void resetLocalFileUtilRemoteFileMap() {
        this.remoteFileMap = new HashMap<String, FileInfo>();
        this.setRemoteFileUtilRemoteFileMap();
    }

    public boolean setRemoteFileUtilRemoteFileMap() {
        boolean is = true;
        try {
            this.remoteFileMap = new HashMap<String, FileInfo>();
            if (this.rootpath != null) {
                if (RmiServiceUtil.getPairMessageService() != null) {
                    Map<String, FileInfo> tempFileMap = RmiServiceUtil.getPairMessageService().getRemoteFileMap(this.rootpath);
                    if (tempFileMap == null) {
                        is = false;
                        logger.debug((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(31), "failure", this.rootpath));
                        return is;
                    }
                    if (tempFileMap.size() > 0) {
                        this.remoteFileMap.putAll(tempFileMap);
                    }
                    is = true;
                    logger.debug((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(31), "success", this.rootpath));
                } else {
                    is = false;
                    logger.debug((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(31), "failure", this.rootpath));
                }
            }
        }
        catch (AccessException e) {
            logger.info((Object)("AccessException error " + e));
            is = false;
        }
        catch (RemoteException e) {
            logger.info((Object)("RemoteException error " + e));
            is = false;
        }
        catch (NotBoundException e) {
            logger.info((Object)("RemoteException error " + e));
            is = false;
        }
        catch (Exception e) {
            logger.info((Object)("Exception error fail " + e));
            is = false;
        }
        return is;
    }

    public boolean readAllFilesInfo() {
        boolean is = false;
        if (this.deleteFileMap.size() == 0) {
            this.lastLocalFileMap = new HashMap<String, FileInfo>();
            this.lastLocalFileMap.putAll(this.localFileMap);
        }
        this.localFileMap = new HashMap<String, FileInfo>();
        this.isLocalExist = this.readCurrentFolderFilesInfo(this.rootpath);
        if (this.isLocalExist) {
            logger.debug((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(25), "success", this.rootpath));
        } else {
            logger.debug((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(25), "failure", this.rootpath));
        }
        this.isRemoteExist = this.setRemoteFileUtilRemoteFileMap();
        if (this.isLocalExist && this.isRemoteExist) {
            is = true;
        }
        return is;
    }

    public boolean checkFileDirectory() {
        boolean is = false;
        this.isLocalExist = this.checkCurrentFile(this.rootpath);
        if (this.isLocalExist && this.checkRemoteFile()) {
            is = true;
        }
        return is;
    }

    public boolean checkCurrentFile(String path) {
        boolean is = false;
        File file = new File(path);
        if (file.exists()) {
            if (file.isDirectory()) {
                is = true;
            }
        } else {
            is = false;
            logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(26), "failure", path));
        }
        return is;
    }

    private boolean checkRemoteFile() {
        boolean is = false;
        try {
            if (this.rootpath != null && RmiServiceUtil.getPairMessageService() != null) {
                return RmiServiceUtil.getPairMessageService().remoteFileDirectoryExist(this.rootpath);
            }
        }
        catch (RemoteException e) {
            logger.info((Object)("RemoteException error fail " + e));
        }
        catch (NotBoundException e) {
            logger.info((Object)("NotBoundException error fail " + e));
        }
        catch (Exception e) {
            logger.info((Object)("Exception error fail " + e));
        }
        return is;
    }

    public void compareDeleteFilesInfo() {
        if (this.deleteFileMap.size() > 0) {
            return;
        }
        for (Map.Entry<String, FileInfo> last : this.lastLocalFileMap.entrySet()) {
            if (this.localFileMap.get(last.getKey()) != null) continue;
            this.deleteFileMap.put(last.getKey(), last.getValue());
        }
        if (this.deleteFileMap.size() > 0) {
            this.lastLocalFileMap = new HashMap<String, FileInfo>();
        }
    }

    private boolean readCurrentFolderFilesInfo(String path) {
        boolean is = false;
        File filedir = new File(path);
        if (filedir.isDirectory()) {
            File[] farray = filedir.listFiles();
            String key = "";
            if (null != farray && farray.length > 0) {
                for (File f : farray) {
                    FileInfo fi = new FileInfo();
                    if (f.getName().indexOf(POSTFIX) >= 0 && f.getName().substring(f.getName().lastIndexOf(POSTFIX), f.getName().length()).equals(POSTFIX)) continue;
                    fi.setName(f.getName());
                    fi.setParent(f.getParent());
                    fi.setPath(path);
                    fi.setModifyDate(f.lastModified());
                    if (f.isDirectory()) {
                        fi.setType(DOCUMENT_TYPE);
                        key = DOCUMENT_TYPE + fi.getName() + "_" + fi.getPath();
                        this.localFileMap.put(key, fi);
                        this.readCurrentFolderFilesInfo(f.getPath() + System.getProperty("file.separator"));
                        continue;
                    }
                    fi.setType(FILE_TYPE);
                    key = FILE_TYPE + fi.getName() + "_" + fi.getPath();
                    this.localFileMap.put(key, fi);
                }
            }
            is = true;
        } else {
            is = false;
            logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(26), "failure", path));
        }
        return is;
    }

    private Map<String, FileInfo> readCurrentFolderFilesInfoMap(String path) {
        HashMap<String, FileInfo> tempMap = new HashMap<String, FileInfo>();
        File filedir = new File(path);
        if (filedir.isDirectory()) {
            File[] farray = filedir.listFiles();
            if (null != farray) {
                String key = "";
                for (File f : farray) {
                    FileInfo fi = new FileInfo();
                    if (f.getName().indexOf(POSTFIX) >= 0 && f.getName().substring(f.getName().lastIndexOf(POSTFIX), f.getName().length()).equals(POSTFIX)) continue;
                    fi.setName(f.getName());
                    fi.setParent(f.getParent());
                    fi.setPath(path);
                    fi.setModifyDate(f.lastModified());
                    if (f.isDirectory()) {
                        fi.setType(DOCUMENT_TYPE);
                        key = DOCUMENT_TYPE + fi.getName() + "_" + fi.getPath();
                        this.remoteFileMap.put(key, fi);
                        this.readCurrentFolderFilesInfoMap(f.getPath() + System.getProperty("file.separator"));
                        continue;
                    }
                    fi.setType(FILE_TYPE);
                    key = FILE_TYPE + fi.getName() + "_" + fi.getPath();
                    tempMap.put(key, fi);
                }
            }
        } else {
            logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(26), "failure", path));
        }
        return tempMap;
    }

    public void deleteCurrentFolderHaTempFiles(String path) {
        File filedir = new File(path);
        if (filedir.isDirectory()) {
            File[] farray = filedir.listFiles();
            if (null != farray) {
                for (File f : farray) {
                    if (f.isDirectory()) {
                        this.deleteCurrentFolderHaTempFiles(f.getPath() + System.getProperty("file.separator"));
                        continue;
                    }
                    if (f.getName().indexOf(POSTFIX) < 0 || !f.getName().substring(f.getName().lastIndexOf(POSTFIX), f.getName().length()).equals(POSTFIX)) continue;
                    if (f.delete()) {
                        logger.debug((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(41), "success", f.getName()));
                        continue;
                    }
                    logger.debug((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(41), "failure", f.getName()));
                }
            }
            logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(39), "success", path));
        } else {
            logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(39), "failure", path));
        }
    }

    public void compareSendFilesInfo() {
        if (this.deleteFileMap.size() > 0) {
            return;
        }
        this.sendFileMap = new HashMap<String, FileInfo>();
        for (Map.Entry<String, FileInfo> local : this.localFileMap.entrySet()) {
            if (local.getKey().contains("Tomcat6" + File.separator + "Lego-UI-Plat" + File.separator + "WEB-INF" + File.separator + "lib") || local.getKey().contains("components" + File.separator + "antiddos_collector" + File.separator + "conf") && local.getKey().contains("collector_service_ip")) continue;
            FileInfo localFile = local.getValue();
            FileInfo remoteFile = this.remoteFileMap.get(local.getKey());
            if (null != remoteFile) {
                if (remoteFile.getModifyDate() != localFile.getModifyDate()) {
                    if (localFile.getName().equals("db.conf") && localFile.getPath().contains("antiddos_collector" + File.separator + "conf")) {
                        this.sendFileMap.put(local.getKey(), localFile);
                        remoteFile.setModifyDate(localFile.getModifyDate());
                        continue;
                    }
                    if (localFile.getName().equals("jdbc.properties") && localFile.getPath().contains("LegoRuntime" + File.separator + "conf")) {
                        this.sendFileMap.put(local.getKey(), localFile);
                        remoteFile.setModifyDate(localFile.getModifyDate());
                        continue;
                    }
                    if ((localFile.getName().equals("keystore.txt") || localFile.getName().equals("keystorebackup.txt") || localFile.getName().equals("kkeeyystore.txt") || localFile.getName().equals("kkeeyystorebackup.txt")) && localFile.getPath().contains("bin" + File.separator + "etc" + File.separator + "config" + File.separator + "sdp")) {
                        this.sendFileMap.put(local.getKey(), localFile);
                        remoteFile.setModifyDate(localFile.getModifyDate());
                        continue;
                    }
                    if ((localFile.getName().equals("kkeeyystore.txt") || localFile.getName().equals("kkeeyystorebackup.txt")) && localFile.getPath().contains(File.separator + "components" + File.separator + "common" + File.separator + "sdp")) {
                        this.sendFileMap.put(local.getKey(), localFile);
                        remoteFile.setModifyDate(localFile.getModifyDate());
                        continue;
                    }
                    if (localFile.getName().equals("sgipConf.properties") && localFile.getPath().contains("LegoRuntime" + File.separator + "spconfig" + File.separator + "sgip")) {
                        this.sendFileMap.put(local.getKey(), localFile);
                        remoteFile.setModifyDate(localFile.getModifyDate());
                        continue;
                    }
                }
                if (remoteFile.getModifyDate() >= localFile.getModifyDate()) continue;
                this.sendFileMap.put(local.getKey(), localFile);
                remoteFile.setModifyDate(localFile.getModifyDate());
                continue;
            }
            this.remoteFileMap.put(local.getKey(), local.getValue());
            this.sendFileMap.put(local.getKey(), local.getValue());
        }
    }

    public void deleteFiles() {
        this.isDeleting = true;
        try {
            if (RmiServiceUtil.getPairMessageService() == null) {
                this.isDeleting = false;
                return;
            }
        }
        catch (RemoteException e2) {
            this.isDeleting = false;
            return;
        }
        catch (NotBoundException e2) {
            this.isDeleting = false;
            return;
        }
        try {
            Map<String, FileInfo> falseDeleteFileMap = RmiServiceUtil.getPairMessageService().deleteFiles(this.rootpath, this.deleteFileMap);
            if (falseDeleteFileMap.size() == 0) {
                this.deleteFileMap = new HashMap<String, FileInfo>();
                logger.debug((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(43), "success", String.valueOf(this.deleteFileMap.size()), this.rootpath));
            } else {
                this.deleteFileMap = new HashMap<String, FileInfo>();
                this.deleteFileMap.putAll(falseDeleteFileMap);
                logger.debug((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(43), "success", String.valueOf(this.deleteFileMap.size() - falseDeleteFileMap.size()), this.rootpath));
                logger.debug((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(43), "failure", falseDeleteFileMap.size(), this.rootpath));
            }
        }
        catch (AccessException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        catch (RemoteException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        catch (NotBoundException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        this.isDeleting = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendFiles() throws IOException {
        this.isSending = true;
        try {
            if (RmiServiceUtil.getPairMessageService() == null) {
                this.isSending = false;
                return;
            }
        }
        catch (RemoteException e2) {
            this.isSending = false;
            return;
        }
        catch (NotBoundException e2) {
            this.isSending = false;
            return;
        }
        boolean isRecived = false;
        String tempFileName = "";
        for (Map.Entry<String, FileInfo> sendMap : this.sendFileMap.entrySet()) {
            FileInfo send = sendMap.getValue();
            FileInputStream fis = null;
            try {
                if (send.getType().endsWith(DOCUMENT_TYPE)) {
                    RmiServiceUtil.getPairMessageService().makeDir(send.getPath(), send.getName(), send.getModifyDate());
                    continue;
                }
                fis = new FileInputStream(send.getPath() + send.getName());
                tempFileName = send.getName() + POSTFIX;
                if (!RmiServiceUtil.getPairMessageService().makeFile(send.getPath(), tempFileName, send.getModifyDate())) continue;
                byte[] b = new byte[1024];
                ArrayList<Object> streamByte = new ArrayList<byte[]>();
                int endLength = 1024;
                int len = 0;
                RmiServiceUtil.getPairMessageService().markFile(send.getPath(), tempFileName, 0, 0L);
                while ((len = fis.read(b)) != -1) {
                    if (len < 1024) {
                        endLength = len;
                    }
                    streamByte.add((byte[])b.clone());
                    if (streamByte.size() != 1024) continue;
                    isRecived = RmiServiceUtil.getPairMessageService().sendFileByte(send.getPath(), tempFileName, streamByte, endLength);
                    if (!isRecived) {
                        this.failedFileMap.put(sendMap.getKey(), send);
                        break;
                    }
                    streamByte = new ArrayList();
                }
                if (!(isRecived = RmiServiceUtil.getPairMessageService().sendFileByte(send.getPath(), tempFileName, streamByte, endLength))) {
                    this.failedFileMap.put(sendMap.getKey(), send);
                } else {
                    RmiServiceUtil.getPairMessageService().markFile(send.getPath(), tempFileName, 1, send.getModifyDate());
                }
                fis.close();
            }
            catch (FileNotFoundException e) {
                this.failedFileMap.put(sendMap.getKey(), send);
            }
            catch (IOException e) {
                this.failedFileMap.put(sendMap.getKey(), send);
            }
            catch (NotBoundException e) {
                this.failedFileMap.put(sendMap.getKey(), send);
            }
            finally {
                if (null == fis) continue;
                fis.close();
            }
        }
        this.isSending = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resendFailedFiles() throws IOException {
        this.isSending = true;
        try {
            if (RmiServiceUtil.getPairMessageService() == null) {
                this.isSending = false;
                return;
            }
        }
        catch (RemoteException e) {
            this.isSending = false;
            return;
        }
        catch (NotBoundException e) {
            this.isSending = false;
            return;
        }
        boolean isRecived = false;
        String tempFileName = "";
        HashMap<String, FileInfo> tempFileMap = new HashMap<String, FileInfo>(this.failedFileMap);
        for (Map.Entry sendMap : tempFileMap.entrySet()) {
            FileInfo send = (FileInfo)sendMap.getValue();
            FileInputStream fis = null;
            try {
                if (send.getType().endsWith(DOCUMENT_TYPE)) {
                    RmiServiceUtil.getPairMessageService().makeDir(send.getPath(), send.getName(), send.getModifyDate());
                    continue;
                }
                fis = new FileInputStream(send.getPath() + send.getName());
                tempFileName = send.getName() + POSTFIX;
                if (!RmiServiceUtil.getPairMessageService().makeFile(send.getPath(), tempFileName, send.getModifyDate())) continue;
                byte[] b = new byte[1024];
                ArrayList<Object> streamByte = new ArrayList<byte[]>();
                int endLength = 1024;
                int len = 0;
                RmiServiceUtil.getPairMessageService().markFile(send.getPath(), tempFileName, 0, 0L);
                while ((len = fis.read(b)) != -1) {
                    if (len < 1024) {
                        endLength = len;
                    }
                    streamByte.add((byte[])b.clone());
                    if (streamByte.size() != 1024) continue;
                    isRecived = RmiServiceUtil.getPairMessageService().sendFileByte(send.getPath(), tempFileName, streamByte, endLength);
                    if (!isRecived) break;
                    streamByte = new ArrayList();
                }
                if (!(isRecived = RmiServiceUtil.getPairMessageService().sendFileByte(send.getPath(), tempFileName, streamByte, endLength))) continue;
                RmiServiceUtil.getPairMessageService().markFile(send.getPath(), tempFileName, 1, send.getModifyDate());
                this.failedFileMap.remove(sendMap.getKey());
            }
            catch (FileNotFoundException e) {
                if (this.isFileExist(send.getName(), send.getPath())) continue;
                this.failedFileMap.remove(sendMap.getKey());
            }
            catch (IOException e) {
                logger.error((Object)"error", (Throwable)e);
            }
            catch (NotBoundException e) {
                logger.error((Object)"error", (Throwable)e);
            }
            finally {
                if (null == fis) continue;
                fis.close();
            }
        }
        this.isSending = false;
    }

    private boolean isFileExist(String fileName, String path) {
        File[] farray;
        boolean is = false;
        File filedir = new File(path);
        if (filedir.isDirectory() && null != (farray = filedir.listFiles())) {
            for (File f : farray) {
                if (!f.getName().equalsIgnoreCase(fileName)) continue;
                is = true;
                break;
            }
        }
        return is;
    }

    public boolean markAcceptFile(String name, String path, int mark, long modifyDate) {
        File file;
        boolean is = false;
        if (this.notCompleteFile.getName() != null && this.notCompleteFile.getName().equalsIgnoreCase(name) && this.notCompleteFile.getPath() != null && this.notCompleteFile.getPath().equalsIgnoreCase(path)) {
            is = true;
            if (mark == 1) {
                file = new File(path + name);
                File dest = new File(path + name.substring(0, name.lastIndexOf(POSTFIX)));
                if (dest.setLastModified(modifyDate)) {
                    logger.debug((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(40), "success", dest.getName()));
                }
                if (file.setLastModified(modifyDate)) {
                    logger.debug((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(40), "success", file.getName()));
                }
                String lastName = file.getName();
                if (file.renameTo(dest)) {
                    logger.debug((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(42), "success", lastName, dest.getName()));
                }
                this.notCompleteFile = new FileInfo();
            }
        }
        if (!is) {
            if (this.notCompleteFile.getName() != null && this.notCompleteFile.getPath() != null) {
                file = new File(this.notCompleteFile.getPath() + this.notCompleteFile.getName());
                if (file.exists()) {
                    is = file.delete();
                }
                try {
                    RmiServiceUtil.getPairMessageService().resendFile(this.notCompleteFile.getPath(), this.notCompleteFile.getName());
                }
                catch (RemoteException e) {
                    logger.error((Object)"error", (Throwable)e);
                }
                catch (NotBoundException e) {
                    logger.error((Object)"error", (Throwable)e);
                }
            }
            this.notCompleteFile = new FileInfo();
            this.notCompleteFile.setName(name);
            this.notCompleteFile.setPath(path);
            this.notCompleteFile.setMark(mark);
            is = true;
        }
        return is;
    }

    public void resendAFile(String name, String path) {
        FileInfo resend = new FileInfo();
        resend.setName(name);
        resend.setPath(path);
        resend.setType(FILE_TYPE);
        String key = FILE_TYPE + name + "_" + path;
        this.failedFileMap.put(key, resend);
    }

    public void isInList(FileUtil fileUtil, ArrayList<FileUtil> fileList) {
    }

    public int getSendFileMapSize() {
        return this.sendFileMap.size();
    }

    public int getFailedFileMapSize() {
        return this.failedFileMap.size();
    }

    public int getDeleteFileMapSize() {
        return this.deleteFileMap.size();
    }

    public String toString() {
        return "FileUtil [rootpath=" + this.rootpath + ", isLocalExist=" + this.isLocalExist + ", isRemoteExist=" + this.isRemoteExist + ", lastLocalFileMap=" + this.lastLocalFileMap + ", localFileMap=" + this.localFileMap + ", remoteFileMap=" + this.remoteFileMap + ", deleteFileMap=" + this.deleteFileMap + ", sendFileMap=" + this.sendFileMap + ", failedFileMap=" + this.failedFileMap + ", notCompleteFile=" + this.notCompleteFile + ", isDeleting=" + this.isDeleting + ", isSending=" + this.isSending + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean modifyRemoteCollectorIp() {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            String installPath = AticInstallUtil.getInstance().getInstallPath();
            File aticServiceIpPath = new File(installPath + "/components/atic/conf/atic_service_ip");
            if (!aticServiceIpPath.exists()) {
                boolean bl = false;
                return bl;
            }
            File collectorIpPath = new File(installPath + "/components/antiddos_collector/conf/collector_service_ip");
            in = new FileInputStream(aticServiceIpPath);
            out = new FileOutputStream(collectorIpPath);
            byte[] temp = new byte[1024];
            int length = 0;
            while ((length = in.read(temp)) != -1) {
                out.write(temp, 0, length);
            }
            FileUtil.closeIn(in);
        }
        catch (IOException e) {
            logger.error((Object)"error", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            FileUtil.closeIn(in);
            FileUtil.closeOut(out);
        }
        FileUtil.closeOut(out);
        return true;
    }

    private static void closeOut(OutputStream out) {
        if (null != out) {
            try {
                out.close();
            }
            catch (IOException e) {
                logger.error((Object)"error", (Throwable)e);
            }
        }
    }

    private static void closeIn(InputStream in) {
        if (null != in) {
            try {
                in.close();
            }
            catch (IOException e) {
                logger.error((Object)"error", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void modifyAticWebIp(String floatIP) {
        String csn = Charset.defaultCharset().name();
        BufferedWriter bw = null;
        OutputStreamWriter osw = null;
        FileOutputStream fos = null;
        try {
            String path = AticInstallUtil.getInstance().getInstallPath() + "/components/atic/conf/atic_web_ip";
            fos = new FileOutputStream(path);
            osw = new OutputStreamWriter((OutputStream)fos, csn);
            bw = new BufferedWriter(osw);
            if (!floatIP.isEmpty()) {
                bw.write(floatIP);
            }
        }
        catch (IOException e) {
            logger.error((Object)"error", (Throwable)e);
        }
        finally {
            try {
                if (null != bw) {
                    bw.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"error", (Throwable)e);
            }
            if (null != osw) {
                try {
                    osw.close();
                }
                catch (IOException e) {
                    logger.error((Object)"error", (Throwable)e);
                }
            }
            if (null != fos) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    logger.error((Object)"error", (Throwable)e);
                }
            }
        }
    }
}

