/*
 * Decompiled with CFR 0.152.
 */
package com.hs.ha.rmi.impl;

import com.hs.ha.Configer;
import com.hs.ha.LogManager;
import com.hs.ha.LogUtil;
import com.hs.ha.Manager;
import com.hs.ha.MonitorThread;
import com.hs.ha.XmlUtil;
import com.hs.ha.monitor.FileInfo;
import com.hs.ha.monitor.FileMonitor;
import com.hs.ha.monitor.FileUtil;
import com.hs.ha.monitor.NetInterfaceMonitor;
import com.hs.ha.rmi.PairMessageService;
import com.hs.ha.vo.MonitorInfo;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PairMessageServiceImpl
extends UnicastRemoteObject
implements PairMessageService {
    private static final long serialVersionUID = -822493647758523970L;
    private static Logger logger = LogManager.getInstance().getHaLog();

    @Override
    public String sendHeartbeat(String ip) throws RemoteException {
        String heartinfo = String.valueOf(Manager.getInstance().isCurrHaPrimary()) + ";" + Manager.getInstance().getLocalHaPrimaryToken() + ";" + Manager.getInstance().getLocalHaRunDate() + ";ok";
        return heartinfo;
    }

    @Override
    public boolean isHaStatusOk() throws RemoteException {
        return Manager.getInstance().isHaStatusOk();
    }

    @Override
    public boolean notifyHaSwitch() throws RemoteException {
        if (Manager.getInstance().isHaStatusOk()) {
            Manager.getInstance().notifySwitch();
            return true;
        }
        return false;
    }

    @Override
    public boolean notifyHaStart() throws RemoteException {
        try {
            logger.info((Object)Configer.getInstance().getLogMessage(21));
            Manager.getInstance().start();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean notifyHaStop() throws RemoteException {
        try {
            logger.info((Object)Configer.getInstance().getLogMessage(22));
            Manager.getInstance().stop();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public List<MonitorInfo> getMonitorInfoList() throws RemoteException {
        return Manager.getInstance().getMonitorInfoList();
    }

    @Override
    public Map<String, FileInfo> getRemoteFileMap(String path) throws RemoteException {
        HashMap<String, FileInfo> rtnValue = null;
        block0: for (MonitorThread mt : Manager.getInstance().getMonitorThreadList()) {
            if (!mt.getMonitor().getName().equals("file")) continue;
            FileMonitor fm = (FileMonitor)mt.getMonitor();
            for (FileUtil fu : fm.getRootList()) {
                if (!fu.getRootpath().equals(path) || !fu.isLocalExist()) continue;
                rtnValue = new HashMap<String, FileInfo>();
                rtnValue.putAll(fu.getLocalFileMap());
                continue block0;
            }
        }
        return rtnValue;
    }

    @Override
    public boolean makeDir(String path, String name, long modifyDate) throws RemoteException {
        boolean rtnValue = false;
        File dirname = new File(path + name + System.getProperty("file.separator"));
        File dirname1 = new File(path + name);
        if (dirname.setLastModified(modifyDate)) {
            logger.debug((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(40), "success", dirname.getName()));
        }
        if (dirname1.setLastModified(modifyDate)) {
            logger.debug((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(40), "success", dirname1.getName()));
        }
        if (!dirname.isDirectory() && !dirname1.isDirectory()) {
            if (dirname.mkdir()) {
                rtnValue = true;
                logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(28), "success", path + name + System.getProperty("file.separator")));
            } else {
                logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(28), "failure", path + name + System.getProperty("file.separator")));
            }
        }
        return rtnValue;
    }

    @Override
    public boolean makeFile(String path, String name, long modifyDate) throws RemoteException {
        boolean rtnValue = false;
        File filename = new File(path + name);
        File dest = new File(path + name.substring(0, name.lastIndexOf(".ha!")));
        if (dest.exists() && !dest.delete()) {
            return rtnValue;
        }
        if (filename.isFile()) {
            try {
                FileOutputStream fos = new FileOutputStream(path + name, false);
                fos.close();
                rtnValue = true;
                if (filename.setLastModified(modifyDate)) {
                    logger.debug((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(40), "success", filename.getName()));
                }
            }
            catch (FileNotFoundException e) {
                rtnValue = false;
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                if (filename.createNewFile()) {
                    rtnValue = true;
                    if (filename.setLastModified(modifyDate)) {
                        logger.debug((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(40), "success", filename.getName()));
                    }
                    logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(29), "success", name, path));
                } else {
                    logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(29), "failure", name, path));
                }
            }
            catch (IOException e) {
                rtnValue = false;
                e.printStackTrace();
            }
        }
        return rtnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendFileString(String path, String name, String docStr) throws RemoteException {
        boolean rtnValue = false;
        OutputStream out = null;
        FilterOutputStream dos = null;
        try {
            out = new FileOutputStream(path + name);
            dos = new DataOutputStream(out);
            dos.write(docStr.getBytes("utf-8"));
            logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(30), "success", name, path));
            rtnValue = true;
        }
        catch (IOException e) {
            rtnValue = false;
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != dos) {
                try {
                    dos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return rtnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean sendFileByte(String path, String name, List<byte[]> byteList, int endLength) throws RemoteException {
        boolean rtnValue = false;
        OutputStream out = null;
        FilterOutputStream dos = null;
        try {
            out = new FileOutputStream(path + name, true);
            dos = new DataOutputStream(out);
            for (int i = 0; i < byteList.size(); ++i) {
                byte[] b = byteList.get(i);
                if (i == byteList.size() - 1) {
                    ((DataOutputStream)dos).write(b, 0, endLength);
                    continue;
                }
                dos.write(b);
            }
            File file = new File(path + name);
            if (file.setLastModified(0L)) {
                logger.debug((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(40), "success", file.getName()));
            }
            logger.info((Object)LogUtil.getInfoMessage(Configer.getInstance().getLogMessage(30), "success", name, path));
            rtnValue = true;
        }
        catch (IOException e) {
            rtnValue = false;
        }
        finally {
            if (null != out) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (null != dos) {
                try {
                    dos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return rtnValue;
    }

    @Override
    public boolean markFile(String path, String name, int mark, long modifyDate) throws RemoteException {
        boolean is = false;
        block0: for (MonitorThread mt : Manager.getInstance().getMonitorThreadList()) {
            if (!mt.getMonitor().getName().equals("file")) continue;
            FileMonitor fm = (FileMonitor)mt.getMonitor();
            for (FileUtil fu : fm.getRootList()) {
                if (path.indexOf(fu.getRootpath()) < 0) continue;
                is = fu.markAcceptFile(name, path, mark, modifyDate);
                continue block0;
            }
        }
        return is;
    }

    @Override
    public boolean resendFile(String path, String name) throws RemoteException {
        boolean is = false;
        block0: for (MonitorThread mt : Manager.getInstance().getMonitorThreadList()) {
            if (!mt.getMonitor().getName().equals("file")) continue;
            FileMonitor fm = (FileMonitor)mt.getMonitor();
            for (FileUtil fu : fm.getRootList()) {
                if (!fu.getRootpath().equals(path)) continue;
                fu.resendAFile(name, path);
                continue block0;
            }
        }
        return is;
    }

    @Override
    public boolean isSendFile(String path) throws RemoteException {
        boolean is = false;
        block0: for (MonitorThread mt : Manager.getInstance().getMonitorThreadList()) {
            if (!mt.getMonitor().getName().equals("file")) continue;
            FileMonitor fm = (FileMonitor)mt.getMonitor();
            for (FileUtil fu : fm.getRootList()) {
                if (!fu.getRootpath().equals(path)) continue;
                is = fu.isSending();
                continue block0;
            }
        }
        return is;
    }

    @Override
    public Map<String, FileInfo> deleteFiles(String path, Map<String, FileInfo> deleteFileMap) throws RemoteException {
        File file;
        HashMap<String, FileInfo> falseFileMap = new HashMap<String, FileInfo>();
        for (Map.Entry<String, FileInfo> fileInfo : deleteFileMap.entrySet()) {
            file = new File(fileInfo.getValue().getPath() + fileInfo.getValue().getName());
            if (fileInfo.getKey().contains("document") || !file.exists() || file.isDirectory() || this.forceDelete(file)) continue;
            falseFileMap.put(fileInfo.getKey(), fileInfo.getValue());
        }
        for (Map.Entry<String, FileInfo> fileInfo : deleteFileMap.entrySet()) {
            file = new File(fileInfo.getValue().getPath() + fileInfo.getValue().getName());
            if (!file.exists() || !file.isDirectory() || this.forceDelete(file)) continue;
            falseFileMap.put(fileInfo.getKey(), fileInfo.getValue());
        }
        return falseFileMap;
    }

    private boolean forceDelete(File f) {
        boolean result = false;
        int tryCount = 0;
        while (!result && tryCount++ < 10) {
            logger.debug((Object)("try to delete file " + f.getName() + " cnt:" + tryCount));
            result = f.delete();
        }
        return result;
    }

    @Override
    public boolean isDeleteFile(String path) throws RemoteException {
        boolean is = false;
        block0: for (MonitorThread mt : Manager.getInstance().getMonitorThreadList()) {
            if (!mt.getMonitor().getName().equals("file")) continue;
            FileMonitor fm = (FileMonitor)mt.getMonitor();
            for (FileUtil fu : fm.getRootList()) {
                if (!fu.getRootpath().equals(path)) continue;
                is = fu.isDeleting();
                continue block0;
            }
        }
        return is;
    }

    @Override
    public boolean canBeArranged() throws RemoteException {
        return Manager.getInstance().canBeArranged();
    }

    @Override
    public boolean modifyRemoteInstallXml(String legoDbPwd, String eSightDbPwd) throws RemoteException {
        return XmlUtil.modifyInstallXml(legoDbPwd, eSightDbPwd);
    }

    @Override
    public boolean modifyTomcatKeystorePass(String keystorePass1, String keystorePass2) throws RemoteException {
        return XmlUtil.modifyTomcatKeystorePass(keystorePass1, keystorePass2);
    }

    @Override
    public boolean isHaveFloatIp() throws RemoteException {
        boolean isHave = false;
        if (NetInterfaceMonitor.isHaveFloatIP()) {
            isHave = true;
        }
        return isHave;
    }

    @Override
    public boolean modifyRemoteCollectorIp() throws RemoteException {
        return FileUtil.modifyRemoteCollectorIp();
    }

    @Override
    public boolean remoteFileDirectoryExist(String path) throws RemoteException {
        boolean isExist = false;
        block0: for (MonitorThread mt : Manager.getInstance().getMonitorThreadList()) {
            if (!mt.getMonitor().getName().equals("file")) continue;
            FileMonitor fm = (FileMonitor)mt.getMonitor();
            for (FileUtil fu : fm.getRootList()) {
                if (!fu.getRootpath().equals(path) || !fu.isLocalExist()) continue;
                isExist = fu.checkCurrentFile(path);
                continue block0;
            }
        }
        return isExist;
    }
}

