/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.enhance;

import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import javassist.CtClass;
import javassist.CtField;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.bytecode.spi.ClassTransformer;

public class EnhancingClassTransformerImpl
implements ClassTransformer {
    private final EnhancementContext enhancementContext;

    public EnhancingClassTransformerImpl(EnhancementContext enhancementContext) {
        this.enhancementContext = enhancementContext;
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        try {
            Enhancer enhancer = new Enhancer(new EnhancementContextWrapper(this.enhancementContext, loader));
            return enhancer.enhance(className, classfileBuffer);
        }
        catch (Exception e) {
            throw new IllegalClassFormatException("Error performing enhancement of " + className){

                @Override
                public synchronized Throwable getCause() {
                    return e;
                }
            };
        }
    }

    private class EnhancementContextWrapper
    implements EnhancementContext {
        private final ClassLoader loadingClassloader;
        private final EnhancementContext wrappedContext;

        private EnhancementContextWrapper(EnhancementContext wrappedContext, ClassLoader loadingClassloader) {
            this.wrappedContext = wrappedContext;
            this.loadingClassloader = loadingClassloader;
        }

        @Override
        public ClassLoader getLoadingClassLoader() {
            return this.loadingClassloader;
        }

        @Override
        public boolean isEntityClass(CtClass classDescriptor) {
            return this.wrappedContext.isEntityClass(classDescriptor);
        }

        @Override
        public boolean isCompositeClass(CtClass classDescriptor) {
            return this.wrappedContext.isCompositeClass(classDescriptor);
        }

        @Override
        public boolean isMappedSuperclassClass(CtClass classDescriptor) {
            return this.wrappedContext.isMappedSuperclassClass(classDescriptor);
        }

        @Override
        public boolean doBiDirectionalAssociationManagement(CtField field) {
            return this.wrappedContext.doBiDirectionalAssociationManagement(field);
        }

        @Override
        public boolean doDirtyCheckingInline(CtClass classDescriptor) {
            return this.wrappedContext.doDirtyCheckingInline(classDescriptor);
        }

        @Override
        public boolean doExtendedEnhancement(CtClass classDescriptor) {
            return this.wrappedContext.doExtendedEnhancement(classDescriptor);
        }

        @Override
        public boolean hasLazyLoadableAttributes(CtClass classDescriptor) {
            return this.wrappedContext.hasLazyLoadableAttributes(classDescriptor);
        }

        @Override
        public boolean isPersistentField(CtField ctField) {
            return this.wrappedContext.isPersistentField(ctField);
        }

        @Override
        public CtField[] order(CtField[] persistentFields) {
            return this.wrappedContext.order(persistentFields);
        }

        @Override
        public boolean isLazyLoadable(CtField field) {
            return this.wrappedContext.isLazyLoadable(field);
        }

        @Override
        public boolean isMappedCollection(CtField field) {
            return this.wrappedContext.isMappedCollection(field);
        }
    }
}

